/*
 * Decompiled with CFR 0.152.
 */
package com.orctom.jenkins.plugin.globalpostscript.runner;

import com.orctom.jenkins.plugin.globalpostscript.GlobalPostScript;
import com.orctom.jenkins.plugin.globalpostscript.ScriptContentLoader;
import com.orctom.jenkins.plugin.globalpostscript.runner.ScriptRunner;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Map;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellScriptRunner
extends ScriptRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(File script, Map<String, String> variables, GlobalPostScript.BadgeManager manager, TaskListener listener) {
        File temp = null;
        try {
            String line;
            String extension = "." + FileUtils.getExtension((String)script.getPath());
            temp = FileUtils.createTempFile((String)"global-post-script-", (String)extension, null);
            FileUtils.fileWrite((File)temp, (String)ScriptContentLoader.getScriptContent(script, variables).getContent());
            Process p = Runtime.getRuntime().exec(new String[]{this.getExecutable(script), temp.getAbsolutePath()});
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuilder builder = new StringBuilder();
            while ((line = br.readLine()) != null) {
                builder.append(line);
                builder.append(System.getProperty("line.separator"));
            }
            this.println(listener, builder.toString());
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.println(listener, "[ERROR] Failed to execute: " + script.getName() + ", " + e.getMessage());
        }
        finally {
            if (null != temp) {
                temp.delete();
            }
        }
    }

    public String getExecutable(File script) {
        return FileUtils.getExtension((String)script.getAbsolutePath());
    }
}

