/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.workflow;

import com.dabsquared.gitlabjenkins.cause.GitLabWebHookCause;
import com.dabsquared.gitlabjenkins.connection.GitLabConnectionProperty;
import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import com.dabsquared.gitlabjenkins.gitlab.api.model.MergeRequest;
import hudson.Extension;
import hudson.model.Cause;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class AddGitLabMergeRequestCommentStep
extends Step {
    private static final Logger LOGGER = Logger.getLogger(AddGitLabMergeRequestCommentStep.class.getName());
    private String comment;

    @DataBoundConstructor
    public AddGitLabMergeRequestCommentStep(String comment) {
        this.comment = StringUtils.isEmpty((String)comment) ? null : comment;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new AddGitLabMergeRequestCommentStepExecution(context, this);
    }

    public String getComment() {
        return this.comment;
    }

    @DataBoundSetter
    public void setComment(String comment) {
        this.comment = StringUtils.isEmpty((String)comment) ? null : comment;
    }

    private static List<GitLabWebHookCause> retrieveCauseRecursive(List<Cause> causes) {
        for (Cause cause : causes) {
            if (!(cause instanceof Cause.UpstreamCause)) continue;
            List upstreamCauses = ((Cause.UpstreamCause)cause).getUpstreamCauses();
            for (Cause upCause : upstreamCauses) {
                if (!(upCause instanceof GitLabWebHookCause)) continue;
                return Collections.singletonList((GitLabWebHookCause)upCause);
            }
            List<GitLabWebHookCause> builds = AddGitLabMergeRequestCommentStep.retrieveCauseRecursive(upstreamCauses);
            if (builds.isEmpty()) continue;
            return builds;
        }
        return Collections.emptyList();
    }

    public static class AddGitLabMergeRequestCommentStepExecution
    extends AbstractSynchronousStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final transient Run<?, ?> run;
        private final transient AddGitLabMergeRequestCommentStep step;

        AddGitLabMergeRequestCommentStepExecution(StepContext context, AddGitLabMergeRequestCommentStep step) throws Exception {
            super(context);
            this.step = step;
            this.run = (Run)context.get(Run.class);
        }

        protected Void run() throws Exception {
            List<GitLabWebHookCause> gitLabWebHookCauses;
            GitLabWebHookCause cause = (GitLabWebHookCause)this.run.getCause(GitLabWebHookCause.class);
            if (cause == null && !CollectionUtils.isEmpty(gitLabWebHookCauses = AddGitLabMergeRequestCommentStep.retrieveCauseRecursive(this.run.getCauses()))) {
                cause = gitLabWebHookCauses.get(0);
            }
            if (cause != null) {
                MergeRequest mergeRequest = cause.getData().getMergeRequest();
                if (mergeRequest != null) {
                    GitLabClient client = GitLabConnectionProperty.getClient(this.run);
                    if (client == null) {
                        this.println("No GitLab connection configured");
                    } else {
                        try {
                            client.createMergeRequestNote(mergeRequest, this.step.getComment());
                        }
                        catch (ProcessingException | WebApplicationException e) {
                            this.printf("Failed to add comment on Merge Request for project '%s': %s%n", mergeRequest.getProjectId(), e.getMessage());
                            LOGGER.log(Level.SEVERE, String.format("Failed to add comment on Merge Request for project '%s'", mergeRequest.getProjectId()), e);
                        }
                    }
                }
            } else {
                LOGGER.log(Level.WARNING, "Add MR comment failure, Cannot retrieve GitLab MR context: Cannot find GitLabWebHookCause");
            }
            return null;
        }

        private void println(String message) {
            TaskListener listener = this.getTaskListener();
            if (listener == null) {
                LOGGER.log(Level.FINE, "failed to print message {0} due to null TaskListener", message);
            } else {
                listener.getLogger().println(message);
            }
        }

        private void printf(String message, Object ... args) {
            TaskListener listener = this.getTaskListener();
            if (listener == null) {
                LOGGER.log(Level.FINE, "failed to print message {0} due to null TaskListener", String.format(message, args));
            } else {
                listener.getLogger().printf(message, args);
            }
        }

        private TaskListener getTaskListener() {
            StepContext context = this.getContext();
            if (!context.isReady()) {
                return null;
            }
            try {
                return (TaskListener)context.get(TaskListener.class);
            }
            catch (Exception x) {
                return null;
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getDisplayName() {
            return "Add comment on GitLab Merge Request";
        }

        public String getFunctionName() {
            return "addGitLabMRComment";
        }

        public Set<Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, TaskListener.class, Run.class);
            return Collections.unmodifiableSet(context);
        }
    }
}

