/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.webhook.status;

import com.dabsquared.gitlabjenkins.util.BuildUtil;
import com.dabsquared.gitlabjenkins.webhook.status.BuildStatusAction;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.io.PrintWriter;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerResponse2;

public class StatusJsonAction
extends BuildStatusAction {
    private String sha1;

    public StatusJsonAction(Job<?, ?> project, String sha1) {
        super(project, BuildUtil.getBuildBySHA1IncludingMergeBuilds(project, sha1));
        this.sha1 = sha1;
    }

    @Override
    protected void writeStatusBody(StaplerResponse2 response, Run<?, ?> build, BuildStatusAction.BuildStatus status) {
        try {
            JSONObject object = new JSONObject();
            object.put("sha", (Object)this.sha1);
            if (build != null) {
                object.put("id", (Object)build.getNumber());
            }
            object.put("status", (Object)status.getValue());
            this.writeBody(response, object);
        }
        catch (IOException e) {
            throw HttpResponses.error((int)500, (String)"Failed to generate response");
        }
    }

    private void writeBody(StaplerResponse2 response, JSONObject body) throws IOException {
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        writer.write(body.toString());
        writer.flush();
        writer.close();
    }
}

