/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.connection;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.dabsquared.gitlabjenkins.connection.GitLabConnection;
import com.dabsquared.gitlabjenkins.connection.GitLabConnectionConfig;
import com.dabsquared.gitlabjenkins.connection.GitLabCredentialMatcher;
import com.dabsquared.gitlabjenkins.connection.Messages;
import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Run;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class GitLabConnectionProperty
extends JobProperty<Job<?, ?>> {
    private String gitLabConnection;
    private String jobCredentialId;
    private boolean useAlternativeCredential = false;

    @DataBoundConstructor
    public GitLabConnectionProperty(String gitLabConnection) {
        this.gitLabConnection = gitLabConnection;
    }

    public String getGitLabConnection() {
        return this.gitLabConnection;
    }

    public String getJobCredentialId() {
        return this.jobCredentialId;
    }

    public boolean isUseAlternativeCredential() {
        return this.useAlternativeCredential;
    }

    @DataBoundSetter
    public void setJobCredentialId(String jobCredentialId) {
        this.jobCredentialId = jobCredentialId;
    }

    @DataBoundSetter
    public void setUseAlternativeCredential(boolean useAlternativeCredential) {
        this.useAlternativeCredential = useAlternativeCredential;
    }

    public GitLabClient getClient() {
        if (StringUtils.isNotEmpty((String)this.gitLabConnection)) {
            GitLabConnectionConfig connectionConfig = (GitLabConnectionConfig)Jenkins.getActiveInstance().getDescriptor(GitLabConnectionConfig.class);
            if (connectionConfig != null) {
                if (this.useAlternativeCredential) {
                    return connectionConfig.getClient(this.gitLabConnection, (Item)this.owner, this.jobCredentialId);
                }
                return connectionConfig.getClient(this.gitLabConnection, null, null);
            }
            return null;
        }
        return null;
    }

    public static GitLabClient getClient(@NonNull Run<?, ?> build) {
        GitLabConnectionProperty connectionProperty;
        Job job = build.getParent();
        if (job != null && (connectionProperty = (GitLabConnectionProperty)job.getProperty(GitLabConnectionProperty.class)) != null) {
            return connectionProperty.getClient();
        }
        return null;
    }

    @Extension
    @Symbol(value={"gitLabConnection"})
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return "GitLab connection";
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (JobProperty)req.bindJSON(GitLabConnectionProperty.class, formData);
        }

        public ListBoxModel doFillGitLabConnectionItems() {
            ListBoxModel options = new ListBoxModel();
            GitLabConnectionConfig descriptor = (GitLabConnectionConfig)Jenkins.getInstance().getDescriptor(GitLabConnectionConfig.class);
            for (GitLabConnection connection : descriptor.getConnections()) {
                options.add(connection.getName(), connection.getName());
            }
            return options;
        }

        public ListBoxModel doFillJobCredentialIdItems(@AncestorInPath Item item, @QueryParameter String url, @QueryParameter String jobCredentialId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(jobCredentialId);
            }
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM, item, StandardCredentials.class, URIRequirementBuilder.fromUri((String)url).build(), (CredentialsMatcher)new GitLabCredentialMatcher()).includeCurrentValue(jobCredentialId);
        }

        @RequirePOST
        @Restricted(value={DoNotUse.class})
        public FormValidation doTestConnection(@QueryParameter String jobCredentialId, @QueryParameter String gitLabConnection, @AncestorInPath Item item) {
            item.checkPermission(Item.CONFIGURE);
            try {
                GitLabConnection gitLabConnectionTested = null;
                GitLabConnectionConfig descriptor = (GitLabConnectionConfig)Jenkins.getInstance().getDescriptor(GitLabConnectionConfig.class);
                for (GitLabConnection connection : descriptor.getConnections()) {
                    if (!gitLabConnection.equals(connection.getName())) continue;
                    gitLabConnectionTested = connection;
                }
                if (gitLabConnectionTested == null) {
                    return FormValidation.error((String)Messages.connection_error("The GitLab Connection does not exist"));
                }
                new GitLabConnection("", gitLabConnectionTested.getUrl(), jobCredentialId, gitLabConnectionTested.getClientBuilderId(), true, (Integer)gitLabConnectionTested.getConnectionTimeout(), (Integer)gitLabConnectionTested.getReadTimeout()).getClient(item, jobCredentialId).getCurrentUser();
                return FormValidation.ok((String)Messages.connection_success());
            }
            catch (WebApplicationException e) {
                return FormValidation.error((String)Messages.connection_error(e.getMessage()));
            }
            catch (ProcessingException e) {
                return FormValidation.error((String)Messages.connection_error(e.getCause().getMessage()));
            }
        }
    }
}

