/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.workflow;

import com.dabsquared.gitlabjenkins.gitlab.api.model.BuildState;
import com.dabsquared.gitlabjenkins.util.CommitStatusUpdater;
import com.dabsquared.gitlabjenkins.workflow.PendingBuildsAction;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class UpdateGitLabCommitStatusStep
extends Step {
    private String name;
    private BuildState state;

    @DataBoundConstructor
    public UpdateGitLabCommitStatusStep(String name, BuildState state) {
        this.name = StringUtils.isEmpty((String)name) ? null : name;
        this.state = state;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new UpdateGitLabCommitStatusStepExecution(context, this);
    }

    public String getName() {
        return this.name;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = StringUtils.isEmpty((String)name) ? null : name;
    }

    public BuildState getState() {
        return this.state;
    }

    @DataBoundSetter
    public void setState(BuildState state) {
        this.state = state;
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getDisplayName() {
            return "Update the commit status in GitLab";
        }

        public String getFunctionName() {
            return "updateGitlabCommitStatus";
        }

        public ListBoxModel doFillStateItems() {
            ListBoxModel options = new ListBoxModel();
            for (BuildState buildState : EnumSet.allOf(BuildState.class)) {
                options.add(buildState.name());
            }
            return options;
        }

        public Set<Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, TaskListener.class, Run.class);
            return Collections.unmodifiableSet(context);
        }
    }

    public static class UpdateGitLabCommitStatusStepExecution
    extends AbstractSynchronousStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final transient Run<?, ?> run;
        private final transient UpdateGitLabCommitStatusStep step;

        UpdateGitLabCommitStatusStepExecution(StepContext context, UpdateGitLabCommitStatusStep step) throws Exception {
            super(context);
            this.step = step;
            this.run = (Run)context.get(Run.class);
        }

        protected Void run() throws Exception {
            String name = StringUtils.isEmpty((String)this.step.name) ? "jenkins" : this.step.name;
            CommitStatusUpdater.updateCommitStatus(this.run, this.getTaskListener(), this.step.state, name);
            PendingBuildsAction action = (PendingBuildsAction)this.run.getAction(PendingBuildsAction.class);
            if (action != null) {
                action.startBuild(name);
            }
            return null;
        }

        private TaskListener getTaskListener() {
            StepContext context = this.getContext();
            if (!context.isReady()) {
                return null;
            }
            try {
                return (TaskListener)context.get(TaskListener.class);
            }
            catch (Exception x) {
                return null;
            }
        }
    }
}

