/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.connection;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.dabsquared.gitlabjenkins.connection.GitLabApiToken;
import com.dabsquared.gitlabjenkins.connection.GitLabApiTokenImpl;
import com.dabsquared.gitlabjenkins.connection.GitLabConnectionConfig;
import com.dabsquared.gitlabjenkins.connection.GitLabCredentialMatcher;
import com.dabsquared.gitlabjenkins.connection.Messages;
import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClientBuilder;
import com.dabsquared.gitlabjenkins.gitlab.api.impl.AutodetectGitLabClientBuilder;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.eclipse.jgit.util.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class GitLabConnection
extends AbstractDescribableImpl<GitLabConnection> {
    private final String name;
    private final String url;
    private transient String apiToken;
    private String apiTokenId;
    private GitLabClientBuilder clientBuilder;
    private final boolean ignoreCertificateErrors;
    private final Integer connectionTimeout;
    private final Integer readTimeout;
    private transient Map<String, GitLabClient> clientCache;

    public GitLabConnection(String name, String url, String apiTokenId, boolean ignoreCertificateErrors, Integer connectionTimeout, Integer readTimeout) {
        this(name, url, apiTokenId, new AutodetectGitLabClientBuilder(), ignoreCertificateErrors, connectionTimeout, readTimeout);
    }

    @DataBoundConstructor
    public GitLabConnection(String name, String url, String apiTokenId, String clientBuilderId, boolean ignoreCertificateErrors, Integer connectionTimeout, Integer readTimeout) {
        this(name, url, apiTokenId, GitLabClientBuilder.getGitLabClientBuilderById(clientBuilderId), ignoreCertificateErrors, connectionTimeout, readTimeout);
    }

    @Restricted(value={NoExternalUse.class})
    public GitLabConnection(String name, String url, String apiTokenId, GitLabClientBuilder clientBuilder, boolean ignoreCertificateErrors, Integer connectionTimeout, Integer readTimeout) {
        this.name = name;
        this.url = url == null ? "" : url;
        this.apiTokenId = apiTokenId;
        this.clientBuilder = clientBuilder;
        this.ignoreCertificateErrors = ignoreCertificateErrors;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.clientCache = new HashMap<String, GitLabClient>();
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getApiTokenId() {
        return this.apiTokenId;
    }

    public String getClientBuilderId() {
        return this.clientBuilder.id();
    }

    public boolean isIgnoreCertificateErrors() {
        return this.ignoreCertificateErrors;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public GitLabClient getClient(Item item, String jobCredentialId) {
        String token;
        String clientId;
        if (jobCredentialId == null || jobCredentialId.equals(this.apiTokenId)) {
            clientId = "global";
            token = this.getApiToken(this.apiTokenId, null);
        } else {
            clientId = "alternative-" + jobCredentialId;
            token = this.getApiToken(jobCredentialId, item);
        }
        if (!this.clientCache.containsKey(clientId)) {
            this.clientCache.put(clientId, this.clientBuilder.buildClient(this.url, token, this.ignoreCertificateErrors, this.connectionTimeout, this.readTimeout));
        }
        return this.clientCache.get(clientId);
    }

    @Restricted(value={NoExternalUse.class})
    private String getApiToken(String apiTokenId, Item item) {
        Object context = item != null ? item.getParent() : Jenkins.get();
        StandardCredentials credentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)this.url).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)apiTokenId));
        if (credentials != null) {
            if (credentials instanceof GitLabApiToken) {
                return ((GitLabApiToken)credentials).getApiToken().getPlainText();
            }
            if (credentials instanceof StringCredentials) {
                return ((StringCredentials)credentials).getSecret().getPlainText();
            }
        }
        throw new IllegalStateException("No credentials found for credentialsId: " + apiTokenId);
    }

    protected GitLabConnection readResolve() {
        if (this.connectionTimeout == null || this.readTimeout == null) {
            return new GitLabConnection(this.name, this.url, this.apiTokenId, new AutodetectGitLabClientBuilder(), this.ignoreCertificateErrors, (Integer)10, (Integer)10);
        }
        if (this.clientBuilder == null) {
            return new GitLabConnection(this.name, this.url, this.apiTokenId, new AutodetectGitLabClientBuilder(), this.ignoreCertificateErrors, this.connectionTimeout, this.readTimeout);
        }
        if (this.clientCache == null) {
            this.clientCache = new HashMap<String, GitLabClient>();
        }
        return this;
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public static void migrate() throws IOException {
        GitLabConnectionConfig descriptor = (GitLabConnectionConfig)Jenkins.get().getDescriptor(GitLabConnectionConfig.class);
        if (descriptor == null) {
            return;
        }
        for (GitLabConnection connection : descriptor.getConnections()) {
            if (connection.apiTokenId != null || connection.apiToken == null) continue;
            for (CredentialsStore credentialsStore : CredentialsProvider.lookupStores((ModelObject)Jenkins.getInstance())) {
                if (!(credentialsStore instanceof SystemCredentialsProvider.StoreImpl)) continue;
                List domains = credentialsStore.getDomains();
                connection.apiTokenId = UUID.randomUUID().toString();
                credentialsStore.addCredentials((Domain)domains.get(0), (Credentials)new GitLabApiTokenImpl(CredentialsScope.SYSTEM, connection.apiTokenId, "GitLab API Token", Secret.fromString((String)connection.apiToken)));
            }
        }
        descriptor.save();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<GitLabConnection> {
        public FormValidation doCheckName(@QueryParameter String id, @QueryParameter String value) {
            if (StringUtils.isEmptyOrNull((String)value)) {
                return FormValidation.error((String)Messages.name_required());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUrl(@QueryParameter String value) {
            if (StringUtils.isEmptyOrNull((String)value)) {
                return FormValidation.error((String)Messages.url_required());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckApiTokenId(@QueryParameter String value) {
            if (StringUtils.isEmptyOrNull((String)value)) {
                return FormValidation.error((String)Messages.apiToken_required());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckConnectionTimeout(@QueryParameter Integer value) {
            if (value == null) {
                return FormValidation.error((String)Messages.connectionTimeout_required());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckReadTimeout(@QueryParameter Integer value) {
            if (value == null) {
                return FormValidation.error((String)Messages.readTimeout_required());
            }
            return FormValidation.ok();
        }

        @RequirePOST
        @Restricted(value={DoNotUse.class})
        public FormValidation doTestConnection(@QueryParameter String url, @QueryParameter String apiTokenId, @QueryParameter String clientBuilderId, @QueryParameter boolean ignoreCertificateErrors, @QueryParameter int connectionTimeout, @QueryParameter int readTimeout) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                new GitLabConnection("", url, apiTokenId, clientBuilderId, ignoreCertificateErrors, (Integer)connectionTimeout, (Integer)readTimeout).getClient(null, null).getCurrentUser();
                return FormValidation.ok((String)Messages.connection_success());
            }
            catch (WebApplicationException e) {
                return FormValidation.error((String)Messages.connection_error(e.getMessage()));
            }
            catch (ProcessingException e) {
                return FormValidation.error((String)Messages.connection_error(e.getCause().getMessage()));
            }
        }

        public ListBoxModel doFillApiTokenIdItems(@QueryParameter String url, @QueryParameter String apiTokenId) {
            if (Jenkins.get().hasPermission(Item.CONFIGURE)) {
                return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), StandardCredentials.class, URIRequirementBuilder.fromUri((String)url).build(), (CredentialsMatcher)new GitLabCredentialMatcher()).includeCurrentValue(apiTokenId);
            }
            return new StandardListBoxModel();
        }

        public ListBoxModel doFillClientBuilderIdItems() {
            ListBoxModel model = new ListBoxModel();
            for (GitLabClientBuilder builder : GitLabClientBuilder.getAllGitLabClientBuilders()) {
                model.add(builder.id());
            }
            return model;
        }
    }
}

