/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.publisher;

import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import com.dabsquared.gitlabjenkins.gitlab.api.model.MergeRequest;
import com.dabsquared.gitlabjenkins.publisher.MergeRequestNotifier;
import com.dabsquared.gitlabjenkins.publisher.Messages;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GitLabMessagePublisher
extends MergeRequestNotifier {
    private static final Logger LOGGER = Logger.getLogger(GitLabMessagePublisher.class.getName());
    private boolean onlyForFailure = false;
    private boolean replaceSuccessNote = false;
    private boolean replaceFailureNote = false;
    private boolean replaceAbortNote = false;
    private boolean replaceUnstableNote = false;
    private String successNoteText;
    private String failureNoteText;
    private String abortNoteText;
    private String unstableNoteText;

    @Deprecated
    public GitLabMessagePublisher(boolean onlyForFailure, boolean replaceSuccessNote, boolean replaceFailureNote, boolean replaceAbortNote, boolean replaceUnstableNote, String successNoteText, String failureNoteText, String abortNoteText, String unstableNoteText) {
        this.onlyForFailure = onlyForFailure;
        this.replaceSuccessNote = replaceSuccessNote;
        this.replaceFailureNote = replaceFailureNote;
        this.replaceAbortNote = replaceAbortNote;
        this.replaceUnstableNote = replaceUnstableNote;
        this.successNoteText = successNoteText;
        this.failureNoteText = failureNoteText;
        this.abortNoteText = abortNoteText;
        this.unstableNoteText = unstableNoteText;
    }

    @DataBoundConstructor
    public GitLabMessagePublisher() {
    }

    public boolean isOnlyForFailure() {
        return this.onlyForFailure;
    }

    public boolean isReplaceSuccessNote() {
        return this.replaceSuccessNote;
    }

    public boolean isReplaceFailureNote() {
        return this.replaceFailureNote;
    }

    public boolean isReplaceAbortNote() {
        return this.replaceAbortNote;
    }

    public boolean isReplaceUnstableNote() {
        return this.replaceUnstableNote;
    }

    public String getSuccessNoteText() {
        return this.successNoteText == null ? "" : this.successNoteText;
    }

    public String getFailureNoteText() {
        return this.failureNoteText == null ? "" : this.failureNoteText;
    }

    public String getAbortNoteText() {
        return this.abortNoteText == null ? "" : this.abortNoteText;
    }

    public String getUnstableNoteText() {
        return this.unstableNoteText == null ? "" : this.unstableNoteText;
    }

    @DataBoundSetter
    public void setOnlyForFailure(boolean onlyForFailure) {
        this.onlyForFailure = onlyForFailure;
    }

    @DataBoundSetter
    public void setReplaceSuccessNote(boolean replaceSuccessNote) {
        this.replaceSuccessNote = replaceSuccessNote;
    }

    @DataBoundSetter
    public void setReplaceFailureNote(boolean replaceFailureNote) {
        this.replaceFailureNote = replaceFailureNote;
    }

    @DataBoundSetter
    public void setReplaceAbortNote(boolean replaceAbortNote) {
        this.replaceAbortNote = replaceAbortNote;
    }

    @DataBoundSetter
    public void setReplaceUnstableNote(boolean replaceUnstableNote) {
        this.replaceUnstableNote = replaceUnstableNote;
    }

    @DataBoundSetter
    public void setSuccessNoteText(String successNoteText) {
        this.successNoteText = successNoteText;
    }

    @DataBoundSetter
    public void setFailureNoteText(String failureNoteText) {
        this.failureNoteText = failureNoteText;
    }

    @DataBoundSetter
    public void setAbortNoteText(String abortNoteText) {
        this.abortNoteText = abortNoteText;
    }

    @DataBoundSetter
    public void setUnstableNoteText(String unstableNoteText) {
        this.unstableNoteText = unstableNoteText;
    }

    @Override
    protected void perform(Run<?, ?> build, TaskListener listener, GitLabClient client, MergeRequest mergeRequest) {
        try {
            if (!this.onlyForFailure || build.getResult() == Result.FAILURE || build.getResult() == Result.UNSTABLE) {
                client.createMergeRequestNote(mergeRequest, this.getNote(build, listener));
            }
        }
        catch (ProcessingException | WebApplicationException e) {
            listener.getLogger().printf("Failed to add comment on Merge Request for project '%s': %s%n", mergeRequest.getProjectId(), e.getMessage());
            LOGGER.log(Level.SEVERE, String.format("Failed to add comment on Merge Request for project '%s'", mergeRequest.getProjectId()), e);
        }
    }

    private String getResultIcon(Result result) {
        if (result == Result.SUCCESS) {
            return ":white_check_mark:";
        }
        if (result == Result.ABORTED) {
            return ":point_up:";
        }
        if (result == Result.UNSTABLE) {
            return ":warning:";
        }
        return ":negative_squared_cross_mark:";
    }

    private static String replaceMacros(Run<?, ?> build, TaskListener listener, String inputString) {
        String returnString = inputString;
        if (build != null && inputString != null) {
            try {
                Map<String, String> messageEnvVars = GitLabMessagePublisher.getEnvVars(build, listener);
                returnString = Util.replaceMacro((String)inputString, messageEnvVars);
            }
            catch (Exception e) {
                listener.getLogger().printf("Couldn't replace macros in message: %s%n", e.getMessage());
                LOGGER.log(Level.WARNING, "Couldn't replace macros in message", e);
            }
        }
        return returnString;
    }

    private static Map<String, String> getEnvVars(Run<?, ?> build, TaskListener listener) {
        HashMap<String, String> messageEnvVars = new HashMap<String, String>();
        if (build != null) {
            messageEnvVars.putAll((Map<String, String>)build.getCharacteristicEnvVars());
            try {
                messageEnvVars.putAll((Map<String, String>)build.getEnvironment(listener));
            }
            catch (Exception e) {
                listener.getLogger().printf("Couldn't get Env Variables: %s%n", e.getMessage());
                LOGGER.log(Level.WARNING, "Couldn't get Env Variables", e);
            }
        }
        return messageEnvVars;
    }

    private String getNote(Run<?, ?> build, TaskListener listener) {
        String message;
        if (this.replaceSuccessNote && build.getResult() == Result.SUCCESS) {
            message = GitLabMessagePublisher.replaceMacros(build, listener, this.getSuccessNoteText());
        } else if (this.replaceAbortNote && build.getResult() == Result.ABORTED) {
            message = GitLabMessagePublisher.replaceMacros(build, listener, this.getAbortNoteText());
        } else if (this.replaceUnstableNote && build.getResult() == Result.UNSTABLE) {
            message = GitLabMessagePublisher.replaceMacros(build, listener, this.getUnstableNoteText());
        } else if (this.replaceFailureNote && build.getResult() == Result.FAILURE) {
            message = GitLabMessagePublisher.replaceMacros(build, listener, this.getFailureNoteText());
        } else {
            String icon = this.getResultIcon(build.getResult());
            String buildUrl = Jenkins.getInstance().getRootUrl() + build.getUrl();
            message = MessageFormat.format("{0} Jenkins Build {1}\n\nResults available at: [Jenkins [{2} #{3}]]({4})", icon, build.getResult().toString(), build.getParent().getDisplayName(), build.getNumber(), buildUrl);
        }
        return message;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.GitLabMessagePublisher_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/gitlab-plugin/help/help-messagesOnResult.html";
        }
    }
}

