/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.trigger.handler.merge;

import com.dabsquared.gitlabjenkins.gitlab.hook.model.Action;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.MergeRequestObjectAttributes;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.State;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;

class StateAndActionConfig
implements Predicate<MergeRequestObjectAttributes> {
    private final Predicate<State> states;
    private final Predicate<Action> actions;

    public StateAndActionConfig(Collection<State> allowedStates, Collection<Action> allowedActions) {
        this(StateAndActionConfig.nullOrContains(allowedStates), StateAndActionConfig.nullOrContains(allowedActions));
    }

    public StateAndActionConfig(Predicate<State> states, Predicate<Action> actions) {
        this.states = states == null ? Predicates.alwaysTrue() : states;
        this.actions = actions == null ? Predicates.alwaysTrue() : actions;
    }

    public boolean apply(MergeRequestObjectAttributes mergeRequestObjectAttributes) {
        return this.states.apply((Object)mergeRequestObjectAttributes.getState()) && this.actions.apply((Object)mergeRequestObjectAttributes.getAction());
    }

    static <T> Predicate<T> nullOrContains(final Collection<T> collection) {
        return collection == null ? Predicates.alwaysTrue() : new Predicate<T>(){

            public boolean apply(@Nullable T t) {
                return t == null || collection.contains(t);
            }
        };
    }

    static <T> Predicate<T> notEqual(final T value) {
        return new Predicate<T>(){

            public boolean apply(@Nullable T t) {
                return !Objects.equals(t, value);
            }
        };
    }
}

