/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import hudson.security.SecurityRealm;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.AbstractAuthenticationToken;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.TokenType;
import org.gitlab.api.models.GitlabGroup;
import org.gitlab.api.models.GitlabProject;
import org.gitlab.api.models.GitlabUser;
import org.jenkinsci.plugins.GitLabOAuthGroupDetails;
import org.jenkinsci.plugins.GitLabOAuthUserDetails;
import org.jenkinsci.plugins.GitLabSecurityRealm;

public class GitLabAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 1L;
    private final String accessToken;
    private final String userName;
    private final transient GitlabAPI gitLabAPI;
    private final transient GitlabUser me;
    private transient GitLabSecurityRealm myRealm = null;
    private static final Cache<String, Set<String>> userOrganizationCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private static final Cache<String, Set<String>> repositoryCollaboratorsCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private static final Cache<String, Set<String>> repositoriesByUserCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private static final Cache<String, Boolean> publicRepositoryCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private static final Cache<String, List<GitlabProject>> groupRepositoriesCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private final List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
    private static final Logger LOGGER = Logger.getLogger(GitLabAuthenticationToken.class.getName());

    public GitLabAuthenticationToken(String accessToken, String gitlabServer, TokenType tokenType) throws IOException {
        super(new GrantedAuthority[0]);
        this.accessToken = accessToken;
        this.gitLabAPI = GitlabAPI.connect((String)gitlabServer, (String)accessToken, (TokenType)tokenType);
        this.me = Objects.requireNonNull(this.gitLabAPI.getUser());
        this.setAuthenticated(true);
        this.userName = this.me.getUsername();
        this.authorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null && jenkins.getSecurityRealm() instanceof GitLabSecurityRealm) {
            if (this.myRealm == null) {
                this.myRealm = (GitLabSecurityRealm)jenkins.getSecurityRealm();
            }
            List myTeams = this.gitLabAPI.getGroups();
            for (GitlabGroup group : myTeams) {
                LOGGER.log(Level.FINE, "Fetch teams for user " + this.userName + " in organization " + group.getName());
                GitLabOAuthGroupDetails gitLabOAuthGroupDetails = new GitLabOAuthGroupDetails(group);
                this.authorities.add(gitLabOAuthGroupDetails.getAuth());
            }
        }
    }

    public static void clearCaches() {
        userOrganizationCache.invalidateAll();
        repositoryCollaboratorsCache.invalidateAll();
        repositoriesByUserCache.invalidateAll();
        groupRepositoriesCache.invalidateAll();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public GitlabAPI getGitLabAPI() {
        return this.gitLabAPI;
    }

    public GrantedAuthority[] getAuthorities() {
        return this.authorities.toArray(new GrantedAuthority[0]);
    }

    public Object getCredentials() {
        return "";
    }

    public String getPrincipal() {
        return this.userName;
    }

    public GitlabUser getMyself() {
        return this.me;
    }

    public boolean hasOrganizationPermission(String candidateName, String organization) {
        Set v = (Set)userOrganizationCache.get((Object)candidateName, unused -> {
            try {
                List groups = this.gitLabAPI.getGroups();
                HashSet<String> groupsNames = new HashSet<String>();
                for (GitlabGroup group : groups) {
                    groupsNames.add(group.getName());
                }
                return groupsNames;
            }
            catch (IOException e) {
                throw new UncheckedIOException("authorization failed for user = " + candidateName, e);
            }
        });
        return v != null && v.contains(organization);
    }

    public boolean hasRepositoryPermission(String repositoryName) {
        return this.myRepositories().contains(repositoryName);
    }

    public Set<String> myRepositories() {
        Set myRepositories = (Set)repositoriesByUserCache.get((Object)this.getName(), unused -> {
            List userRepositoryList = this.gitLabAPI.getProjects();
            Set<Object> repositoryNames = Collections.emptySet();
            if (userRepositoryList != null) {
                repositoryNames = this.listToNames(userRepositoryList);
            }
            return repositoryNames;
        });
        return myRepositories;
    }

    public Set<String> listToNames(Collection<GitlabProject> repositories) {
        HashSet<String> names = new HashSet<String>();
        for (GitlabProject repository : repositories) {
            names.add(repository.getPathWithNamespace());
        }
        return names;
    }

    public boolean isPublicRepository(String repositoryName) {
        Boolean isPublic = (Boolean)publicRepositoryCache.get((Object)repositoryName, unused -> {
            GitlabProject repository = this.loadRepository(repositoryName);
            if (repository == null) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE.equals(repository.isPublic());
        });
        return isPublic != null && isPublic != false;
    }

    public GitlabUser loadUser(String username) {
        try {
            List users;
            if (this.gitLabAPI != null && this.isAuthenticated() && CollectionUtils.isNotEmpty((Collection)(users = this.gitLabAPI.findUsers(username)))) {
                return (GitlabUser)users.get(0);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINEST, e.getMessage(), e);
        }
        return null;
    }

    public GitlabGroup loadOrganization(String organization) {
        if (StringUtils.isEmpty((String)organization)) {
            return null;
        }
        try {
            List gitLabGroups;
            if (this.gitLabAPI != null && this.isAuthenticated() && !(gitLabGroups = this.gitLabAPI.getGroups()).isEmpty()) {
                return gitLabGroups.stream().filter(group -> group.getName().equalsIgnoreCase(organization)).findFirst().orElse(null);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINEST, e.getMessage(), e);
        }
        return null;
    }

    public GitlabProject loadRepository(String repositoryName) {
        try {
            if (this.gitLabAPI != null && this.isAuthenticated()) {
                return this.gitLabAPI.getProject((Serializable)((Object)repositoryName));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Looks like a bad GitLab URL OR the Jenkins user does not have access to the repository{0}", repositoryName);
        }
        return null;
    }

    public GitLabOAuthUserDetails getUserDetails(String username) {
        GitlabUser user = this.loadUser(username);
        if (user != null) {
            ArrayList<GrantedAuthorityImpl> groups = new ArrayList<GrantedAuthorityImpl>();
            try {
                List gitLabGroups = this.gitLabAPI.getGroups();
                for (GitlabGroup gitlabGroup : gitLabGroups) {
                    groups.add(new GrantedAuthorityImpl(gitlabGroup.getName()));
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, e.getMessage(), e);
            }
            return new GitLabOAuthUserDetails(user, groups.toArray(new GrantedAuthority[0]));
        }
        return null;
    }

    public List<GitlabProject> getGroupProjects(GitlabGroup group) {
        List groupProjects = (List)groupRepositoriesCache.get((Object)group.getFullPath(), unused -> this.gitLabAPI.getGroupProjects(group));
        return groupProjects;
    }
}

