/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.scm.SCM;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.trait.SCMHeadPrefilter;
import org.jenkinsci.plugins.github.extension.GHEventsSubscriber;
import org.jenkinsci.plugins.github.extension.GHSubscriberEvent;
import org.jenkinsci.plugins.github_branch_source.BranchSCMHead;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMNavigator;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSourceContext;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMHead;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMRevision;
import org.jenkinsci.plugins.github_branch_source.RepositoryUriResolver;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;

@Extension
public class PullRequestGHEventSubscriber
extends GHEventsSubscriber {
    private static final Logger LOGGER = Logger.getLogger(PullRequestGHEventSubscriber.class.getName());
    private static final Pattern REPOSITORY_NAME_PATTERN = Pattern.compile("https?://([^/]+)/([^/]+)/([^/]+)");

    protected boolean isApplicable(@Nullable Item project) {
        if (project != null) {
            SCMSourceOwner owner;
            if (project instanceof SCMSourceOwner) {
                owner = (SCMSourceOwner)project;
                for (SCMSource source : owner.getSCMSources()) {
                    if (!(source instanceof GitHubSCMSource)) continue;
                    return true;
                }
            }
            if (project.getParent() instanceof SCMSourceOwner) {
                owner = (SCMSourceOwner)project.getParent();
                for (SCMSource source : owner.getSCMSources()) {
                    if (!(source instanceof GitHubSCMSource)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected Set<GHEvent> events() {
        return Sets.immutableEnumSet((Enum)GHEvent.PULL_REQUEST, (Enum[])new GHEvent[0]);
    }

    protected void onEvent(GHSubscriberEvent event) {
        try {
            GHEventPayload.PullRequest p = (GHEventPayload.PullRequest)GitHub.offline().parseEventPayload((Reader)new StringReader((String)event.getPayload()), GHEventPayload.PullRequest.class);
            String action = p.getAction();
            String repoUrl = p.getRepository().getHtmlUrl().toExternalForm();
            LOGGER.log(Level.INFO, "Received {0} for {1} from {2}", new Object[]{event.getGHEvent(), repoUrl, event.getOrigin()});
            Matcher matcher = REPOSITORY_NAME_PATTERN.matcher(repoUrl);
            if (matcher.matches()) {
                GitHubRepositoryName changedRepository = GitHubRepositoryName.create((String)repoUrl);
                if (changedRepository == null) {
                    LOGGER.log(Level.WARNING, "Malformed repository URL {0}", repoUrl);
                    return;
                }
                if ("opened".equals(action)) {
                    this.fireAfterDelay(new SCMHeadEventImpl(SCMEvent.Type.CREATED, event.getTimestamp(), p, changedRepository, event.getOrigin()));
                } else if ("reopened".equals(action) || "synchronize".equals(action)) {
                    this.fireAfterDelay(new SCMHeadEventImpl(SCMEvent.Type.UPDATED, event.getTimestamp(), p, changedRepository, event.getOrigin()));
                } else if ("closed".equals(action)) {
                    this.fireAfterDelay(new SCMHeadEventImpl(SCMEvent.Type.REMOVED, event.getTimestamp(), p, changedRepository, event.getOrigin()));
                }
            }
        }
        catch (IOException e) {
            LogRecord lr = new LogRecord(Level.WARNING, "Could not parse {0} event from {1} with payload: {2}");
            lr.setParameters(new Object[]{event.getGHEvent(), event.getOrigin(), event.getPayload()});
            lr.setThrown(e);
            LOGGER.log(lr);
        }
    }

    private void fireAfterDelay(SCMHeadEventImpl e) {
        SCMHeadEvent.fireLater((SCMHeadEvent)e, (long)GitHubSCMSource.getEventDelaySeconds(), (TimeUnit)TimeUnit.SECONDS);
    }

    private static class SCMHeadEventImpl
    extends SCMHeadEvent<GHEventPayload.PullRequest> {
        private final String repoHost;
        private final String repoOwner;
        private final String repository;

        public SCMHeadEventImpl(SCMEvent.Type type, long timestamp, GHEventPayload.PullRequest pullRequest, GitHubRepositoryName repo, String origin) {
            super(type, timestamp, (Object)pullRequest, origin);
            this.repoHost = repo.getHost();
            this.repoOwner = pullRequest.getRepository().getOwnerName();
            this.repository = pullRequest.getRepository().getName();
        }

        private boolean isApiMatch(String apiUri) {
            return this.repoHost.equalsIgnoreCase(RepositoryUriResolver.hostnameFromApiUri(apiUri));
        }

        public boolean isMatch(@NonNull SCMNavigator navigator) {
            return navigator instanceof GitHubSCMNavigator && this.repoOwner.equalsIgnoreCase(((GitHubSCMNavigator)navigator).getRepoOwner());
        }

        public String descriptionFor(@NonNull SCMNavigator navigator) {
            String action = ((GHEventPayload.PullRequest)this.getPayload()).getAction();
            if (action != null) {
                switch (action) {
                    case "opened": {
                        return "Pull request #" + ((GHEventPayload.PullRequest)this.getPayload()).getNumber() + " opened in repository " + this.repository;
                    }
                    case "reopened": {
                        return "Pull request #" + ((GHEventPayload.PullRequest)this.getPayload()).getNumber() + " reopened in repository " + this.repository;
                    }
                    case "synchronize": {
                        return "Pull request #" + ((GHEventPayload.PullRequest)this.getPayload()).getNumber() + " updated in repository " + this.repository;
                    }
                    case "closed": {
                        return "Pull request #" + ((GHEventPayload.PullRequest)this.getPayload()).getNumber() + " closed in repository " + this.repository;
                    }
                }
            }
            return "Pull request #" + ((GHEventPayload.PullRequest)this.getPayload()).getNumber() + " event in repository " + this.repository;
        }

        public String descriptionFor(SCMSource source) {
            String action = ((GHEventPayload.PullRequest)this.getPayload()).getAction();
            if (action != null) {
                switch (action) {
                    case "opened": {
                        return "Pull request #" + ((GHEventPayload.PullRequest)this.getPayload()).getNumber() + " opened";
                    }
                    case "reopened": {
                        return "Pull request #" + ((GHEventPayload.PullRequest)this.getPayload()).getNumber() + " reopened";
                    }
                    case "synchronize": {
                        return "Pull request #" + ((GHEventPayload.PullRequest)this.getPayload()).getNumber() + " updated";
                    }
                    case "closed": {
                        return "Pull request #" + ((GHEventPayload.PullRequest)this.getPayload()).getNumber() + " closed";
                    }
                }
            }
            return "Pull request #" + ((GHEventPayload.PullRequest)this.getPayload()).getNumber() + " event";
        }

        public String description() {
            String action = ((GHEventPayload.PullRequest)this.getPayload()).getAction();
            if (action != null) {
                switch (action) {
                    case "opened": {
                        return "Pull request #" + ((GHEventPayload.PullRequest)this.getPayload()).getNumber() + " opened in repository " + this.repoOwner + "/" + this.repository;
                    }
                    case "reopened": {
                        return "Pull request #" + ((GHEventPayload.PullRequest)this.getPayload()).getNumber() + " reopened in repository " + this.repoOwner + "/" + this.repository;
                    }
                    case "synchronize": {
                        return "Pull request #" + ((GHEventPayload.PullRequest)this.getPayload()).getNumber() + " updated in repository " + this.repoOwner + "/" + this.repository;
                    }
                    case "closed": {
                        return "Pull request #" + ((GHEventPayload.PullRequest)this.getPayload()).getNumber() + " closed in repository " + this.repoOwner + "/" + this.repository;
                    }
                }
            }
            return "Pull request #" + ((GHEventPayload.PullRequest)this.getPayload()).getNumber() + " event in repository " + this.repoOwner + "/" + this.repository;
        }

        @NonNull
        public String getSourceName() {
            return this.repository;
        }

        @NonNull
        public Map<SCMHead, SCMRevision> heads(@NonNull SCMSource source) {
            GHUser user;
            if (!(source instanceof GitHubSCMSource && this.isApiMatch(((GitHubSCMSource)source).getApiUri()) && this.repoOwner.equalsIgnoreCase(((GitHubSCMSource)source).getRepoOwner()) && this.repository.equalsIgnoreCase(((GitHubSCMSource)source).getRepository()))) {
                return Collections.emptyMap();
            }
            GitHubSCMSource src = (GitHubSCMSource)source;
            GHEventPayload.PullRequest pullRequest = (GHEventPayload.PullRequest)this.getPayload();
            GHPullRequest ghPullRequest = pullRequest.getPullRequest();
            GHRepository repo = pullRequest.getRepository();
            String prRepoName = repo.getName();
            if (!prRepoName.matches("^[0-9A-Za-z._-]+$")) {
                return Collections.emptyMap();
            }
            try {
                user = ghPullRequest.getHead().getUser();
            }
            catch (IOException e) {
                return Collections.emptyMap();
            }
            String prOwnerName = user.getLogin();
            if (!prOwnerName.matches("^[A-Za-z0-9](?:[A-Za-z0-9]|-(?=[A-Za-z0-9])){0,38}$")) {
                return Collections.emptyMap();
            }
            if (!ghPullRequest.getBase().getSha().matches("^[a-fA-F0-9]{40}$")) {
                return Collections.emptyMap();
            }
            if (!ghPullRequest.getHead().getSha().matches("^[a-fA-F0-9]{40}$")) {
                return Collections.emptyMap();
            }
            boolean fork = !src.getRepoOwner().equalsIgnoreCase(prOwnerName);
            HashMap<SCMHead, SCMRevision> result = new HashMap<SCMHead, SCMRevision>();
            GitHubSCMSourceContext context = (GitHubSCMSourceContext)new GitHubSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(src.getTraits());
            if (!fork && context.wantBranches()) {
                String branchName = ghPullRequest.getHead().getRef();
                BranchSCMHead head = new BranchSCMHead(branchName);
                boolean excluded = false;
                for (SCMHeadPrefilter prefilter : context.prefilters()) {
                    if (!prefilter.isExcluded(source, (SCMHead)head)) continue;
                    excluded = true;
                    break;
                }
                if (!excluded) {
                    AbstractGitSCMSource.SCMRevisionImpl hash = new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head, ghPullRequest.getHead().getSha());
                    result.put(head, (SCMRevision)hash);
                }
            }
            if (context.wantPRs()) {
                int number = pullRequest.getNumber();
                Set<ChangeRequestCheckoutStrategy> strategies = fork ? context.forkPRStrategies() : context.originPRStrategies();
                for (ChangeRequestCheckoutStrategy strategy : strategies) {
                    PullRequestSCMRevision revision;
                    PullRequestSCMHead head;
                    String branchName = strategies.size() == 1 ? "PR-" + number : "PR-" + number + "-" + strategy.name().toLowerCase(Locale.ENGLISH);
                    switch (strategy) {
                        case MERGE: {
                            head = new PullRequestSCMHead(ghPullRequest, branchName, true);
                            revision = null;
                            break;
                        }
                        default: {
                            head = new PullRequestSCMHead(ghPullRequest, branchName, false);
                            revision = new PullRequestSCMRevision(head, ghPullRequest.getBase().getSha(), ghPullRequest.getHead().getSha());
                        }
                    }
                    boolean excluded = false;
                    for (SCMHeadPrefilter prefilter : context.prefilters()) {
                        if (!prefilter.isExcluded(source, (SCMHead)head)) continue;
                        excluded = true;
                        break;
                    }
                    if (excluded) continue;
                    result.put(head, (SCMRevision)revision);
                }
            }
            return result;
        }

        public boolean isMatch(@NonNull SCM scm) {
            return false;
        }
    }
}

