/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.browser.GithubWeb;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.security.ACL;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.MergeWithGitSCMExtension;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.mixin.TagSCMHead;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RefSpec;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.HttpsRepositoryUriResolver;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMHead;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMRevision;
import org.jenkinsci.plugins.github_branch_source.RepositoryUriResolver;
import org.jenkinsci.plugins.github_branch_source.SshRepositoryUriResolver;

public class GitHubSCMBuilder
extends GitSCMBuilder<GitHubSCMBuilder> {
    private static final HttpsRepositoryUriResolver HTTPS = new HttpsRepositoryUriResolver();
    private static final SshRepositoryUriResolver SSH = new SshRepositoryUriResolver();
    private static final String API_V3 = "api/v3";
    @CheckForNull
    private final SCMSourceOwner context;
    @NonNull
    private final String apiUri;
    @NonNull
    private final String repoOwner;
    @NonNull
    private final String repository;
    @CheckForNull
    private final URL repositoryUrl;

    public GitHubSCMBuilder(@NonNull GitHubSCMSource source, @NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        super(head, revision, GitHubSCMBuilder.guessRemote(source), source.getCredentialsId());
        String repoUrl;
        this.context = source.getOwner();
        this.apiUri = StringUtils.defaultIfBlank((String)source.getApiUri(), (String)"https://api.github.com");
        this.repoOwner = source.getRepoOwner();
        this.repository = source.getRepository();
        this.repositoryUrl = source.getRepositoryUrl();
        this.withoutRefSpecs();
        if (head instanceof PullRequestSCMHead) {
            PullRequestSCMHead h = (PullRequestSCMHead)head;
            this.withRefSpec("+refs/pull/" + h.getId() + "/head:refs/remotes/@{remote}/" + head.getName());
            repoUrl = this.repositoryUrl(h.getSourceOwner(), h.getSourceRepo());
        } else if (head instanceof TagSCMHead) {
            this.withRefSpec("+refs/tags/" + head.getName() + ":refs/tags/" + head.getName());
            repoUrl = this.repositoryUrl(this.repoOwner, this.repository);
        } else {
            this.withRefSpec("+refs/heads/" + head.getName() + ":refs/remotes/@{remote}/" + head.getName());
            repoUrl = this.repositoryUrl(this.repoOwner, this.repository);
        }
        if (repoUrl != null) {
            this.withBrowser((GitRepositoryBrowser)new GithubWeb(repoUrl));
        }
    }

    private static String guessRemote(GitHubSCMSource source) {
        String apiUri = StringUtils.removeEnd((String)source.getApiUri(), (String)"/");
        apiUri = StringUtils.isBlank((String)apiUri) || "https://api.github.com".equals(apiUri) ? "https://github.com" : StringUtils.removeEnd((String)apiUri, (String)"/api/v3");
        return apiUri + "/" + source.getRepoOwner() + "/" + source.getRepository() + ".git";
    }

    @CheckForNull
    public final String repositoryUrl(String owner, String repo) {
        if (this.repositoryUrl != null) {
            if (this.repoOwner.equals(owner) && this.repository.equals(repo)) {
                return this.repositoryUrl.toExternalForm();
            }
            return this.repositoryUrl.toExternalForm().replace(this.repoOwner + "/" + this.repository, owner + "/" + repo);
        }
        if (StringUtils.isBlank((String)this.apiUri) || "https://api.github.com".equals(this.apiUri)) {
            return "https://github.com/" + owner + "/" + repo;
        }
        if (StringUtils.endsWith((String)StringUtils.removeEnd((String)this.apiUri, (String)"/"), (String)"/api/v3")) {
            return StringUtils.removeEnd((String)StringUtils.removeEnd((String)this.apiUri, (String)"/"), (String)API_V3) + owner + "/" + repo;
        }
        return null;
    }

    @NonNull
    public final RepositoryUriResolver uriResolver() {
        String credentialsId = this.credentialsId();
        return GitHubSCMBuilder.uriResolver((Item)this.context, this.apiUri, credentialsId);
    }

    public static RepositoryUriResolver uriResolver(@CheckForNull Item context, @NonNull String apiUri, @CheckForNull String credentialsId) {
        if (credentialsId == null) {
            return HTTPS;
        }
        StandardCredentials credentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)(context instanceof Queue.Task ? Tasks.getDefaultAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM), (List)URIRequirementBuilder.create().withHostname(RepositoryUriResolver.hostnameFromApiUri(apiUri)).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), CredentialsMatchers.instanceOf(StandardCredentials.class)}));
        if (credentials instanceof SSHUserPrivateKey) {
            return SSH;
        }
        return HTTPS;
    }

    @NonNull
    public final GitHubSCMBuilder withGitHubRemote() {
        String repoUrl;
        this.withRemote(this.uriResolver().getRepositoryUri(this.apiUri, this.repoOwner, this.repository));
        SCMHead h = this.head();
        if (h instanceof PullRequestSCMHead) {
            PullRequestSCMHead head = (PullRequestSCMHead)h;
            repoUrl = this.repositoryUrl(head.getSourceOwner(), head.getSourceRepo());
        } else {
            repoUrl = this.repositoryUrl(this.repoOwner, this.repository);
        }
        if (repoUrl != null) {
            this.withBrowser((GitRepositoryBrowser)new GithubWeb(repoUrl));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public GitSCM build() {
        SCMHead h = this.head();
        SCMRevision r = this.revision();
        try {
            this.withGitHubRemote();
            if (h instanceof PullRequestSCMHead) {
                PullRequestSCMHead head = (PullRequestSCMHead)h;
                if (head.isMerge()) {
                    String name = head.getTarget().getName();
                    String localName = "remotes/" + this.remoteName() + "/" + name;
                    HashSet<String> localNames = new HashSet<String>();
                    boolean match = false;
                    String targetSrc = "refs/heads/" + name;
                    String targetDst = "refs/remotes/" + this.remoteName() + "/" + name;
                    for (RefSpec b : this.asRefSpecs()) {
                        String dst = b.getDestination();
                        assert (dst.startsWith("refs/")) : "All git references must start with refs/";
                        if (targetSrc.equals(b.getSource())) {
                            if (targetDst.equals(dst)) {
                                match = true;
                                continue;
                            }
                            localName = dst.substring("refs/".length());
                            match = true;
                            continue;
                        }
                        localNames.add(dst.substring("refs/".length()));
                    }
                    if (!match) {
                        if (localNames.contains(localName)) {
                            localName = "remotes/" + this.remoteName() + "/upstream-" + name;
                        }
                        if (localNames.contains(localName)) {
                            localName = "remotes/" + this.remoteName() + "/pr-" + head.getNumber() + "-upstream-" + name;
                        }
                        if (localNames.contains(localName)) {
                            Random entropy = new Random();
                            while (localNames.contains(localName)) {
                                localName = "remotes/" + this.remoteName() + "/pr-" + head.getNumber() + "-upstream-" + name + "-" + Integer.toHexString(entropy.nextInt(Integer.MAX_VALUE));
                            }
                        }
                        this.withRefSpec("+refs/heads/" + name + ":refs/" + localName);
                    }
                    this.withExtension((GitSCMExtension)new MergeWithGitSCMExtension(localName, r instanceof PullRequestSCMRevision ? ((PullRequestSCMRevision)r).getBaseHash() : null));
                }
                if (r instanceof PullRequestSCMRevision) {
                    PullRequestSCMRevision rev = (PullRequestSCMRevision)r;
                    this.withRevision((SCMRevision)new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head, rev.getPullHash()));
                }
            }
            GitSCM gitSCM = super.build();
            return gitSCM;
        }
        finally {
            this.withHead(h);
            this.withRevision(r);
        }
    }
}

