/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.Hudson;
import java.io.IOException;
import java.io.ObjectStreamException;
import jenkins.scm.api.metadata.AvatarMetadataAction;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.github_branch_source.Messages;
import org.kohsuke.github.GHUser;
import org.kohsuke.stapler.Stapler;

public class GitHubOrgMetadataAction
extends AvatarMetadataAction {
    @CheckForNull
    private final String avatar;

    public GitHubOrgMetadataAction(@NonNull GHUser org) throws IOException {
        this(org.getAvatarUrl());
    }

    public GitHubOrgMetadataAction(@CheckForNull String avatar) {
        this.avatar = Util.fixEmpty((String)avatar);
    }

    public GitHubOrgMetadataAction(@NonNull GitHubOrgMetadataAction that) {
        this(that.getAvatar());
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.avatar != null && StringUtils.isBlank((String)this.avatar)) {
            return new GitHubOrgMetadataAction(this);
        }
        return this;
    }

    @CheckForNull
    public String getAvatar() {
        return Util.fixEmpty((String)this.avatar);
    }

    public String getAvatarImageOf(String size) {
        if (this.avatar == null) {
            String image = this.avatarIconClassNameImageOf(this.getAvatarIconClassName(), size);
            return image != null ? image : Stapler.getCurrentRequest().getContextPath() + Hudson.RESOURCE_PATH + "/plugin/github-branch-source/images/" + size + "/github-logo.png";
        }
        String[] xy = size.split("x");
        if (xy.length == 0) {
            return this.avatar;
        }
        if (this.avatar.contains("?")) {
            return this.avatar + "&s=" + xy[0];
        }
        return this.avatar + "?s=" + xy[0];
    }

    public String getAvatarIconClassName() {
        return this.avatar == null ? "icon-github-logo" : null;
    }

    public String getAvatarDescription() {
        return Messages.GitHubOrgMetadataAction_IconDescription();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GitHubOrgMetadataAction that = (GitHubOrgMetadataAction)((Object)o);
        return this.avatar != null ? this.avatar.equals(that.avatar) : that.avatar == null;
    }

    public int hashCode() {
        return this.avatar != null ? this.avatar.hashCode() : 0;
    }

    public String toString() {
        return "GitHubOrgMetadataAction{, avatar='" + this.avatar + '\'' + "}";
    }
}

