/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.model.listeners.SCMListener;
import hudson.model.queue.QueueListener;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.github_branch_source.AbstractGitHubNotificationStrategy;
import org.jenkinsci.plugins.github_branch_source.Connector;
import org.jenkinsci.plugins.github_branch_source.GitHubNotificationContext;
import org.jenkinsci.plugins.github_branch_source.GitHubNotificationRequest;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSourceContext;
import org.jenkinsci.plugins.github_branch_source.Messages;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMHead;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMRevision;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;

public class GitHubBuildStatusNotification {
    private static final Logger LOGGER = Logger.getLogger(GitHubBuildStatusNotification.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createBuildCommitStatus(Run<?, ?> build, TaskListener listener) {
        block12: {
            SCMRevision revision;
            SCMSource src = SCMSource.SourceByItem.findSource((Item)build.getParent());
            SCMRevision sCMRevision = revision = src != null ? SCMRevisionAction.getRevision((SCMSource)src, build) : null;
            if (revision != null) {
                try {
                    GitHub gitHub = GitHubBuildStatusNotification.lookUpGitHub(build.getParent());
                    try {
                        GHRepository repo = GitHubBuildStatusNotification.lookUpRepo(gitHub, build.getParent());
                        if (repo != null) {
                            Result result = build.getResult();
                            String revisionToNotify = GitHubBuildStatusNotification.resolveHeadCommit(revision);
                            SCMHead head = revision.getHead();
                            List<AbstractGitHubNotificationStrategy> strategies = ((GitHubSCMSourceContext)new GitHubSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(((GitHubSCMSource)src).getTraits())).notificationStrategies();
                            for (AbstractGitHubNotificationStrategy strategy : strategies) {
                                GitHubNotificationContext notificationContext = GitHubNotificationContext.build(null, build, src, head);
                                List<GitHubNotificationRequest> details = strategy.notifications(notificationContext, listener);
                                for (GitHubNotificationRequest request : details) {
                                    boolean ignoreError = request.isIgnoreError();
                                    try {
                                        repo.createCommitStatus(revisionToNotify, request.getState(), request.getUrl(), request.getMessage(), request.getContext());
                                    }
                                    catch (FileNotFoundException fnfe) {
                                        if (ignoreError) continue;
                                        listener.getLogger().format("%nCould not update commit status, please check if your scan credentials belong to a member of the organization or a collaborator of the repository and repo:status scope is selected%n%n", new Object[0]);
                                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                                        LOGGER.log(Level.FINE, "Could not update commit status, for run " + build.getFullDisplayName() + " please check if your scan credentials belong to a member of the organization or a collaborator of the repository and repo:status scope is selected", fnfe);
                                    }
                                }
                            }
                            if (result != null) {
                                listener.getLogger().format("%n" + Messages.GitHubBuildStatusNotification_CommitStatusSet() + "%n%n", new Object[0]);
                            }
                        }
                    }
                    finally {
                        Connector.release(gitHub);
                    }
                }
                catch (IOException ioe) {
                    listener.getLogger().format("%nCould not update commit status. Message: %s%n%n", ioe.getMessage());
                    if (!LOGGER.isLoggable(Level.FINE)) break block12;
                    LOGGER.log(Level.FINE, "Could not update commit status of run " + build.getFullDisplayName(), ioe);
                }
            }
        }
    }

    @CheckForNull
    private static GHRepository lookUpRepo(GitHub github, @NonNull Job<?, ?> job) throws IOException {
        GitHubSCMSource source;
        if (github == null) {
            return null;
        }
        SCMSource src = SCMSource.SourceByItem.findSource(job);
        if (src instanceof GitHubSCMSource && (source = (GitHubSCMSource)src).getScanCredentialsId() != null) {
            return github.getRepository(source.getRepoOwner() + "/" + source.getRepository());
        }
        return null;
    }

    @CheckForNull
    private static GitHub lookUpGitHub(@NonNull Job<?, ?> job) throws IOException {
        SCMSource src = SCMSource.SourceByItem.findSource(job);
        if (src instanceof GitHubSCMSource) {
            GitHubSCMSource source = (GitHubSCMSource)src;
            if (((GitHubSCMSourceContext)new GitHubSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(source.getTraits())).notificationsDisabled()) {
                return null;
            }
            if (source.getScanCredentialsId() != null) {
                return Connector.connect(source.getApiUri(), Connector.lookupScanCredentials(job, source.getApiUri(), source.getScanCredentialsId(), source.getRepoOwner()));
            }
        }
        return null;
    }

    private static String resolveHeadCommit(SCMRevision revision) throws IllegalArgumentException {
        if (revision instanceof AbstractGitSCMSource.SCMRevisionImpl) {
            return ((AbstractGitSCMSource.SCMRevisionImpl)revision).getHash();
        }
        if (revision instanceof PullRequestSCMRevision) {
            return ((PullRequestSCMRevision)revision).getPullHash();
        }
        throw new IllegalArgumentException("did not recognize " + revision);
    }

    private GitHubBuildStatusNotification() {
    }

    @Extension
    public static class JobCompletedListener
    extends RunListener<Run<?, ?>> {
        public void onCompleted(Run<?, ?> build, TaskListener listener) {
            GitHubBuildStatusNotification.createBuildCommitStatus(build, listener);
        }
    }

    @Extension
    public static class JobCheckOutListener
    extends SCMListener {
        public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState pollingBaseline) throws Exception {
            GitHubBuildStatusNotification.createBuildCommitStatus(build, listener);
        }
    }

    @Extension
    public static class JobScheduledListener
    extends QueueListener {
        public void onEnterWaiting(Queue.WaitingItem wi) {
            if (!(wi.task instanceof Job)) {
                return;
            }
            final long taskId = wi.getId();
            final Job job = (Job)wi.task;
            final SCMSource source = SCMSource.SourceByItem.findSource((Item)job);
            if (!(source instanceof GitHubSCMSource)) {
                return;
            }
            final SCMHead head = SCMHead.HeadByItem.findHead((Item)job);
            if (!(head instanceof PullRequestSCMHead)) {
                return;
            }
            final GitHubSCMSourceContext sourceContext = (GitHubSCMSourceContext)new GitHubSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(((GitHubSCMSource)source).getTraits());
            if (sourceContext.notificationsDisabled()) {
                return;
            }
            Computer.threadPoolForRemoting.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        GitHub gitHub = GitHubBuildStatusNotification.lookUpGitHub(job);
                        try {
                            if (gitHub == null || gitHub.rateLimit().remaining < 8) {
                                return;
                            }
                            String hash = GitHubBuildStatusNotification.resolveHeadCommit(source.fetch(head, null));
                            if (gitHub.rateLimit().remaining < 8) {
                                return;
                            }
                            GHRepository repo = GitHubBuildStatusNotification.lookUpRepo(gitHub, job);
                            if (repo != null) {
                                if (Jenkins.get().getQueue().getItem(taskId) instanceof Queue.LeftItem) {
                                    return;
                                }
                                List<AbstractGitHubNotificationStrategy> strategies = sourceContext.notificationStrategies();
                                for (AbstractGitHubNotificationStrategy strategy : strategies) {
                                    GitHubNotificationContext notificationContext = GitHubNotificationContext.build(job, null, source, head);
                                    List<GitHubNotificationRequest> details = strategy.notifications(notificationContext, null);
                                    for (GitHubNotificationRequest request : details) {
                                        boolean ignoreErrors = request.isIgnoreError();
                                        try {
                                            repo.createCommitStatus(hash, request.getState(), request.getUrl(), request.getMessage(), request.getContext());
                                        }
                                        catch (FileNotFoundException e) {
                                            if (ignoreErrors) continue;
                                            LOGGER.log(Level.WARNING, "Could not update commit status to PENDING. Valid scan credentials? Valid scopes?", LOGGER.isLoggable(Level.FINE) ? e : null);
                                        }
                                    }
                                }
                            }
                        }
                        finally {
                            Connector.release(gitHub);
                        }
                    }
                    catch (FileNotFoundException e) {
                        LOGGER.log(Level.WARNING, "Could not update commit status to PENDING. Valid scan credentials? Valid scopes?", LOGGER.isLoggable(Level.FINE) ? e : null);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Could not update commit status to PENDING. Message: " + e.getMessage(), LOGGER.isLoggable(Level.FINE) ? e : null);
                    }
                    catch (InterruptedException e) {
                        LOGGER.log(Level.WARNING, "Could not update commit status to PENDING. Rate limit exhausted", LOGGER.isLoggable(Level.FINE) ? e : null);
                        LOGGER.log(Level.FINE, null, e);
                    }
                }
            });
        }
    }
}

