/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.util.logging.Logger;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;

class UnsetHooks
implements RepositoryCallback<Object> {
    private static final Logger LOGGER = Logger.getLogger(UnsetHooks.class.getName());
    private static final long serialVersionUID = 1L;

    UnsetHooks() {
    }

    public Object invoke(Repository repo, VirtualChannel channel) throws IOException, InterruptedException {
        StoredConfig repoConfig = repo.getConfig();
        String val = repoConfig.getString("core", null, "hooksPath");
        if (!(val == null || val.isEmpty() || "/dev/null".equals(val) || "NUL:".equals(val))) {
            LOGGER.warning(() -> "core.hooksPath explicitly set to %s and will be left intact on %s.".formatted(val, repo.getDirectory()));
        } else {
            repoConfig.unset("core", null, "hooksPath");
            repoConfig.save();
        }
        return null;
    }
}

