/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.Messages;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSCMSource;
import jenkins.security.FIPS140;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.transport.RemoteConfig;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.GitURIRequirementsBuilder;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.security.core.Authentication;

@ExportedBean
public class UserRemoteConfig
extends AbstractDescribableImpl<UserRemoteConfig>
implements Serializable {
    private String name;
    private String refspec;
    private String url;
    private String credentialsId;
    private static final Pattern SCP_LIKE = Pattern.compile("(.*):(.*)");

    @DataBoundConstructor
    public UserRemoteConfig(String url, String name, String refspec, @CheckForNull String credentialsId) {
        this.url = Util.fixEmptyAndTrim((String)url);
        this.name = Util.fixEmpty((String)name);
        this.refspec = Util.fixEmpty((String)refspec);
        this.credentialsId = Util.fixEmpty((String)credentialsId);
        if (FIPS140.useCompliantAlgorithms() && StringUtils.isNotEmpty((CharSequence)this.credentialsId) && StringUtils.startsWith((CharSequence)this.url, (CharSequence)"http:")) {
            throw new IllegalArgumentException(Messages.git_fips_url_notsecured());
        }
    }

    @Exported
    @Whitelisted
    public String getName() {
        return this.name;
    }

    @Exported
    @Whitelisted
    public String getRefspec() {
        return this.refspec;
    }

    @Exported
    @Whitelisted
    @CheckForNull
    public String getUrl() {
        return this.url;
    }

    @Exported
    @Whitelisted
    @CheckForNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String toString() {
        return this.getRefspec() + " => " + this.getUrl() + " (" + this.getName() + ")";
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<UserRemoteConfig> {
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project, @QueryParameter String url, @QueryParameter String credentialsId) {
            org.acegisecurity.Authentication authentication;
            if (project == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || project != null && !project.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            if (project == null) {
                FreeStyleProject fakeProject = new FreeStyleProject(Jenkins.get(), "fake-" + String.valueOf(UUID.randomUUID()));
                project = fakeProject;
            }
            AbstractIdCredentialsListBoxModel abstractIdCredentialsListBoxModel = new StandardListBoxModel().includeEmptyValue();
            if (project instanceof Queue.Task) {
                Queue.Task t = (Queue.Task)project;
                authentication = Tasks.getAuthenticationOf((Queue.Task)t);
            } else {
                authentication = ACL.SYSTEM;
            }
            return abstractIdCredentialsListBoxModel.includeMatchingAs(authentication, project, StandardUsernameCredentials.class, GitURIRequirementsBuilder.fromUri((String)url).build(), GitClient.CREDENTIALS_MATCHER).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item project, @QueryParameter String url, @QueryParameter String value) {
            Authentication authentication;
            if (project == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || project != null && !project.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.ok();
            }
            if ((value = Util.fixEmptyAndTrim((String)value)) == null) {
                return FormValidation.ok();
            }
            if ((url = Util.fixEmptyAndTrim((String)url)) == null) {
                return FormValidation.ok();
            }
            if (url.indexOf(36) >= 0) {
                return FormValidation.ok();
            }
            if (project instanceof Queue.Task) {
                Queue.Task t = (Queue.Task)project;
                authentication = Tasks.getAuthenticationOf2((Queue.Task)t);
            } else {
                authentication = ACL.SYSTEM2;
            }
            for (ListBoxModel.Option o : CredentialsProvider.listCredentialsInItem(StandardUsernameCredentials.class, (Item)project, (Authentication)authentication, (List)GitURIRequirementsBuilder.fromUri((String)url).build(), (CredentialsMatcher)GitClient.CREDENTIALS_MATCHER)) {
                if (!Objects.equals(value, o.value)) continue;
                return FormValidation.ok();
            }
            return FormValidation.warning((String)("Cannot find any credentials with id " + value));
        }

        @RequirePOST
        public FormValidation doCheckUrl(@AncestorInPath Item item, @QueryParameter String credentialsId, @QueryParameter String value) throws IOException, InterruptedException {
            EnvVars environment;
            if (!GitSCMSource.isFIPSCompliantTLS(credentialsId, value)) {
                return FormValidation.error((String)Messages.git_fips_url_notsecured());
            }
            if (item == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || item != null && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            String url = Util.fixEmptyAndTrim((String)value);
            if (url == null) {
                return FormValidation.error((String)Messages.UserRemoteConfig_CheckUrl_UrlIsNull());
            }
            if (url.indexOf(36) >= 0) {
                return FormValidation.ok();
            }
            Jenkins jenkins = Jenkins.get();
            if (item instanceof Job) {
                Job job = (Job)item;
                environment = job.getEnvironment((Node)jenkins, TaskListener.NULL);
            } else {
                Computer computer = jenkins.toComputer();
                environment = computer == null ? new EnvVars() : computer.buildEnvironment(TaskListener.NULL);
            }
            GitClient git = Git.with((TaskListener)TaskListener.NULL, (EnvVars)environment).using(GitTool.getDefaultInstallation().getGitExe()).getClient();
            StandardCredentials credential = DescriptorImpl.lookupCredentials(item, credentialsId, url);
            git.addDefaultCredentials(credential);
            try {
                git.getHeadRev(url, "HEAD");
            }
            catch (GitException e) {
                return FormValidation.error((String)Messages.UserRemoteConfig_FailedToConnect(e.getMessage()));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRefspec(@QueryParameter String name, @QueryParameter String url, @QueryParameter String value) throws IllegalArgumentException {
            String refSpec = Util.fixEmptyAndTrim((String)value);
            if (refSpec == null) {
                return FormValidation.ok();
            }
            if (refSpec.contains("$")) {
                return FormValidation.ok();
            }
            Config repoConfig = new Config();
            repoConfig.setString("remote", name, "url", url);
            repoConfig.setString("remote", name, "fetch", refSpec);
            try {
                RemoteConfig.getAllRemoteConfigs((Config)repoConfig);
            }
            catch (Exception e) {
                return FormValidation.error((String)Messages.UserRemoteConfig_CheckRefSpec_InvalidRefSpec());
            }
            return FormValidation.ok();
        }

        private static StandardCredentials lookupCredentials(@CheckForNull Item project, String credentialId, String uri) {
            return credentialId == null ? null : (StandardCredentials)CredentialsProvider.findCredentialByIdInItem((String)credentialId, StandardCredentials.class, (Item)project, (Authentication)ACL.SYSTEM2, (List)GitURIRequirementsBuilder.fromUri((String)uri).build());
        }

        public String getDisplayName() {
            return "";
        }
    }
}

