/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitSCM;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class BranchSpec
extends AbstractDescribableImpl<BranchSpec>
implements Serializable {
    private static final long serialVersionUID = -6177158367915899356L;
    private String name;

    @Exported
    @Whitelisted
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.name = name.length() == 0 ? "**" : name.trim();
    }

    @DataBoundConstructor
    public BranchSpec(String name) {
        this.setName(name);
    }

    public String toString() {
        return this.name;
    }

    public boolean matches(String item) {
        EnvVars env = new EnvVars();
        return this.matches(item, env);
    }

    public boolean matches(String ref, EnvVars env) {
        return this.getPattern(env).matcher(ref).matches();
    }

    public boolean matchesRepositoryBranch(String repositoryName, String branchName) {
        String branchWithoutRefs;
        if (branchName == null) {
            return false;
        }
        Pattern pattern = this.getPattern(new EnvVars(), repositoryName);
        return pattern.matcher(branchWithoutRefs = this.cutRefs(branchName)).matches() || pattern.matcher(this.join(repositoryName, branchWithoutRefs)).matches();
    }

    @Deprecated
    public List<String> filterMatching(Collection<String> branches) {
        EnvVars env = new EnvVars();
        return this.filterMatching(branches, env);
    }

    public List<String> filterMatching(Collection<String> branches, EnvVars env) {
        ArrayList<String> items = new ArrayList<String>();
        for (String b : branches) {
            if (!this.matches(b, env)) continue;
            items.add(b);
        }
        return items;
    }

    public List<Branch> filterMatchingBranches(Collection<Branch> branches) {
        EnvVars env = new EnvVars();
        return this.filterMatchingBranches(branches, env);
    }

    public List<Branch> filterMatchingBranches(Collection<Branch> branches, EnvVars env) {
        ArrayList<Branch> items = new ArrayList<Branch>();
        for (Branch b : branches) {
            if (!this.matches(b.getName(), env)) continue;
            items.add(b);
        }
        return items;
    }

    private String getExpandedName(EnvVars env) {
        String expandedName = env.expand(this.name);
        if (expandedName.length() == 0) {
            return "**";
        }
        return expandedName;
    }

    private Pattern getPattern(EnvVars env) {
        return this.getPattern(env, null);
    }

    private Pattern getPattern(EnvVars env, String repositoryName) {
        String expandedName = this.getExpandedName(env);
        if (expandedName.startsWith(":") && expandedName.length() > 1) {
            String regexSubstring = expandedName.substring(1, expandedName.length());
            return Pattern.compile(regexSubstring);
        }
        if (repositoryName != null) {
            String pattern = this.cutRefs(expandedName).replaceAll("^remotes/", "");
            pattern = this.convertWildcardStringToRegex(pattern);
            return Pattern.compile(pattern);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("(refs/heads/");
        if (!expandedName.contains("**") && !expandedName.contains("/")) {
            builder.append("|refs/remotes/[^/]+/|remotes/[^/]+/|[^/]+/");
        } else {
            builder.append("|refs/remotes/|remotes/");
        }
        builder.append(")?");
        builder.append(this.convertWildcardStringToRegex(expandedName));
        return Pattern.compile(builder.toString());
    }

    private String convertWildcardStringToRegex(String expandedName) {
        StringBuilder builder = new StringBuilder();
        boolean foundWildcard = false;
        StringTokenizer tokenizer = new StringTokenizer(expandedName, "*", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("*")) {
                if (foundWildcard) {
                    builder.append(".*");
                    foundWildcard = false;
                    continue;
                }
                foundWildcard = true;
                continue;
            }
            if (foundWildcard) {
                builder.append("[^/]*");
                foundWildcard = false;
            }
            builder.append(Pattern.quote(token));
        }
        if (foundWildcard) {
            builder.append("[^/]*");
        }
        return builder.toString();
    }

    private String cutRefs(@NonNull String name) {
        Matcher matcher = GitSCM.GIT_REF.matcher(name);
        return matcher.matches() ? matcher.group(2) : name;
    }

    private String join(String repositoryName, String branchWithoutRefs) {
        return String.join((CharSequence)"/", repositoryName, branchWithoutRefs);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<BranchSpec> {
        public String getDisplayName() {
            return "Branch Spec";
        }
    }
}

