/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Queue;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.recipes.LocalData;

public class GitBranchSCMHeadTest {
    @Rule
    public JenkinsRule r = new JenkinsRule(){

        public void before() throws Throwable {
            if (!GitBranchSCMHeadTest.this.isWindows() && "testMigrationNoBuildStorm".equals(this.getTestDescription().getMethodName())) {
                URL res = ((Object)((Object)this)).getClass().getResource("/jenkins/plugins/git/GitBranchSCMHeadTest/testMigrationNoBuildStorm_repositories.zip");
                File path = new File("/tmp/JENKINS-48061");
                if (path.exists()) {
                    if (path.isDirectory()) {
                        FileUtils.deleteDirectory((File)path);
                    } else {
                        path.delete();
                    }
                }
                new FilePath(new File(res.toURI())).unzip(new FilePath(path.getParentFile()));
            }
            super.before();
        }
    };

    @After
    public void removeRepos() throws IOException {
        File path = new File("/tmp/JENKINS-48061");
        if (path.exists() && path.isDirectory()) {
            FileUtils.deleteDirectory((File)path);
        }
    }

    @Test
    @LocalData
    @Deprecated
    public void testMigrationNoBuildStorm() throws Exception {
        if (this.isWindows()) {
            return;
        }
        WorkflowMultiBranchProject job = (WorkflowMultiBranchProject)this.r.jenkins.getItemByFullName("job", WorkflowMultiBranchProject.class);
        Assert.assertEquals((long)4L, (long)job.getItems().size());
        WorkflowJob master = (WorkflowJob)job.getItem("master");
        Assert.assertEquals((long)1L, (long)master.getBuilds().size());
        WorkflowJob dev = (WorkflowJob)job.getItem("dev");
        Assert.assertEquals((long)1L, (long)dev.getBuilds().size());
        WorkflowJob v4 = (WorkflowJob)job.getItem("v4");
        Assert.assertEquals((long)0L, (long)v4.getBuilds().size());
        Queue.Item item = job.scheduleBuild2(0, new Action[0]);
        Assert.assertNotNull((Object)item);
        item.getFuture().waitForStart();
        this.r.waitUntilNoActivity();
        Assert.assertEquals((long)4L, (long)job.getItems().size());
        master = (WorkflowJob)job.getItem("master");
        Assert.assertEquals((long)1L, (long)master.getBuilds().size());
        dev = (WorkflowJob)job.getItem("dev");
        Assert.assertEquals((long)1L, (long)dev.getBuilds().size());
        v4 = (WorkflowJob)job.getItem("v4");
        Assert.assertEquals((long)0L, (long)v4.getBuilds().size());
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }
}

