/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.security;

import hudson.plugins.git.ApiTokenPropertyConfiguration;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import java.util.Collection;
import java.util.Collections;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.htmlunit.HttpMethod;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.util.NameValuePair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.MockAuthorizationStrategy;

public class ApiTokenPropertyConfigurationTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();

    @Before
    public void init() {
        this.r.jenkins.setSecurityRealm((SecurityRealm)this.r.createDummySecurityRealm());
        MockAuthorizationStrategy authorizationStrategy = new MockAuthorizationStrategy();
        authorizationStrategy.grant(new Permission[]{Jenkins.ADMINISTER}).everywhere().to(new String[]{"alice"});
        authorizationStrategy.grant(new Permission[]{Jenkins.READ}).everywhere().to(new String[]{"bob"});
        this.r.jenkins.setAuthorizationStrategy((AuthorizationStrategy)authorizationStrategy);
    }

    @Test
    public void testAdminPermissionRequiredToGenerateNewApiTokens() throws Exception {
        try (JenkinsRule.WebClient wc = this.r.createWebClient();){
            wc.login("bob");
            WebRequest req = new WebRequest(wc.createCrumbedUrl(ApiTokenPropertyConfiguration.get().getDescriptorUrl() + "/generate"), HttpMethod.POST);
            req.setRequestBody("{\"apiTokenName\":\"test\"}");
            wc.setThrowExceptionOnFailingStatusCode(false);
            WebResponse res = wc.getPage(req).getWebResponse();
            Assert.assertEquals((long)403L, (long)res.getStatusCode());
            Assert.assertTrue((boolean)res.getContentAsString().contains("bob is missing the Overall/Administer permission"));
        }
    }

    @Test
    public void adminPermissionsRequiredToRevokeApiTokens() throws Exception {
        try (JenkinsRule.WebClient wc = this.r.createWebClient();){
            wc.login("bob");
            WebRequest req = new WebRequest(wc.createCrumbedUrl(ApiTokenPropertyConfiguration.get().getDescriptorUrl() + "/revoke"), HttpMethod.POST);
            wc.setThrowExceptionOnFailingStatusCode(false);
            WebResponse res = wc.getPage(req).getWebResponse();
            Assert.assertEquals((long)403L, (long)res.getStatusCode());
            Assert.assertTrue((boolean)res.getContentAsString().contains("bob is missing the Overall/Administer permission"));
        }
    }

    @Test
    public void testBasicGenerationAndRevocation() throws Exception {
        try (JenkinsRule.WebClient wc = this.r.createWebClient();){
            wc.login("alice");
            WebRequest generateReq = new WebRequest(wc.createCrumbedUrl(ApiTokenPropertyConfiguration.get().getDescriptorUrl() + "/generate"), HttpMethod.POST);
            generateReq.setRequestParameters(Collections.singletonList(new NameValuePair("apiTokenName", "token")));
            String uuid = JSONObject.fromObject((Object)wc.getPage(generateReq).getWebResponse().getContentAsString()).getJSONObject("data").getString("uuid");
            generateReq.setRequestParameters(Collections.singletonList(new NameValuePair("apiTokenName", "nekot")));
            String uuid2 = JSONObject.fromObject((Object)wc.getPage(generateReq).getWebResponse().getContentAsString()).getJSONObject("data").getString("uuid");
            Collection apiTokens = ApiTokenPropertyConfiguration.get().getApiTokens();
            MatcherAssert.assertThat((Object)apiTokens, (Matcher)Matchers.allOf((Matcher)Matchers.iterableWithSize((int)2), (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"token")), (Matcher)Matchers.hasProperty((String)"uuid", (Matcher)Matchers.is((Object)uuid)))), (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"nekot")), (Matcher)Matchers.hasProperty((String)"uuid", (Matcher)Matchers.is((Object)uuid2))))));
            WebRequest revokeReq = new WebRequest(wc.createCrumbedUrl(ApiTokenPropertyConfiguration.get().getDescriptorUrl() + "/revoke"), HttpMethod.POST);
            revokeReq.setRequestParameters(Collections.singletonList(new NameValuePair("apiTokenUuid", uuid)));
            wc.getPage(revokeReq);
            apiTokens = ApiTokenPropertyConfiguration.get().getApiTokens();
            MatcherAssert.assertThat((Object)apiTokens, (Matcher)Matchers.allOf((Matcher)Matchers.iterableWithSize((int)1), (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"nekot")), (Matcher)Matchers.hasProperty((String)"uuid", (Matcher)Matchers.is((Object)uuid2))))));
        }
    }

    @Test
    public void isValidApiTokenReturnsTrueIfGivenApiTokenExists() {
        JSONObject json = ApiTokenPropertyConfiguration.get().generateApiToken("test");
        Assert.assertTrue((boolean)ApiTokenPropertyConfiguration.get().isValidApiToken(json.getString("value")));
    }
}

