/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.Cause;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.plugins.git.AbstractGitProject;
import hudson.plugins.git.Branch;
import hudson.plugins.git.Revision;
import hudson.plugins.git.RevisionParameterAction;
import hudson.plugins.git.util.BuildData;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class RevisionParameterActionTest
extends AbstractGitProject {
    @Test
    public void testProvidingRevision() throws Exception {
        FreeStyleProject p1 = this.setupSimpleProject("master");
        String commitFile1 = "commitFile1";
        this.commitNewFile("commitFile1");
        FreeStyleBuild b1 = this.build(p1, Result.SUCCESS, "commitFile1");
        Revision r1 = ((BuildData)b1.getAction(BuildData.class)).getLastBuiltRevision();
        String commitFile2 = "commitFile2";
        this.commitNewFile("commitFile2");
        FreeStyleBuild b2 = (FreeStyleBuild)p1.scheduleBuild2(0, (Cause)new Cause.UserIdCause(), Collections.singletonList(new RevisionParameterAction(r1))).get();
        Assert.assertEquals((Object)((BuildData)b2.getAction(BuildData.class)).getLastBuiltRevision().getSha1String(), (Object)r1.getSha1String());
        Assert.assertEquals((Object)((Branch)((BuildData)b2.getAction(BuildData.class)).getLastBuiltRevision().getBranches().iterator().next()).getName(), (Object)((Branch)r1.getBranches().iterator().next()).getName());
        FreeStyleBuild b3 = this.build(p1, Result.SUCCESS, "commitFile2");
        Assert.assertNotEquals((Object)((BuildData)b3.getAction(BuildData.class)).getLastBuiltRevision().getSha1String(), (Object)r1.getSha1String());
    }
}

