/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitObject;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitTagAction;
import hudson.plugins.git.Revision;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.extensions.impl.LocalBranch;
import hudson.scm.SCM;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import jenkins.plugins.git.GitSampleRepoRule;
import org.eclipse.jgit.lib.ObjectId;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlPage;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.TestExtension;

public class GitTagActionTest {
    private static GitTagAction noTagAction;
    private static GitTagAction tagOneAction;
    private static GitTagAction tagTwoAction;
    private static final Random random;
    private static final String NO_BRANCHES = "tagRevision-with-no-branches";
    @ClassRule
    public static JenkinsRule r;
    @ClassRule
    public static TemporaryFolder temporaryFolder;
    @ClassRule
    public static GitSampleRepoRule sampleRepo;
    private static FreeStyleProject p;
    private static GitClient workspaceGitClient;
    private static final DateTimeFormatter FORMAT;
    private static final String TAG_PREFIX = "test-tag-";
    private static final String TAG_SUFFIX;
    private static final String INITIAL_COMMIT_MESSAGE;
    private static final String ADDED_COMMIT_MESSAGE_BASE;
    private static String sampleRepoHead;
    private static GitSCM.DescriptorImpl gitSCMDescriptor;
    private static int messageCounter;

    @BeforeClass
    public static void deleteMatchingTags() throws Exception {
        if (GitTagActionTest.isWindows()) {
            return;
        }
        GitClient gitClient = Git.with((TaskListener)TaskListener.NULL, (EnvVars)new EnvVars()).in(new File(".")).using(GitTagActionTest.chooseGitImplementation()).getClient();
        for (GitObject tag : gitClient.getTags()) {
            if (!tag.getName().startsWith(TAG_PREFIX) || tag.getName().contains(TAG_SUFFIX)) continue;
            gitClient.deleteTag(tag.getName());
        }
    }

    @BeforeClass
    public static void createThreeGitTagActions() throws Exception {
        if (GitTagActionTest.isWindows()) {
            return;
        }
        sampleRepo.init();
        sampleRepo.write("file", INITIAL_COMMIT_MESSAGE);
        sampleRepo.git("commit", "--all", "--message=" + INITIAL_COMMIT_MESSAGE);
        sampleRepoHead = sampleRepo.head();
        ArrayList<UserRemoteConfig> remotes = new ArrayList<UserRemoteConfig>();
        String refSpec = "+refs/heads/master:refs/remotes/origin/master";
        remotes.add(new UserRemoteConfig(sampleRepo.fileUrl(), "origin", refSpec, ""));
        GitSCM scm = new GitSCM(remotes, Collections.singletonList(new BranchSpec("origin/master")), null, GitTagActionTest.chooseGitImplementation(), Collections.emptyList());
        scm.getExtensions().add((Object)new LocalBranch("master"));
        p = r.createFreeStyleProject();
        p.setScm((SCM)scm);
        gitSCMDescriptor = scm.getDescriptor();
        gitSCMDescriptor.setAddGitTagAction(true);
        noTagAction = GitTagActionTest.createTagAction(null);
        tagOneAction = GitTagActionTest.createTagAction("v1");
        GitTagActionTest.waitForTagCreation(tagOneAction, "v1");
        tagTwoAction = GitTagActionTest.createTagAction("v2");
        GitTagActionTest.waitForTagCreation(tagTwoAction, "v2");
        MatcherAssert.assertThat(GitTagActionTest.getMatchingTagNames(), (Matcher)Matchers.hasItems((Object[])new String[]{GitTagActionTest.getTagValue("v1"), GitTagActionTest.getTagValue("v2")}));
        GitTagAction tagNullBranchesAction = GitTagActionTest.createTagAction(NO_BRANCHES);
        MatcherAssert.assertThat((Object)tagNullBranchesAction, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    @AfterClass
    public static void disableAddGitTagAction() {
        if (gitSCMDescriptor != null) {
            gitSCMDescriptor.setAddGitTagAction(false);
        }
    }

    private static String getTagName(String message) {
        return TAG_PREFIX + message + TAG_SUFFIX;
    }

    private static String getTagValue(String message) {
        return GitTagActionTest.getTagName(message) + "-value";
    }

    private static String getTagComment(String message) {
        return GitTagActionTest.getTagName(message) + "-comment";
    }

    private static GitTagAction createTagAction(String message) throws Exception {
        String commitMessage = message == null ? ADDED_COMMIT_MESSAGE_BASE + "-" + messageCounter++ : message;
        sampleRepo.write("file", message);
        sampleRepo.git("commit", "--all", "--message=" + commitMessage);
        ArrayList<Branch> masterBranchList = new ArrayList<Branch>();
        ObjectId tagObjectId = ObjectId.fromString((String)sampleRepo.head());
        masterBranchList.add(new Branch("master", tagObjectId));
        Revision tagRevision = new Revision(tagObjectId, masterBranchList);
        FreeStyleBuild tagRun = r.buildAndAssertSuccess(p);
        FilePath workspace = GitTagActionTest.r.jenkins.getWorkspaceFor((TopLevelItem)p);
        if (workspaceGitClient == null) {
            workspaceGitClient = Git.with((TaskListener)TaskListener.NULL, (EnvVars)new EnvVars()).in(workspace).using(GitTagActionTest.chooseGitImplementation()).getClient();
        }
        MatcherAssert.assertThat((Object)workspace, (Matcher)Matchers.is((Object)workspaceGitClient.getWorkTree()));
        StringWriter stringWriter = new StringWriter();
        workspaceGitClient.changelog(sampleRepoHead + "^", "HEAD", (Writer)stringWriter);
        MatcherAssert.assertThat((Object)stringWriter.toString(), (Matcher)Matchers.containsString((String)INITIAL_COMMIT_MESSAGE));
        MatcherAssert.assertThat((Object)stringWriter.toString(), (Matcher)Matchers.containsString((String)commitMessage));
        MatcherAssert.assertThat((Object)workspaceGitClient.getRemoteUrl("origin"), (Matcher)Matchers.is((Object)sampleRepo.fileUrl().replace("file:/", "file:///")));
        Set branches = workspaceGitClient.getBranches();
        if (branches.isEmpty()) {
            workspaceGitClient.branch("master");
            branches = workspaceGitClient.getBranches();
            MatcherAssert.assertThat((Object)branches, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        }
        boolean foundMasterBranch = false;
        String lastBranchName = null;
        for (Branch branch : branches) {
            lastBranchName = branch.getName();
            MatcherAssert.assertThat((Object)lastBranchName, (Matcher)Matchers.endsWith((String)"master"));
            if (!lastBranchName.equals("master")) continue;
            foundMasterBranch = true;
        }
        Assert.assertTrue((String)("master branch not found, last branch name was " + lastBranchName), (boolean)foundMasterBranch);
        if (NO_BRANCHES.equals(message)) {
            tagRevision.setBranches(null);
        }
        TestGitTagAction tagAction = new TestGitTagAction((Run)tagRun, workspace, tagRevision);
        if (message != null) {
            String tagName = GitTagActionTest.getTagName(message);
            String tagValue = GitTagActionTest.getTagValue(message);
            String tagComment = GitTagActionTest.getTagComment(message);
            HashMap<String, String> tagMap = new HashMap<String, String>();
            tagMap.put(tagName, tagValue);
            tagAction.scheduleTagCreation(tagMap, tagComment);
        }
        return tagAction;
    }

    private static Set<String> getMatchingTagNames() throws Exception {
        Set tags = workspaceGitClient.getTags();
        HashSet<String> matchingTagNames = new HashSet<String>();
        for (GitObject tag : tags) {
            if (!tag.getName().startsWith(TAG_PREFIX)) continue;
            matchingTagNames.add(tag.getName());
        }
        return matchingTagNames;
    }

    private static void waitForTagCreation(GitTagAction tagAction, String message) throws Exception {
        long backoffDelay = 499L;
        while (tagAction.getLastTagName() == null && tagAction.getLastTagException() == null && backoffDelay < 8000L) {
            Thread.sleep(backoffDelay *= 2L);
        }
        MatcherAssert.assertThat((Object)((Object)tagAction.getLastTagException()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)tagAction.getLastTagName(), (Matcher)Matchers.is((Object)GitTagActionTest.getTagValue(message)));
    }

    @Test
    public void testDoPost() throws Exception {
        if (GitTagActionTest.isWindows()) {
            return;
        }
        JenkinsRule.WebClient browser = r.createWebClient();
        HtmlPage tagPage3 = browser.getPage((Item)p, "/3/tagBuild");
        HtmlForm form3 = tagPage3.getFormByName("tag");
        form3.getInputByName("name0").setValue("tag-build-3");
        HtmlPage submitted3 = r.submit(form3);
    }

    @Test
    public void testGetDescriptor() {
        if (GitTagActionTest.isWindows()) {
            return;
        }
        Descriptor descriptor = noTagAction.getDescriptor();
        MatcherAssert.assertThat((Object)descriptor.getDisplayName(), (Matcher)Matchers.is((Object)"Tag"));
    }

    @Test
    public void testIsNotTagged() {
        if (GitTagActionTest.isWindows()) {
            return;
        }
        Assert.assertFalse((boolean)noTagAction.isTagged());
    }

    @Test
    public void testGetDisplayNameNoTagAction() {
        if (GitTagActionTest.isWindows()) {
            return;
        }
        MatcherAssert.assertThat((Object)noTagAction.getDisplayName(), (Matcher)Matchers.is((Object)"No Tags"));
    }

    @Test
    public void testGetIconFileName() {
        if (GitTagActionTest.isWindows()) {
            return;
        }
        MatcherAssert.assertThat((Object)noTagAction.getIconFileName(), (Matcher)Matchers.is((Object)"save.gif"));
    }

    @Test
    public void testGetTagsNoTagAction() {
        if (GitTagActionTest.isWindows()) {
            return;
        }
        Collection valueList = noTagAction.getTags().values();
        for (List value : valueList) {
            MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        }
    }

    @Test
    public void testGetTagsOneTagAction() {
        if (GitTagActionTest.isWindows()) {
            return;
        }
        Collection valueList = tagOneAction.getTags().values();
        for (List value : valueList) {
            MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        }
    }

    @Test
    public void testGetTagsTwoTagAction() {
        if (GitTagActionTest.isWindows()) {
            return;
        }
        Collection valueList = tagTwoAction.getTags().values();
        for (List value : valueList) {
            MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        }
    }

    @Test
    public void testGetTagInfo() {
        if (GitTagActionTest.isWindows()) {
            return;
        }
        MatcherAssert.assertThat((Object)noTagAction.getTagInfo(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testGetTooltipNoTagAction() {
        if (GitTagActionTest.isWindows()) {
            return;
        }
        MatcherAssert.assertThat((Object)noTagAction.getTooltip(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testGetPermission() {
        if (GitTagActionTest.isWindows()) {
            return;
        }
        MatcherAssert.assertThat((Object)noTagAction.getPermission(), (Matcher)Matchers.is((Object)GitSCM.TAG));
        MatcherAssert.assertThat((Object)tagOneAction.getPermission(), (Matcher)Matchers.is((Object)GitSCM.TAG));
    }

    private static String chooseGitImplementation() {
        return random.nextBoolean() ? "git" : "jgit";
    }

    private static boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }

    static {
        random = new Random();
        r = new JenkinsRule();
        temporaryFolder = new TemporaryFolder();
        sampleRepo = new GitSampleRepoRule();
        workspaceGitClient = null;
        FORMAT = DateTimeFormatter.ofPattern("-yyyy-MM-dd-H-m-ss.SS");
        TAG_SUFFIX = LocalDateTime.now().format(FORMAT);
        INITIAL_COMMIT_MESSAGE = "init" + TAG_SUFFIX + "-" + random.nextInt(10000);
        ADDED_COMMIT_MESSAGE_BASE = "added" + TAG_SUFFIX;
        sampleRepoHead = null;
        gitSCMDescriptor = null;
        messageCounter = 1;
    }

    private static class TestGitTagAction
    extends GitTagAction {
        public TestGitTagAction(Run build, FilePath workspace, Revision revision) {
            super(build, workspace, revision);
        }

        void scheduleTagCreation(Map<String, String> newTags, String comment) throws IOException, ServletException {
            new TestTagWorkerThread(newTags, comment).start();
        }

        private class TestTagWorkerThread
        extends GitTagAction.TagWorkerThread {
            public TestTagWorkerThread(Map<String, String> tagSet, String ignoredComment) {
                super((GitTagAction)TestGitTagAction.this, tagSet, ignoredComment);
            }

            protected GitClient getGitClient(TaskListener listener, EnvVars environment, FilePath workspace) throws IOException, InterruptedException {
                GitClient gitClient = super.getGitClient(listener, environment, workspace);
                try {
                    gitClient.config(GitClient.ConfigLevel.LOCAL, "commit.gpgsign", "false");
                    gitClient.config(GitClient.ConfigLevel.LOCAL, "tag.gpgSign", "false");
                }
                catch (GitException x) {
                    throw new IOException(x);
                }
                return gitClient;
            }
        }

        @TestExtension
        public static class DescriptorImpl
        extends Descriptor<GitTagAction> {
            public String getDisplayName() {
                return "Tag";
            }
        }
    }
}

