/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.plugins.git.GitSCM;
import hudson.plugins.git.browser.BitbucketWeb;
import hudson.plugins.git.browser.GitLab;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.browser.GithubWeb;
import java.util.ArrayList;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GitSCMBrowserTest {
    private final String gitURI;
    private final Class<? extends GitRepositoryBrowser> expectedClass;
    private final String expectedURI;
    private static final String REPO_PATH = "jenkinsci/git-plugin";

    public GitSCMBrowserTest(String gitURI, Class<? extends GitRepositoryBrowser> expectedClass, String expectedURI) {
        this.gitURI = gitURI;
        this.expectedClass = expectedClass;
        this.expectedURI = expectedURI;
    }

    private static Class<? extends GitRepositoryBrowser> expectedClass(String url) {
        if (url.contains("bitbucket.org")) {
            return BitbucketWeb.class;
        }
        if (url.contains("gitlab.com")) {
            return GitLab.class;
        }
        if (url.contains("github.com")) {
            return GithubWeb.class;
        }
        return null;
    }

    private static String expectedURL(String url) {
        if (url.contains("bitbucket.org")) {
            return "https://bitbucket.org/jenkinsci/git-plugin/";
        }
        if (url.contains("gitlab.com")) {
            return "https://gitlab.com/jenkinsci/git-plugin/";
        }
        if (url.contains("github.com")) {
            return "https://github.com/jenkinsci/git-plugin/";
        }
        return null;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection permuteRepositoryURL() {
        String[] protocols = new String[]{"https", "ssh", "git"};
        String[] usernames = new String[]{"git:password@", "git@", "bob@", ""};
        String[] hostnames = new String[]{"github.com", "bitbucket.org", "gitlab.com", "example.com"};
        String[] suffixes = new String[]{".git/", ".git", "/", ""};
        String[] slashes = new String[]{"//", "/", ""};
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (String protocol : protocols) {
            for (String username : usernames) {
                for (String hostname : hostnames) {
                    for (String suffix : suffixes) {
                        String url = protocol + "://" + username + hostname + "/jenkinsci/git-plugin" + suffix;
                        Object[] testCase = new Object[]{url, GitSCMBrowserTest.expectedClass(url), GitSCMBrowserTest.expectedURL(url)};
                        values.add(testCase);
                    }
                }
            }
        }
        String protocol = "ssh";
        for (String username : usernames) {
            for (String hostname : hostnames) {
                for (String suffix : suffixes) {
                    String url = protocol + "://" + username + hostname + ":22/jenkinsci/git-plugin" + suffix;
                    Object[] testCase = new Object[]{url, GitSCMBrowserTest.expectedClass(url), GitSCMBrowserTest.expectedURL(url)};
                    values.add(testCase);
                }
            }
        }
        for (String hostname : hostnames) {
            for (String suffix : suffixes) {
                for (String slash : slashes) {
                    String url = "git@" + hostname + ":" + slash + REPO_PATH + suffix;
                    Object[] testCase = new Object[]{url, GitSCMBrowserTest.expectedClass(url), GitSCMBrowserTest.expectedURL(url)};
                    values.add(testCase);
                }
            }
        }
        return values;
    }

    @Test
    public void guessedBrowser() throws Exception {
        GitSCM gitSCM = new GitSCM(this.gitURI);
        GitRepositoryBrowser browser = (GitRepositoryBrowser)gitSCM.guessBrowser();
        if (this.expectedClass == null || this.expectedURI == null) {
            MatcherAssert.assertThat((Object)browser, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        } else {
            MatcherAssert.assertThat((Object)browser, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(this.expectedClass)));
            MatcherAssert.assertThat((Object)browser.getRepoUrl(), (Matcher)Matchers.is((Object)this.expectedURI));
        }
    }
}

