// CHECKSTYLE:OFF

package jenkins.plugins.git;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code additional}: {@code Additional}.
     * 
     * @return
     *     {@code Additional}
     */
    public static String additional() {
        return holder.format("additional");
    }

    /**
     * Key {@code additional}: {@code Additional}.
     * 
     * @return
     *     {@code Additional}
     */
    public static Localizable _additional() {
        return new Localizable(holder, "additional");
    }

    /**
     * Key {@code git.fips.url.notsecured}: {@code Invalid configuration will
     * not fetch any remote. FIPS requires a secure channel for git fetch
     * with credentials.}.
     * 
     * @return
     *     {@code Invalid configuration will not fetch any remote. FIPS requires
     *     a secure channel for git fetch with credentials.}
     */
    public static String git_fips_url_notsecured() {
        return holder.format("git.fips.url.notsecured");
    }

    /**
     * Key {@code git.fips.url.notsecured}: {@code Invalid configuration will
     * not fetch any remote. FIPS requires a secure channel for git fetch
     * with credentials.}.
     * 
     * @return
     *     {@code Invalid configuration will not fetch any remote. FIPS requires
     *     a secure channel for git fetch with credentials.}
     */
    public static Localizable _git_fips_url_notsecured() {
        return new Localizable(holder, "git.fips.url.notsecured");
    }

    /**
     * Key {@code GitSCMSource.DisplayName}: {@code Git}.
     * 
     * @return
     *     {@code Git}
     */
    public static String GitSCMSource_DisplayName() {
        return holder.format("GitSCMSource.DisplayName");
    }

    /**
     * Key {@code GitSCMSource.DisplayName}: {@code Git}.
     * 
     * @return
     *     {@code Git}
     */
    public static Localizable _GitSCMSource_DisplayName() {
        return new Localizable(holder, "GitSCMSource.DisplayName");
    }

    /**
     * Key {@code GitUsernamePasswordBinding.DisplayName}: {@code Git
     * Username and Password}.
     * 
     * @return
     *     {@code Git Username and Password}
     */
    public static String GitUsernamePasswordBinding_DisplayName() {
        return holder.format("GitUsernamePasswordBinding.DisplayName");
    }

    /**
     * Key {@code GitUsernamePasswordBinding.DisplayName}: {@code Git
     * Username and Password}.
     * 
     * @return
     *     {@code Git Username and Password}
     */
    public static Localizable _GitUsernamePasswordBinding_DisplayName() {
        return new Localizable(holder, "GitUsernamePasswordBinding.DisplayName");
    }

    /**
     * Key {@code within.Repository}: {@code Within Repository}.
     * 
     * @return
     *     {@code Within Repository}
     */
    public static String within_Repository() {
        return holder.format("within.Repository");
    }

    /**
     * Key {@code within.Repository}: {@code Within Repository}.
     * 
     * @return
     *     {@code Within Repository}
     */
    public static Localizable _within_Repository() {
        return new Localizable(holder, "within.Repository");
    }

    /**
     * Key {@code GitStep.git}: {@code Git}.
     * 
     * @return
     *     {@code Git}
     */
    public static String GitStep_git() {
        return holder.format("GitStep.git");
    }

    /**
     * Key {@code GitStep.git}: {@code Git}.
     * 
     * @return
     *     {@code Git}
     */
    public static Localizable _GitStep_git() {
        return new Localizable(holder, "GitStep.git");
    }

}
