/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.Messages;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class Gitiles
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public Gitiles(String repoUrl) {
        super(repoUrl);
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        URL url = this.getUrl();
        return new URL(url + "+/" + path.getChangeSet().getId() + "%5E%21");
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        URL url = this.getUrl();
        return Gitiles.encodeURL(new URL(url + "+blame/" + path.getChangeSet().getId() + "/" + path.getPath()));
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        URL url = this.getUrl();
        return new URL(url + "+/" + changeSet.getId() + "%5E%21");
    }

    @Extension
    @Symbol(value={"gitiles"})
    public static class ViewGitWebDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        @NonNull
        public String getDisplayName() {
            return "gitiles";
        }

        @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="Inherited javadoc commits that req is non-null")
        public Gitiles newInstance(StaplerRequest req, @NonNull JSONObject jsonObject) throws Descriptor.FormException {
            return (Gitiles)((Object)req.bindJSON(Gitiles.class, jsonObject));
        }

        @RequirePOST
        public FormValidation doCheckRepoUrl(@AncestorInPath Item project, @QueryParameter(fixEmpty=true) String repoUrl) throws IOException, ServletException, URISyntaxException {
            final String cleanUrl = Util.fixEmptyAndTrim((String)repoUrl);
            if (GitRepositoryBrowser.initialChecksAndReturnOk(project, cleanUrl)) {
                return FormValidation.ok();
            }
            if (!GitRepositoryBrowser.validateUrl(cleanUrl)) {
                return FormValidation.error((String)Messages.invalidUrl());
            }
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    Object v = cleanUrl;
                    if (!((String)v).endsWith("/")) {
                        v = (String)v + "/";
                    }
                    try {
                        if (this.findText(this.open(new URL((String)v)), "git clone")) {
                            return FormValidation.ok();
                        }
                        return FormValidation.error((String)"This is a valid URL but it doesn't look like Gitiles");
                    }
                    catch (IOException e) {
                        return this.handleIOException((String)v, e);
                    }
                }
            }.check();
        }
    }
}

