/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.Messages;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class GitBlitRepositoryBrowser
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    private final String projectName;

    @DataBoundConstructor
    public GitBlitRepositoryBrowser(String repoUrl, String projectName) {
        super(repoUrl);
        this.projectName = projectName;
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        URL url = this.getUrl();
        return new URL(url, String.format(url.getPath() + "blobdiff?r=%s&h=%s&hb=%s", this.encodeString(this.projectName), path.getChangeSet().getId(), path.getChangeSet().getParentCommit()));
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType().equals(EditType.DELETE)) {
            return null;
        }
        URL url = this.getUrl();
        return new URL(url, String.format(url.getPath() + "blob?r=%s&h=%s&f=%s", this.encodeString(this.projectName), path.getChangeSet().getId(), this.encodeString(path.getPath())));
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        URL url = this.getUrl();
        return new URL(url, String.format(url.getPath() + "commit?r=%s&h=%s", this.encodeString(this.projectName), changeSet.getId()));
    }

    public String getProjectName() {
        return this.projectName;
    }

    private String encodeString(String s) {
        return URLEncoder.encode(s, StandardCharsets.UTF_8).replaceAll("\\+", "%20");
    }

    @Extension
    @Symbol(value={"gitblit"})
    public static class ViewGitWebDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        @NonNull
        public String getDisplayName() {
            return "gitblit";
        }

        @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="Inherited javadoc commits that req is non-null")
        public GitBlitRepositoryBrowser newInstance(StaplerRequest req, @NonNull JSONObject jsonObject) throws Descriptor.FormException {
            return (GitBlitRepositoryBrowser)((Object)req.bindJSON(GitBlitRepositoryBrowser.class, jsonObject));
        }

        @RequirePOST
        public FormValidation doCheckRepoUrl(@AncestorInPath Item project, @QueryParameter(fixEmpty=true) String repoUrl) throws IOException, ServletException, URISyntaxException {
            final String cleanUrl = Util.fixEmptyAndTrim((String)repoUrl);
            if (GitRepositoryBrowser.initialChecksAndReturnOk(project, cleanUrl)) {
                return FormValidation.ok();
            }
            if (!GitRepositoryBrowser.validateUrl(cleanUrl)) {
                return FormValidation.error((String)Messages.invalidUrl());
            }
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    Object v = cleanUrl;
                    if (!((String)v).endsWith("/")) {
                        v = (String)v + "/";
                    }
                    try {
                        if (this.findText(this.open(new URL((String)v)), "Gitblit")) {
                            return FormValidation.ok();
                        }
                        return FormValidation.error((String)"This is a valid URL but it doesn't look like Gitblit");
                    }
                    catch (IOException e) {
                        return this.handleIOException((String)v, e);
                    }
                }
            }.check();
        }
    }
}

