/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitTagAction;
import hudson.plugins.git.util.BuildData;
import hudson.scm.ChangeLogSet;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import jenkins.plugins.git.CliGitCommand;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.plugins.git.GitStep;
import jenkins.plugins.git.RandomOrder;
import jenkins.util.VirtualFile;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepConfigTester;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Stopwatch;
import org.junit.rules.TestName;
import org.junit.runner.OrderWith;
import org.jvnet.hudson.test.JenkinsRule;

@OrderWith(value=RandomOrder.class)
public class GitStepTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();
    @Rule
    public GitSampleRepoRule otherRepo = new GitSampleRepoRule();
    @ClassRule
    public static Stopwatch stopwatch = new Stopwatch();
    @Rule
    public TestName testName = new TestName();
    private static final int MAX_SECONDS_FOR_THESE_TESTS = 200;

    @BeforeClass
    public static void setGitDefaults() throws Exception {
        CliGitCommand gitCmd = new CliGitCommand(null, new String[0]);
        gitCmd.setDefaults();
    }

    private boolean isTimeAvailable() {
        String env = System.getenv("CI");
        if (env == null || !Boolean.parseBoolean(env)) {
            return true;
        }
        return stopwatch.runtime(TimeUnit.SECONDS) <= 200L;
    }

    @Test
    public void roundtrip() throws Exception {
        Assume.assumeTrue((String)"Test class max time 200 exceeded", (boolean)this.isTimeAvailable());
        GitStep step = new GitStep("git@github.com:jenkinsci/workflow-plugin.git");
        Step roundtrip = new StepConfigTester(this.r).configRoundTrip((Step)step);
        this.r.assertEqualDataBoundBeans((Object)step, (Object)roundtrip);
    }

    @Test
    public void roundtrip_withcredentials() throws Exception {
        Assume.assumeTrue((String)"Test class max time 200 exceeded", (boolean)this.isTimeAvailable());
        UsernamePasswordCredentialsImpl c = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, null, null, "user", "pass");
        ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)this.r.jenkins).iterator().next()).addCredentials(Domain.global(), (Credentials)c);
        GitStep step = new GitStep("git@github.com:jenkinsci/workflow-plugin.git");
        step.setCredentialsId(c.getId());
        Step roundtrip = new StepConfigTester(this.r).configRoundTrip((Step)step);
        this.r.assertEqualDataBoundBeans((Object)step, (Object)roundtrip);
    }

    @Test
    public void basicCloneAndUpdate() throws Exception {
        Assume.assumeTrue((String)"Test class max time 200 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "demo");
        this.r.createOnlineSlave(Label.get((String)"remote"));
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node('remote') {\n    ws {\n        git(url: $/" + this.sampleRepo + "/$, poll: false, changelog: false)\n        archive '**'\n    }\n}", true));
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        this.r.waitForMessage("Cloning the remote Git repository", (Run)b);
        Assert.assertTrue((boolean)b.getArtifactManager().root().child("file").isFile());
        this.sampleRepo.write("nextfile", "");
        this.sampleRepo.git("add", "nextfile");
        this.sampleRepo.git("commit", "--message=next");
        b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        this.r.waitForMessage("Fetching changes from the remote Git repository", (Run)b);
        Assert.assertTrue((boolean)b.getArtifactManager().root().child("nextfile").isFile());
    }

    @Test
    public void changelogAndPolling() throws Exception {
        Assume.assumeTrue((String)"Test class max time 200 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "demo");
        p.addTrigger((Trigger)new SCMTrigger(""));
        this.r.createOnlineSlave(Label.get((String)"remote"));
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node('remote') {\n    ws {\n        git($/" + this.sampleRepo + "/$)\n        def tokenBranch = tm '${GIT_BRANCH,fullName=false}'\n        echo \"token macro expanded branch is ${tokenBranch}\"\n    }\n}", true));
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        this.r.waitForMessage("token macro expanded branch is remotes/origin/master", (Run)b);
        this.sampleRepo.write("nextfile", "");
        this.sampleRepo.git("add", "nextfile");
        this.sampleRepo.git("commit", "--message=next");
        this.sampleRepo.notifyCommit(this.r);
        b = p.getLastBuild();
        Assert.assertEquals((long)2L, (long)b.number);
        this.r.waitForMessage("Fetching changes from the remote Git repository", (Run)b);
        this.r.waitForMessage("token macro expanded branch is remotes/origin/master", (Run)b);
        List changeSets = b.getChangeSets();
        Assert.assertEquals((long)1L, (long)changeSets.size());
        ChangeLogSet changeSet = (ChangeLogSet)changeSets.get(0);
        Assert.assertEquals((Object)b, (Object)changeSet.getRun());
        Assert.assertEquals((Object)"git", (Object)changeSet.getKind());
        Iterator iterator = changeSet.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        ChangeLogSet.Entry entry = (ChangeLogSet.Entry)iterator.next();
        Assert.assertEquals((Object)"[nextfile]", (Object)entry.getAffectedPaths().toString());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void multipleSCMs() throws Exception {
        Assume.assumeTrue((String)"Test class max time 200 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.otherRepo.init();
        this.otherRepo.write("otherfile", "");
        this.otherRepo.git("add", "otherfile");
        this.otherRepo.git("commit", "--message=init");
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "demo");
        p.addTrigger((Trigger)new SCMTrigger(""));
        p.setQuietPeriod(Integer.valueOf(3));
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n    ws {\n        dir('main') {\n            git($/" + this.sampleRepo + "/$)\n        }\n        dir('other') {\n            git($/" + this.otherRepo + "/$)\n        }\n        archive '**'\n    }\n}", true));
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        VirtualFile artifacts = b.getArtifactManager().root();
        Assert.assertTrue((boolean)artifacts.child("main/file").isFile());
        Assert.assertTrue((boolean)artifacts.child("other/otherfile").isFile());
        this.sampleRepo.write("file2", "");
        this.sampleRepo.git("add", "file2");
        this.sampleRepo.git("commit", "--message=file2");
        this.otherRepo.write("otherfile2", "");
        this.otherRepo.git("add", "otherfile2");
        this.otherRepo.git("commit", "--message=otherfile2");
        this.sampleRepo.notifyCommit(this.r);
        this.otherRepo.notifyCommit(this.r);
        b = p.getLastBuild();
        Assert.assertEquals((long)2L, (long)b.number);
        artifacts = b.getArtifactManager().root();
        Assert.assertTrue((boolean)artifacts.child("main/file2").isFile());
        Assert.assertTrue((boolean)artifacts.child("other/otherfile2").isFile());
        Iterator scms = p.getSCMs().iterator();
        Assert.assertTrue((boolean)scms.hasNext());
        Assert.assertEquals((Object)this.sampleRepo.toString(), (Object)((URIish)((RemoteConfig)((GitSCM)scms.next()).getRepositories().get(0)).getURIs().get(0)).toString());
        Assert.assertTrue((boolean)scms.hasNext());
        Assert.assertEquals((Object)this.otherRepo.toString(), (Object)((URIish)((RemoteConfig)((GitSCM)scms.next()).getRepositories().get(0)).getURIs().get(0)).toString());
        Assert.assertFalse((boolean)scms.hasNext());
        List changeSets = b.getChangeSets();
        Assert.assertEquals((long)2L, (long)changeSets.size());
        ChangeLogSet changeSet = (ChangeLogSet)changeSets.get(0);
        Assert.assertEquals((Object)b, (Object)changeSet.getRun());
        Assert.assertEquals((Object)"git", (Object)changeSet.getKind());
        Iterator iterator = changeSet.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        ChangeLogSet.Entry entry = (ChangeLogSet.Entry)iterator.next();
        Assert.assertEquals((Object)"[file2]", (Object)entry.getAffectedPaths().toString());
        Assert.assertFalse((boolean)iterator.hasNext());
        changeSet = (ChangeLogSet)changeSets.get(1);
        iterator = changeSet.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        entry = (ChangeLogSet.Entry)iterator.next();
        Assert.assertEquals((Object)"[otherfile2]", (Object)entry.getAffectedPaths().toString());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void identicalGitSCMs() throws Exception {
        Assume.assumeTrue((String)"Test class max time 200 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.otherRepo.init();
        this.otherRepo.write("firstfile", "");
        this.otherRepo.git("add", "firstfile");
        this.otherRepo.git("commit", "--message=init");
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "demo");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n    dir('main') {\n        git($/" + this.otherRepo + "/$)\n    }\n    dir('other') {\n        git($/" + this.otherRepo + "/$)\n    }\n}", true));
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        Assert.assertEquals((long)1L, (long)b.getActions(BuildData.class).size());
        Assert.assertEquals((long)0L, (long)b.getActions(GitTagAction.class).size());
        Assert.assertEquals((long)0L, (long)b.getChangeSets().size());
        Assert.assertEquals((long)1L, (long)p.getSCMs().size());
        this.otherRepo.write("secondfile", "");
        this.otherRepo.git("add", "secondfile");
        this.otherRepo.git("commit", "--message=second");
        WorkflowRun b2 = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        Assert.assertEquals((long)1L, (long)b2.getActions(BuildData.class).size());
        Assert.assertEquals((long)0L, (long)b2.getActions(GitTagAction.class).size());
        Assert.assertEquals((long)1L, (long)b2.getChangeSets().size());
        Assert.assertFalse((boolean)((ChangeLogSet)b2.getChangeSets().get(0)).isEmptySet());
        Assert.assertEquals((long)1L, (long)p.getSCMs().size());
    }

    @Test
    public void commitToWorkspace() throws Exception {
        Assume.assumeTrue((String)"Test class max time 200 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("def rungit(cmd) {def gitcmd = \"git ${cmd}\"; if (isUnix()) {sh gitcmd} else {bat gitcmd}}\nnode {\n  git url: $/" + this.sampleRepo + "/$\n  writeFile file: 'file', text: 'edited by build'\n  rungit 'config --local commit.gpgsign false'\n  rungit 'config --local tag.gpgSign false'\n  rungit 'commit --all --message=edits'\n  rungit 'show master'\n}", true));
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        this.r.waitForMessage("+edited by build", (Run)b);
    }
}

