/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.git.ApiTokenPropertyConfiguration;
import hudson.plugins.git.GitSCM;
import hudson.util.StreamTaskListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.git.CliGitCommand;
import jenkins.scm.impl.mock.AbstractSampleDVCSRepoRule;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.htmlunit.WebResponse;
import org.htmlunit.util.NameValuePair;
import org.jvnet.hudson.test.JenkinsRule;

public final class GitSampleRepoRule
extends AbstractSampleDVCSRepoRule {
    private static boolean initialized = false;
    private static final Logger LOGGER = Logger.getLogger(GitSampleRepoRule.class.getName());

    public void before() throws Throwable {
        super.before();
        GitSCM.ALLOW_LOCAL_CHECKOUT = true;
    }

    public void after() {
        super.after();
        GitSCM.ALLOW_LOCAL_CHECKOUT = false;
    }

    public void git(String ... cmds) throws Exception {
        this.run("git", cmds);
    }

    private static void checkGlobalConfig() throws Exception {
        if (initialized) {
            return;
        }
        initialized = true;
        CliGitCommand gitCmd = new CliGitCommand(null, new String[0]);
        gitCmd.setDefaults();
    }

    public void init() throws Exception {
        GitSampleRepoRule.run((boolean)true, (File)this.tmp.getRoot(), (String[])new String[]{"git", "version"});
        GitSampleRepoRule.checkGlobalConfig();
        this.git("init", "--template=");
        if (this.gitVersionAtLeast(2, 30)) {
            this.git("branch", "-m", "master");
        }
        this.write("file", "");
        this.git("add", "file");
        this.git("config", "user.name", "Git SampleRepoRule");
        this.git("config", "user.email", "gits@mplereporule");
        this.git("config", "init.defaultbranch", "master");
        this.git("config", "commit.gpgsign", "false");
        this.git("config", "tag.gpgSign", "false");
        this.git("commit", "--message=init");
    }

    public final boolean mkdirs(String rel) throws IOException {
        return new File(this.sampleRepo, rel).mkdirs();
    }

    public void notifyCommit(JenkinsRule r) throws Exception {
        this.synchronousPolling(r);
        String notifyCommitToken = ApiTokenPropertyConfiguration.get().generateApiToken("notifyCommit").getString("value");
        WebResponse webResponse = r.createWebClient().goTo("git/notifyCommit?url=" + this.bareUrl() + "&token=" + notifyCommitToken, "text/plain").getWebResponse();
        LOGGER.log(Level.FINE, webResponse.getContentAsString());
        for (NameValuePair pair : webResponse.getResponseHeaders()) {
            if (!pair.getName().equals("Triggered")) continue;
            LOGGER.log(Level.FINE, "Triggered: " + pair.getValue());
        }
        r.waitUntilNoActivity();
    }

    public String head() throws Exception {
        return ((RepositoryBuilder)new RepositoryBuilder().setWorkTree(this.sampleRepo)).build().resolve("HEAD").name();
    }

    public File getRoot() {
        return this.sampleRepo;
    }

    public boolean gitVersionAtLeast(int neededMajor, int neededMinor) {
        return this.gitVersionAtLeast(neededMajor, neededMinor, 0);
    }

    public boolean gitVersionAtLeast(int neededMajor, int neededMinor, int neededPatch) {
        StreamTaskListener procListener = StreamTaskListener.fromStderr();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int returnCode = new Launcher.LocalLauncher((TaskListener)procListener).launch().cmds(new String[]{"git", "--version"}).stdout((OutputStream)out).join();
            if (returnCode != 0) {
                LOGGER.log(Level.WARNING, "Command 'git --version' returned " + returnCode);
            }
        }
        catch (IOException | InterruptedException ex) {
            LOGGER.log(Level.WARNING, "Exception checking git version " + ex);
        }
        String versionOutput = out.toString().trim();
        String[] fields = versionOutput.split(" ")[2].replaceAll("msysgit.", "").replaceAll("windows.", "").split("\\.");
        int gitMajor = Integer.parseInt(fields[0]);
        int gitMinor = Integer.parseInt(fields[1]);
        int gitPatch = Integer.parseInt(fields[2]);
        if (gitMajor < 1 || gitMajor > 3) {
            LOGGER.log(Level.WARNING, "Unexpected git major version " + gitMajor + " parsed from '" + versionOutput + "', field:'" + fields[0] + "'");
        }
        if (gitMinor < 0 || gitMinor > 50) {
            LOGGER.log(Level.WARNING, "Unexpected git minor version " + gitMinor + " parsed from '" + versionOutput + "', field:'" + fields[1] + "'");
        }
        if (gitPatch < 0 || gitPatch > 20) {
            LOGGER.log(Level.WARNING, "Unexpected git patch version " + gitPatch + " parsed from '" + versionOutput + "', field:'" + fields[2] + "'");
        }
        return gitMajor > neededMajor || gitMajor == neededMajor && gitMinor > neededMinor || gitMajor == neededMajor && gitMinor == neededMinor && gitPatch >= neededPatch;
    }

    public boolean hasGitLFS() {
        StreamTaskListener procListener = StreamTaskListener.fromStderr();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int returnCode = new Launcher.LocalLauncher((TaskListener)procListener).launch().cmds(new String[]{"git", "lfs", "version"}).stdout((OutputStream)out).join();
            if (returnCode != 0) {
                return false;
            }
        }
        catch (IOException | InterruptedException ex) {
            return false;
        }
        String versionOutput = out.toString().trim();
        return versionOutput.startsWith("git-lfs/");
    }
}

