/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.util.GitUtils;
import hudson.slaves.DumbSlave;
import hudson.util.StreamTaskListener;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class GitUtilsJenkinsRuleTest {
    @ClassRule
    public static JenkinsRule r = new JenkinsRule();

    @Test
    public void testWorkspaceToNode() throws Exception {
        String labelString = "label-" + UUID.randomUUID();
        LabelAtom label = new LabelAtom(labelString);
        DumbSlave agent = r.createOnlineSlave((Label)label);
        FilePath workspace = agent.getWorkspaceRoot();
        MatcherAssert.assertThat((Object)GitUtils.workspaceToNode((FilePath)workspace).getLabelString(), (Matcher)Matchers.is((Object)labelString));
        MatcherAssert.assertThat((Object)GitUtils.workspaceToNode((FilePath)r.getInstance().getRootPath()), (Matcher)Matchers.is((Object)r.getInstance()));
    }

    @Test
    public void testWorkspaceToNodeRootPath() {
        MatcherAssert.assertThat((Object)GitUtils.workspaceToNode((FilePath)r.getInstance().getRootPath()), (Matcher)Matchers.is((Object)r.getInstance()));
    }

    @Test
    public void testWorkspaceToNodeNullWorkspace() {
        MatcherAssert.assertThat((Object)GitUtils.workspaceToNode(null), (Matcher)Matchers.is((Object)r.getInstance()));
    }

    @Test
    public void testResolveGitTool() {
        TaskListener listener = StreamTaskListener.NULL;
        String gitTool = "Default";
        GitTool tool = GitUtils.resolveGitTool((String)gitTool, (TaskListener)listener);
        MatcherAssert.assertThat((Object)tool.getGitExe(), (Matcher)Matchers.startsWith((String)"git"));
    }

    @Test
    public void testResolveGitToolNull() {
        TaskListener listener = StreamTaskListener.NULL;
        String gitTool = null;
        GitTool tool = GitUtils.resolveGitTool(gitTool, (TaskListener)listener);
        MatcherAssert.assertThat((Object)tool.getGitExe(), (Matcher)Matchers.startsWith((String)"git"));
    }

    @Test
    public void testResolveGitToolNonExistentTool() {
        TaskListener listener = StreamTaskListener.NULL;
        String gitTool = "non-existent-tool";
        GitTool tool = GitUtils.resolveGitTool((String)gitTool, (TaskListener)listener);
        MatcherAssert.assertThat((Object)tool.getGitExe(), (Matcher)Matchers.startsWith((String)"git"));
    }

    @Test
    public void testResolveGitToolBuiltOnNull() {
        TaskListener listener = StreamTaskListener.NULL;
        String gitTool = null;
        Node builtOn = null;
        EnvVars env = new EnvVars();
        GitTool tool = GitUtils.resolveGitTool(gitTool, builtOn, (EnvVars)env, (TaskListener)listener);
        MatcherAssert.assertThat((Object)tool.getGitExe(), (Matcher)Matchers.startsWith((String)"git"));
    }

    @Test
    public void testResolveGitToolBuiltOnAgent() throws Exception {
        TaskListener listener = StreamTaskListener.NULL;
        String gitTool = "/opt/my-non-existing-git/bin/git";
        String labelString = "label-" + UUID.randomUUID();
        LabelAtom label = new LabelAtom(labelString);
        DumbSlave agent = r.createOnlineSlave((Label)label);
        EnvVars env = new EnvVars();
        GitTool tool = GitUtils.resolveGitTool((String)gitTool, (Node)agent, (EnvVars)env, (TaskListener)listener);
        MatcherAssert.assertThat((Object)tool.getGitExe(), (Matcher)Matchers.startsWith((String)"git"));
    }
}

