/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.model.Result;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.Build;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.eclipse.jgit.lib.ObjectId;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class BuildTest {
    private final int BUILD_NUMBER = 1;
    private final Result BUILD_RESULT = Result.NOT_BUILT;
    private final Build nullRevisionBuild = new Build(null, 1, this.BUILD_RESULT);
    private final ObjectId objectId = ObjectId.fromString((String)"b04752abaaa9ee3112b0c9d1910093c977d4e583");
    private final Revision revision = new Revision(this.objectId);
    private final Build build = new Build(this.revision, 1, this.BUILD_RESULT);
    private final ObjectId markedId = ObjectId.fromString((String)"deedbeadfeedcededeafc9d1910093c977d4e583");
    private final Revision markedRevision = new Revision(this.markedId);
    private final Build markedBuild = new Build(this.markedRevision, this.revision, 1, this.BUILD_RESULT);

    @Test
    public void testGetSHA1() {
        MatcherAssert.assertThat((Object)this.build.getSHA1(), (Matcher)Matchers.is((Object)this.revision.getSha1()));
    }

    @Test
    public void testGetRevision() {
        MatcherAssert.assertThat((Object)this.build.getRevision(), (Matcher)Matchers.is((Object)this.revision));
    }

    @Test
    public void testGetMarked() {
        MatcherAssert.assertThat((Object)this.build.getMarked(), (Matcher)Matchers.is((Object)this.revision));
    }

    @Test
    public void testGetMarkedDifferentRevision() {
        MatcherAssert.assertThat((Object)this.markedBuild.getMarked(), (Matcher)Matchers.is((Object)this.markedRevision));
    }

    @Test
    public void testGetBuildNumber() {
        MatcherAssert.assertThat((Object)this.build.getBuildNumber(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testGetBuildResult() {
        MatcherAssert.assertThat((Object)this.build.getBuildResult(), (Matcher)Matchers.is((Object)this.BUILD_RESULT));
    }

    @Test
    public void testToString() {
        MatcherAssert.assertThat((Object)this.build.toString(), (Matcher)Matchers.is((Object)("Build #1 of Revision " + this.revision.getSha1String() + " ()")));
    }

    @Test
    public void testClone() {
        Build clonedBuild = this.build.clone();
        MatcherAssert.assertThat((Object)clonedBuild.getSHA1(), (Matcher)Matchers.is((Object)this.build.getSHA1()));
    }

    @Test
    public void testCloneNullRevision() {
        Build clonedBuild = this.nullRevisionBuild.clone();
        MatcherAssert.assertThat((Object)clonedBuild.getRevision(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testIsFor() {
        MatcherAssert.assertThat((Object)this.build.isFor(this.revision.getSha1String()), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testIsForMarkedRevision() {
        MatcherAssert.assertThat((Object)this.markedBuild.isFor(this.revision.getSha1String()), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.markedBuild.isFor(this.markedRevision.getSha1String()), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsForNullRevision() {
        MatcherAssert.assertThat((Object)this.nullRevisionBuild.isFor(this.revision.getSha1String()), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testReadResolve() throws Exception {
        MatcherAssert.assertThat((Object)this.build.readResolve(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(this.build.getClass())));
    }

    @Test
    public void testReadResolveNullRevision() throws Exception {
        Object readObject = this.nullRevisionBuild.readResolve();
        MatcherAssert.assertThat((Object)readObject, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(this.build.getClass())));
        Build readBuild = (Build)readObject;
        MatcherAssert.assertThat((Object)readBuild.getMarked(), (Matcher)Matchers.is((Object)readBuild.getRevision()));
        MatcherAssert.assertThat((Object)this.nullRevisionBuild.readResolve(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(this.build.getClass())));
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(Build.class).usingGetClass().suppress(new Warning[]{Warning.NONFINAL_FIELDS}).withIgnoredFields(new String[]{"hudsonBuildResult"}).verify();
    }
}

