/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.FilePath;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.util.GitUtilsTest;
import hudson.util.LogTaskListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.util.SystemReader;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.TestCliGitAPIImpl;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.JenkinsRule;

public class PruneStaleTagPipelineTest {
    @Rule
    public TemporaryFolder fileRule = new TemporaryFolder();
    @Rule
    public JenkinsRule j = new JenkinsRule();
    private TaskListener listener;

    @Before
    public void setup() throws Exception {
        this.listener = new LogTaskListener(Logger.getLogger("prune tags"), Level.FINEST);
    }

    @Before
    public void allowNonRemoteCheckout() throws ConfigInvalidException, IOException {
        SystemReader.getInstance().getUserConfig().clear();
        GitSCM.ALLOW_LOCAL_CHECKOUT = true;
    }

    @After
    public void disallowNonRemoteCheckout() {
        GitSCM.ALLOW_LOCAL_CHECKOUT = false;
    }

    @Test
    public void verify_that_local_tag_is_pruned_when_not_exist_on_remote_using_pipeline() throws Exception {
        File remoteRepo = this.fileRule.newFolder("remote");
        GitClient remoteClient = this.initRepository(remoteRepo);
        String tagName = "tag";
        String tagComment = "tag comment";
        remoteClient.tag(tagName, tagComment);
        WorkflowJob job = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "pruneTags");
        FilePath workspace = this.j.jenkins.getWorkspaceFor((TopLevelItem)job);
        String remoteURL = "file://" + remoteRepo.toURI().getPath();
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("  node {\n    checkout([$class: 'GitSCM',\n             branches: [[name: '*/master']],\n             extensions: [pruneTags(true)],\n             userRemoteConfigs: [[url: '" + remoteURL + "']]\n    ])\n    def tokenBranch = tm '${GIT_BRANCH,fullName=false}'\n    echo \"token macro expanded branch is ${tokenBranch}\"\n  }\n", true));
        WorkflowRun r = (WorkflowRun)job.scheduleBuild2(0, new Action[0]).waitForStart();
        this.j.assertBuildStatus(Result.SUCCESS, (Run)((WorkflowRun)this.j.waitForCompletion((Run)r)));
        this.j.waitForMessage("token macro expanded branch is remotes/origin/master", (Run)r);
        remoteClient.deleteTag(tagName);
        r = (WorkflowRun)job.scheduleBuild2(0, new Action[0]).waitForStart();
        this.j.assertBuildStatus(Result.SUCCESS, (Run)((WorkflowRun)this.j.waitForCompletion((Run)r)));
        GitClient localClient = this.newGitClient(new File(workspace.getRemote()));
        Assert.assertFalse((String)"local tag has not been pruned", (boolean)localClient.tagExists(tagName));
    }

    private GitClient newGitClient(File localRepo) {
        String gitExe = Functions.isWindows() ? "git.exe" : "git";
        return new TestCliGitAPIImpl(gitExe, localRepo, this.listener, GitUtilsTest.getConfigNoSystemEnvsVars());
    }

    private GitClient initRepository(File workspace) throws Exception {
        GitClient remoteClient = this.newGitClient(workspace);
        remoteClient.init();
        FileUtils.touch((File)new File(workspace, "test"));
        remoteClient.config(GitClient.ConfigLevel.LOCAL, "commit.gpgsign", "false");
        remoteClient.config(GitClient.ConfigLevel.LOCAL, "tag.gpgSign", "false");
        remoteClient.add("test");
        remoteClient.commit("initial commit");
        return remoteClient;
    }
}

