// CHECKSTYLE:OFF

package hudson.plugins.git;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code BuildChooser_Ancestry}: {@code Ancestry}.
     * 
     * @return
     *     {@code Ancestry}
     */
    public static String BuildChooser_Ancestry() {
        return holder.format("BuildChooser_Ancestry");
    }

    /**
     * Key {@code BuildChooser_Ancestry}: {@code Ancestry}.
     * 
     * @return
     *     {@code Ancestry}
     */
    public static Localizable _BuildChooser_Ancestry() {
        return new Localizable(holder, "BuildChooser_Ancestry");
    }

    /**
     * Key {@code UserRemoteConfig.CheckRefSpec.InvalidRefSpec}: {@code
     * Specification is invalid.}.
     * 
     * @return
     *     {@code Specification is invalid.}
     */
    public static String UserRemoteConfig_CheckRefSpec_InvalidRefSpec() {
        return holder.format("UserRemoteConfig.CheckRefSpec.InvalidRefSpec");
    }

    /**
     * Key {@code UserRemoteConfig.CheckRefSpec.InvalidRefSpec}: {@code
     * Specification is invalid.}.
     * 
     * @return
     *     {@code Specification is invalid.}
     */
    public static Localizable _UserRemoteConfig_CheckRefSpec_InvalidRefSpec() {
        return new Localizable(holder, "UserRemoteConfig.CheckRefSpec.InvalidRefSpec");
    }

    /**
     * Key {@code GitPublisher.Check.RemoteName}: {@code Remote Name}.
     * 
     * @return
     *     {@code Remote Name}
     */
    public static String GitPublisher_Check_RemoteName() {
        return holder.format("GitPublisher.Check.RemoteName");
    }

    /**
     * Key {@code GitPublisher.Check.RemoteName}: {@code Remote Name}.
     * 
     * @return
     *     {@code Remote Name}
     */
    public static Localizable _GitPublisher_Check_RemoteName() {
        return new Localizable(holder, "GitPublisher.Check.RemoteName");
    }

    /**
     * Key {@code BuildChooser_Inverse}: {@code Inverse}.
     * 
     * @return
     *     {@code Inverse}
     */
    public static String BuildChooser_Inverse() {
        return holder.format("BuildChooser_Inverse");
    }

    /**
     * Key {@code BuildChooser_Inverse}: {@code Inverse}.
     * 
     * @return
     *     {@code Inverse}
     */
    public static Localizable _BuildChooser_Inverse() {
        return new Localizable(holder, "BuildChooser_Inverse");
    }

    /**
     * Key {@code GitPublisher.Check.BranchName}: {@code Branch Name}.
     * 
     * @return
     *     {@code Branch Name}
     */
    public static String GitPublisher_Check_BranchName() {
        return holder.format("GitPublisher.Check.BranchName");
    }

    /**
     * Key {@code GitPublisher.Check.BranchName}: {@code Branch Name}.
     * 
     * @return
     *     {@code Branch Name}
     */
    public static Localizable _GitPublisher_Check_BranchName() {
        return new Localizable(holder, "GitPublisher.Check.BranchName");
    }

    /**
     * Key {@code GitPublisher.Check.Required}: {@code {0} is required.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is required.}
     */
    public static String GitPublisher_Check_Required(Object arg0) {
        return holder.format("GitPublisher.Check.Required", arg0);
    }

    /**
     * Key {@code GitPublisher.Check.Required}: {@code {0} is required.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is required.}
     */
    public static Localizable _GitPublisher_Check_Required(Object arg0) {
        return new Localizable(holder, "GitPublisher.Check.Required", arg0);
    }

    /**
     * Key {@code check.out.to.specific.local.branch}: {@code Check out to
     * specific local branch}.
     * 
     * @return
     *     {@code Check out to specific local branch}
     */
    public static String check_out_to_specific_local_branch() {
        return holder.format("check.out.to.specific.local.branch");
    }

    /**
     * Key {@code check.out.to.specific.local.branch}: {@code Check out to
     * specific local branch}.
     * 
     * @return
     *     {@code Check out to specific local branch}
     */
    public static Localizable _check_out_to_specific_local_branch() {
        return new Localizable(holder, "check.out.to.specific.local.branch");
    }

    /**
     * Key {@code invalidUrl}: {@code Invalid URL}.
     * 
     * @return
     *     {@code Invalid URL}
     */
    public static String invalidUrl() {
        return holder.format("invalidUrl");
    }

    /**
     * Key {@code invalidUrl}: {@code Invalid URL}.
     * 
     * @return
     *     {@code Invalid URL}
     */
    public static Localizable _invalidUrl() {
        return new Localizable(holder, "invalidUrl");
    }

    /**
     * Key {@code advanced.sub_modules.behaviours}: {@code Advanced
     * sub-modules behaviours}.
     * 
     * @return
     *     {@code Advanced sub-modules behaviours}
     */
    public static String advanced_sub_modules_behaviours() {
        return holder.format("advanced.sub_modules.behaviours");
    }

    /**
     * Key {@code advanced.sub_modules.behaviours}: {@code Advanced
     * sub-modules behaviours}.
     * 
     * @return
     *     {@code Advanced sub-modules behaviours}
     */
    public static Localizable _advanced_sub_modules_behaviours() {
        return new Localizable(holder, "advanced.sub_modules.behaviours");
    }

    /**
     * Key {@code BuildChooser_Inverse_EverythingExcluded}: {@code All
     * current git branches were excluded from being built. Either your
     * branch specifiers are too broad or you should be using the "Default"
     * choosing strategy.}.
     * 
     * @return
     *     {@code All current git branches were excluded from being built. Either
     *     your branch specifiers are too broad or you should be using the
     *     "Default" choosing strategy.}
     */
    public static String BuildChooser_Inverse_EverythingExcluded() {
        return holder.format("BuildChooser_Inverse_EverythingExcluded");
    }

    /**
     * Key {@code BuildChooser_Inverse_EverythingExcluded}: {@code All
     * current git branches were excluded from being built. Either your
     * branch specifiers are too broad or you should be using the "Default"
     * choosing strategy.}.
     * 
     * @return
     *     {@code All current git branches were excluded from being built. Either
     *     your branch specifiers are too broad or you should be using the
     *     "Default" choosing strategy.}
     */
    public static Localizable _BuildChooser_Inverse_EverythingExcluded() {
        return new Localizable(holder, "BuildChooser_Inverse_EverythingExcluded");
    }

    /**
     * Key {@code check.out.to.a.sub_directory}: {@code Check out to a
     * sub-directory}.
     * 
     * @return
     *     {@code Check out to a sub-directory}
     */
    public static String check_out_to_a_sub_directory() {
        return holder.format("check.out.to.a.sub_directory");
    }

    /**
     * Key {@code check.out.to.a.sub_directory}: {@code Check out to a
     * sub-directory}.
     * 
     * @return
     *     {@code Check out to a sub-directory}
     */
    public static Localizable _check_out_to_a_sub_directory() {
        return new Localizable(holder, "check.out.to.a.sub_directory");
    }

    /**
     * Key {@code UserRemoteConfig.FailedToConnect}: {@code Failed to connect
     * to repository : {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to connect to repository : {0}}
     */
    public static String UserRemoteConfig_FailedToConnect(Object arg0) {
        return holder.format("UserRemoteConfig.FailedToConnect", arg0);
    }

    /**
     * Key {@code UserRemoteConfig.FailedToConnect}: {@code Failed to connect
     * to repository : {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to connect to repository : {0}}
     */
    public static Localizable _UserRemoteConfig_FailedToConnect(Object arg0) {
        return new Localizable(holder, "UserRemoteConfig.FailedToConnect", arg0);
    }

    /**
     * Key {@code UserRemoteConfig.CheckUrl.UrlIsNull}: {@code Please enter
     * Git repository.}.
     * 
     * @return
     *     {@code Please enter Git repository.}
     */
    public static String UserRemoteConfig_CheckUrl_UrlIsNull() {
        return holder.format("UserRemoteConfig.CheckUrl.UrlIsNull");
    }

    /**
     * Key {@code UserRemoteConfig.CheckUrl.UrlIsNull}: {@code Please enter
     * Git repository.}.
     * 
     * @return
     *     {@code Please enter Git repository.}
     */
    public static Localizable _UserRemoteConfig_CheckUrl_UrlIsNull() {
        return new Localizable(holder, "UserRemoteConfig.CheckUrl.UrlIsNull");
    }

    /**
     * Key {@code advanced.checkout.behaviours}: {@code Advanced checkout
     * behaviours}.
     * 
     * @return
     *     {@code Advanced checkout behaviours}
     */
    public static String advanced_checkout_behaviours() {
        return holder.format("advanced.checkout.behaviours");
    }

    /**
     * Key {@code advanced.checkout.behaviours}: {@code Advanced checkout
     * behaviours}.
     * 
     * @return
     *     {@code Advanced checkout behaviours}
     */
    public static Localizable _advanced_checkout_behaviours() {
        return new Localizable(holder, "advanced.checkout.behaviours");
    }

    /**
     * Key {@code GitPublisher.Check.TagName}: {@code Tag Name}.
     * 
     * @return
     *     {@code Tag Name}
     */
    public static String GitPublisher_Check_TagName() {
        return holder.format("GitPublisher.Check.TagName");
    }

    /**
     * Key {@code GitPublisher.Check.TagName}: {@code Tag Name}.
     * 
     * @return
     *     {@code Tag Name}
     */
    public static Localizable _GitPublisher_Check_TagName() {
        return new Localizable(holder, "GitPublisher.Check.TagName");
    }

    /**
     * Key {@code BuildChooser_Default}: {@code Default}.
     * 
     * @return
     *     {@code Default}
     */
    public static String BuildChooser_Default() {
        return holder.format("BuildChooser_Default");
    }

    /**
     * Key {@code BuildChooser_Default}: {@code Default}.
     * 
     * @return
     *     {@code Default}
     */
    public static Localizable _BuildChooser_Default() {
        return new Localizable(holder, "BuildChooser_Default");
    }

    /**
     * Key {@code BuildChooser_BuildingLastRevision}: {@code No new revisions
     * were found; the most-recently built branch will be built again.}.
     * 
     * @return
     *     {@code No new revisions were found; the most-recently built branch
     *     will be built again.}
     */
    public static String BuildChooser_BuildingLastRevision() {
        return holder.format("BuildChooser_BuildingLastRevision");
    }

    /**
     * Key {@code BuildChooser_BuildingLastRevision}: {@code No new revisions
     * were found; the most-recently built branch will be built again.}.
     * 
     * @return
     *     {@code No new revisions were found; the most-recently built branch
     *     will be built again.}
     */
    public static Localizable _BuildChooser_BuildingLastRevision() {
        return new Localizable(holder, "BuildChooser_BuildingLastRevision");
    }

    /**
     * Key {@code GitPublisher.Check.Note}: {@code Note}.
     * 
     * @return
     *     {@code Note}
     */
    public static String GitPublisher_Check_Note() {
        return holder.format("GitPublisher.Check.Note");
    }

    /**
     * Key {@code GitPublisher.Check.Note}: {@code Note}.
     * 
     * @return
     *     {@code Note}
     */
    public static Localizable _GitPublisher_Check_Note() {
        return new Localizable(holder, "GitPublisher.Check.Note");
    }

}
