/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.plugins.git.GitTool;
import hudson.tasks.BatchFile;
import hudson.tasks.Shell;
import hudson.tools.ToolInstallation;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.plugins.git.GitUsernamePasswordBinding;
import jenkins.plugins.git.RandomOrder;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.SecretBuildWrapper;
import org.jenkinsci.plugins.gitclient.CliGitAPIImpl;
import org.jenkinsci.plugins.gitclient.JGitApacheTool;
import org.jenkinsci.plugins.gitclient.JGitTool;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Stopwatch;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;
import org.junit.runner.OrderWith;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;

@OrderWith(value=RandomOrder.class)
@RunWith(value=Parameterized.class)
public class GitUsernamePasswordBindingTest {
    @ClassRule
    public static BuildWatcher bw = new BuildWatcher();
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule g = new GitSampleRepoRule();
    @ClassRule
    public static Stopwatch stopwatch = new Stopwatch();
    @Rule
    public TestName testName = new TestName();
    private static final int MAX_SECONDS_FOR_THESE_TESTS = 200;
    private final String username;
    private final String password;
    private final GitTool gitToolInstance;
    private final String credentialID = DigestUtils.sha256Hex((byte[])"Git Usernanme and Password Binding".getBytes(StandardCharsets.UTF_8));
    private File rootDir = null;
    private FilePath rootFilePath = null;
    private UsernamePasswordCredentialsImpl credentials = null;
    private GitUsernamePasswordBinding gitCredBind = null;
    private static final Random random = new Random();
    private static String[] userNames = new String[]{"adwesw-unique", "bceas-unique", "many-words-in-a-user-name-because-we-can", "r-Name", "randomName"};
    private static String[] passwords = new String[]{"&Ampersand&", "He said \"Hello\", then left.", "default=@#(*^!", "has_a_trailing_quote=@#(*^!'", "here's-a-quote", "special%%_342@**", "%interior-single-quote%_786'@**"};
    private static GitTool[] gitTools = new GitTool[]{new GitTool("Default", "git", null), new GitTool("git", "git", null), new JGitApacheTool(), new JGitTool()};
    private static Object[][] testData = new Object[][]{{userNames[random.nextInt(userNames.length)], passwords[random.nextInt(passwords.length)], gitTools[random.nextInt(gitTools.length)]}, {userNames[random.nextInt(userNames.length)], passwords[random.nextInt(passwords.length)], gitTools[random.nextInt(gitTools.length)]}, {userNames[random.nextInt(userNames.length)], passwords[random.nextInt(passwords.length)], gitTools[random.nextInt(gitTools.length)]}};

    @Parameterized.Parameters(name="User {0}: Password {1}: GitToolInstance {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(testData);
    }

    private boolean isTimeAvailable() {
        String env = System.getenv("CI");
        if (env == null || !Boolean.parseBoolean(env)) {
            return true;
        }
        return stopwatch.runtime(TimeUnit.SECONDS) <= 200L;
    }

    public GitUsernamePasswordBindingTest(String username, String password, GitTool gitToolInstance) {
        this.username = username;
        this.password = password;
        this.gitToolInstance = gitToolInstance;
    }

    @Before
    public void basicSetup() throws IOException {
        this.rootDir = this.tempFolder.getRoot();
        this.rootFilePath = new FilePath(this.rootDir.getAbsoluteFile());
        this.credentials = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, this.credentialID, "Git Username and Password Binding Test", this.username, this.password);
        ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)this.r.jenkins).iterator().next()).addCredentials(Domain.global(), (Credentials)this.credentials);
        this.gitCredBind = new GitUsernamePasswordBinding(this.gitToolInstance.getName(), this.credentials.getId());
        MatcherAssert.assertThat((Object)this.gitCredBind.type(), (Matcher)Matchers.is(StandardUsernamePasswordCredentials.class));
        ((GitTool.DescriptorImpl)Jenkins.get().getDescriptorByType(GitTool.DescriptorImpl.class)).getDefaultInstallers().clear();
        ((GitTool.DescriptorImpl)Jenkins.get().getDescriptorByType(GitTool.DescriptorImpl.class)).setInstallations((ToolInstallation[])new GitTool[]{this.gitToolInstance});
    }

    private String batchCheck(boolean includeCliCheck) {
        return includeCliCheck ? "set | findstr GIT_USERNAME > auth.txt & set | findstr GIT_PASSWORD >> auth.txt & set | findstr GCM_INTERACTIVE >> auth.txt & type auth.txt" : "set | findstr GIT_USERNAME > auth.txt & set | findstr GIT_PASSWORD >> auth.txt & type auth.txt";
    }

    private String shellCheck() {
        return "env | grep -E \"GIT_USERNAME|GIT_PASSWORD|GIT_TERMINAL_PROMPT\" > auth.txt; cat auth.txt";
    }

    @Test
    public void test_EnvironmentVariables_FreeStyleProject() throws Exception {
        Assume.assumeTrue((String)"Test class max time 200 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject prj = this.r.createFreeStyleProject();
        prj.getBuildWrappersList().add((Object)new SecretBuildWrapper(Collections.singletonList(new GitUsernamePasswordBinding(this.gitToolInstance.getName(), this.credentialID))));
        prj.getBuildersList().add(GitUsernamePasswordBindingTest.isWindows() ? new BatchFile(this.batchCheck(this.isCliGitTool())) : new Shell(this.shellCheck()));
        this.r.configRoundtrip((Item)prj);
        SecretBuildWrapper wrapper = (SecretBuildWrapper)prj.getBuildWrappersList().get(SecretBuildWrapper.class);
        MatcherAssert.assertThat((Object)wrapper, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        List bindings = wrapper.getBindings();
        MatcherAssert.assertThat((Object)bindings.size(), (Matcher)Matchers.is((Object)1));
        MultiBinding binding = (MultiBinding)bindings.get(0);
        if (this.isCliGitTool()) {
            MatcherAssert.assertThat((Object)((GitUsernamePasswordBinding)binding).getGitToolName(), (Matcher)Matchers.equalTo((Object)this.gitToolInstance.getName()));
        } else {
            MatcherAssert.assertThat((Object)((GitUsernamePasswordBinding)binding).getGitToolName(), (Matcher)Matchers.equalTo((Object)""));
        }
        FreeStyleBuild b = this.r.buildAndAssertSuccess(prj);
        if (this.credentials.isUsernameSecret()) {
            this.r.assertLogNotContains(this.username, (Run)b);
            this.r.assertLogContains("GIT_USERNAME=****", (Run)b);
        } else {
            this.r.assertLogContains("GIT_USERNAME=" + this.username, (Run)b);
        }
        this.r.assertLogNotContains(this.password, (Run)b);
        this.r.assertLogContains("GIT_PASSWORD=****", (Run)b);
        MatcherAssert.assertThat((Object)binding.variables((Run)b), (Matcher)Matchers.hasItem((Object)"GIT_USERNAME"));
        MatcherAssert.assertThat((Object)binding.variables((Run)b), (Matcher)Matchers.hasItem((Object)"GIT_PASSWORD"));
        String fileContents = b.getWorkspace().child("auth.txt").readToString().trim();
        if (this.credentials.isUsernameSecret()) {
            MatcherAssert.assertThat((Object)fileContents, (Matcher)Matchers.containsString((String)("GIT_USERNAME=" + this.username)));
        }
        MatcherAssert.assertThat((Object)fileContents, (Matcher)Matchers.containsString((String)("GIT_PASSWORD=" + this.password)));
        if (this.isCliGitTool()) {
            if (GitUsernamePasswordBindingTest.isWindows()) {
                MatcherAssert.assertThat((Object)fileContents, (Matcher)Matchers.containsString((String)"GCM_INTERACTIVE=false"));
            } else if (this.g.gitVersionAtLeast(2, 3, 0)) {
                MatcherAssert.assertThat((Object)fileContents, (Matcher)Matchers.containsString((String)"GIT_TERMINAL_PROMPT=false"));
            }
        }
    }

    @Test
    public void test_EnvironmentVariables_PipelineJob() throws Exception {
        Assume.assumeTrue((String)"Test class max time 200 exceeded", (boolean)this.isTimeAvailable());
        WorkflowJob project = (WorkflowJob)this.r.createProject(WorkflowJob.class);
        String keyword = random.nextBoolean() ? "gitUsernamePassword" : "GitUsernamePassword";
        String gitToolNameArg = !this.isCliGitTool() ? "" : ", gitToolName: '" + this.gitToolInstance.getName() + "'";
        String pipeline = "node {\n  withCredentials([" + keyword + "(credentialsId: '" + this.credentialID + "'" + gitToolNameArg + ")]) {\n    if (isUnix()) {\n      sh '" + this.shellCheck() + "'\n    } else {\n      bat '" + this.batchCheck(this.isCliGitTool()) + "'\n    }\n  }\n}";
        project.setDefinition((FlowDefinition)new CpsFlowDefinition(pipeline, true));
        WorkflowRun b = (WorkflowRun)project.scheduleBuild2(0, new Action[0]).waitForStart();
        this.r.waitForCompletion((Run)b);
        this.r.assertBuildStatusSuccess((Run)b);
        if (this.credentials.isUsernameSecret()) {
            this.r.assertLogNotContains(this.username, (Run)b);
            this.r.assertLogContains("GIT_USERNAME=****", (Run)b);
        } else {
            this.r.assertLogContains("GIT_USERNAME=" + this.username, (Run)b);
        }
        this.r.assertLogContains("GIT_PASSWORD=****", (Run)b);
        this.r.assertLogNotContains(this.password, (Run)b);
        String fileContents = this.r.jenkins.getWorkspaceFor((TopLevelItem)project).child("auth.txt").readToString().trim();
        if (this.credentials.isUsernameSecret()) {
            MatcherAssert.assertThat((Object)fileContents, (Matcher)Matchers.containsString((String)("GIT_USERNAME=" + this.username)));
        }
        MatcherAssert.assertThat((Object)fileContents, (Matcher)Matchers.containsString((String)("GIT_PASSWORD=" + this.password)));
        if (this.isCliGitTool()) {
            if (GitUsernamePasswordBindingTest.isWindows()) {
                MatcherAssert.assertThat((Object)fileContents, (Matcher)Matchers.containsString((String)"GCM_INTERACTIVE=false"));
            } else if (this.g.gitVersionAtLeast(2, 3, 0)) {
                MatcherAssert.assertThat((Object)fileContents, (Matcher)Matchers.containsString((String)"GIT_TERMINAL_PROMPT=false"));
            }
        }
    }

    @Test
    public void test_isCurrentNodeOSUnix() {
        Assume.assumeTrue((String)"Test class max time 200 exceeded", (boolean)this.isTimeAvailable());
        MatcherAssert.assertThat((Object)this.gitCredBind.isCurrentNodeOSUnix((Launcher)this.r.createLocalLauncher()), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)GitUsernamePasswordBindingTest.isWindows())));
    }

    @Test
    public void test_getCliGitTool_using_FreeStyleProject() throws Exception {
        Assume.assumeTrue((String)"Test class max time 200 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject prj = this.r.createFreeStyleProject();
        prj.getBuildWrappersList().add((Object)new SecretBuildWrapper(Collections.singletonList(new GitUsernamePasswordBinding(this.gitToolInstance.getName(), this.credentialID))));
        prj.getBuildersList().add(GitUsernamePasswordBindingTest.isWindows() ? new BatchFile(this.batchCheck(false)) : new Shell(this.shellCheck()));
        this.r.configRoundtrip((Item)prj);
        SecretBuildWrapper wrapper = (SecretBuildWrapper)prj.getBuildWrappersList().get(SecretBuildWrapper.class);
        MatcherAssert.assertThat((Object)wrapper, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        List bindings = wrapper.getBindings();
        MatcherAssert.assertThat((Object)bindings.size(), (Matcher)Matchers.is((Object)1));
        MultiBinding binding = (MultiBinding)bindings.get(0);
        FreeStyleBuild run = (FreeStyleBuild)prj.scheduleBuild2(0).waitForStart();
        if (this.isCliGitTool()) {
            MatcherAssert.assertThat((Object)((GitUsernamePasswordBinding)binding).getCliGitTool((Run)run, ((GitUsernamePasswordBinding)binding).getGitToolName(), TaskListener.NULL), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        } else {
            MatcherAssert.assertThat((Object)((GitUsernamePasswordBinding)binding).getCliGitTool((Run)run, ((GitUsernamePasswordBinding)binding).getGitToolName(), TaskListener.NULL), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
        this.r.waitForCompletion((Run)run);
        this.r.assertBuildStatusSuccess((Run)run);
    }

    @Test
    public void test_getGitClientInstance() throws IOException, InterruptedException {
        Assume.assumeTrue((String)"Test class max time 200 exceeded", (boolean)this.isTimeAvailable());
        if (this.isCliGitTool()) {
            MatcherAssert.assertThat((Object)this.gitCredBind.getGitClientInstance(this.gitToolInstance.getGitExe(), this.rootFilePath, new EnvVars(), TaskListener.NULL), (Matcher)Matchers.instanceOf(CliGitAPIImpl.class));
        } else {
            MatcherAssert.assertThat((Object)this.gitCredBind.getGitClientInstance(this.gitToolInstance.getGitExe(), this.rootFilePath, new EnvVars(), TaskListener.NULL), (Matcher)Matchers.not((Matcher)Matchers.instanceOf(CliGitAPIImpl.class)));
        }
    }

    @Test
    public void test_GenerateGitScript_write() throws Exception {
        Assume.assumeTrue((String)"Test class max time 200 exceeded", (boolean)this.isTimeAvailable());
        GitUsernamePasswordBinding.GenerateGitScript tempGenScript = new GitUsernamePasswordBinding.GenerateGitScript(this.username, this.password, this.credentials.getId(), !GitUsernamePasswordBindingTest.isWindows());
        MatcherAssert.assertThat((Object)tempGenScript.type(), (Matcher)Matchers.is(StandardUsernamePasswordCredentials.class));
        FilePath tempScriptFile = tempGenScript.write((StandardUsernamePasswordCredentials)this.credentials, this.rootFilePath);
        if (!GitUsernamePasswordBindingTest.isWindows()) {
            MatcherAssert.assertThat((Object)tempScriptFile.mode(), (Matcher)Matchers.is((Object)320));
            MatcherAssert.assertThat((String)"File extension not sh", (Object)FilenameUtils.getExtension((String)tempScriptFile.getName()), (Matcher)Matchers.is((Object)"sh"));
            MatcherAssert.assertThat((Object)tempScriptFile.readToString(), (Matcher)Matchers.containsString((String)"Username*) cat"));
            MatcherAssert.assertThat((Object)tempScriptFile.readToString(), (Matcher)Matchers.containsString((String)"Password*) cat"));
        } else {
            MatcherAssert.assertThat((String)"File extension not bat", (Object)FilenameUtils.getExtension((String)tempScriptFile.getName()), (Matcher)Matchers.is((Object)"bat"));
            MatcherAssert.assertThat((Object)tempScriptFile.readToString(), (Matcher)Matchers.containsString((String)"IF %ARG:~0,8%==Username type"));
            MatcherAssert.assertThat((Object)tempScriptFile.readToString(), (Matcher)Matchers.containsString((String)"IF %ARG:~0,8%==Password type"));
        }
    }

    private static boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }

    private boolean isCliGitTool() {
        return this.gitToolInstance.getClass().equals(GitTool.class);
    }
}

