/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.util.GitUtilsTest;
import hudson.util.ArgumentListBuilder;
import hudson.util.StreamTaskListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Repository;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;

public class CliGitCommand {
    private final TaskListener listener;
    private final transient Launcher launcher;
    private final EnvVars env;
    private final File dir;
    private String[] output;
    private ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"git"});

    public CliGitCommand(GitClient client, String ... arguments) {
        this(client, GitUtilsTest.getConfigNoSystemEnvsVars(), arguments);
    }

    public CliGitCommand(GitClient client, EnvVars envVars, String ... arguments) {
        this.args.add(arguments);
        this.listener = StreamTaskListener.NULL;
        this.launcher = new Launcher.LocalLauncher(this.listener);
        this.env = envVars;
        if (client != null) {
            try (Repository repo = client.getRepository();){
                this.dir = repo.getWorkTree();
            }
        } else {
            this.dir = new File(".");
        }
    }

    public String[] run(boolean checkForErrors, String ... arguments) throws IOException, InterruptedException {
        this.args = new ArgumentListBuilder(new String[]{"git"});
        this.args.add(arguments);
        return this.run(checkForErrors);
    }

    public String[] run(String ... arguments) throws IOException, InterruptedException {
        return this.run(true, arguments);
    }

    public String[] run() throws IOException, InterruptedException {
        return this.run(true);
    }

    private String[] run(boolean assertProcessStatus) throws IOException, InterruptedException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ByteArrayOutputStream bytesErr = new ByteArrayOutputStream();
        Launcher.ProcStarter p = this.launcher.launch().cmds(this.args).envs((Map)this.env).stdout((OutputStream)bytesOut).stderr((OutputStream)bytesErr).pwd(this.dir);
        int status = p.start().joinWithTimeout(1L, TimeUnit.MINUTES, this.listener);
        Object result = bytesOut.toString(StandardCharsets.UTF_8);
        if (bytesErr.size() > 0) {
            result = (String)result + "\nstderr not empty:\n" + bytesErr.toString(StandardCharsets.UTF_8);
        }
        this.output = ((String)result).split("[\\n\\r]");
        if (assertProcessStatus) {
            Assert.assertEquals((String)(this.args.toString() + " command failed and reported '" + Arrays.toString(this.output) + "'"), (long)0L, (long)status);
        }
        return this.output;
    }

    public void assertOutputContains(String ... expectedRegExes) {
        ArrayList<String> notFound = new ArrayList<String>();
        boolean modified = notFound.addAll(Arrays.asList(expectedRegExes));
        Assert.assertTrue((String)"Missing regular expressions in assertion", (boolean)modified);
        for (String line : this.output) {
            notFound.removeIf(line::matches);
        }
        if (!notFound.isEmpty()) {
            Assert.fail((String)(Arrays.toString(this.output) + " did not match all strings in notFound: " + Arrays.toString(expectedRegExes)));
        }
    }

    private void setConfigIfEmpty(String configName, String value) throws Exception {
        boolean checkForErrors = false;
        String[] cmdOutput = this.run(checkForErrors, "config", "--global", configName);
        if (cmdOutput == null || cmdOutput[0].isEmpty() || cmdOutput[0].equals("[]")) {
            cmdOutput = this.run("config", "--global", configName, value);
            MatcherAssert.assertThat(Arrays.asList(cmdOutput), (Matcher)Matchers.hasItems((Object[])new String[]{""}));
            cmdOutput = this.run("config", "--global", configName);
            if (cmdOutput == null || cmdOutput[0].isEmpty() || !cmdOutput[0].equals(value)) {
                throw new GitException("ERROR: git config --global " + configName + " reported '" + cmdOutput[0] + "' instead of '" + value + "'");
            }
        }
    }

    public void setDefaults() throws Exception {
        if (System.getenv("JENKINS_URL") != null && System.getenv("BUILD_NUMBER") != null) {
            this.setConfigIfEmpty("user.name", "Name From Git-Plugin-Test");
            this.setConfigIfEmpty("user.email", "email.from.git.plugin.test@example.com");
        }
    }

    public CliGitCommand env(String key, String value) {
        this.env.put(key, value);
        return this;
    }
}

