/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.EnvVars;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.git.TestGitRepo;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionTest;
import hudson.plugins.git.extensions.impl.UserIdentity;
import hudson.plugins.git.util.GitUtilsTest;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Test;
import org.jvnet.hudson.test.WithoutJenkins;

public class UserIdentityTest
extends GitSCMExtensionTest {
    TestGitRepo repo;
    GitClient git;

    @Override
    public void before() {
    }

    @Override
    protected GitSCMExtension getExtension() {
        return new UserIdentity("Jane Doe", "janeDoe@xyz.com");
    }

    @Test
    public void testUserIdentity() throws Exception {
        this.repo = new TestGitRepo("repo", this.tmp.newFolder(), this.listener);
        this.git = Git.with((TaskListener)this.listener, (EnvVars)GitUtilsTest.getConfigNoSystemEnvsVars()).in(this.repo.gitDir).getClient();
        FreeStyleProject projectWithMaster = this.setupBasicProject(this.repo);
        this.git.commit("First commit");
        FreeStyleBuild build = this.build(projectWithMaster, Result.SUCCESS);
        EnvVars envVars = build.getEnvironment(this.listener);
        MatcherAssert.assertThat((Object)"Jane Doe", (Matcher)Matchers.is((Object)((String)envVars.get((Object)"GIT_AUTHOR_NAME"))));
        MatcherAssert.assertThat((Object)"janeDoe@xyz.com", (Matcher)Matchers.is((Object)((String)envVars.get((Object)"GIT_AUTHOR_EMAIL"))));
    }

    @Test
    @WithoutJenkins
    public void testGetNameAndEmail() {
        UserIdentity userIdentity = new UserIdentity("Jane Doe", "janeDoe@xyz.com");
        MatcherAssert.assertThat((Object)"Jane Doe", (Matcher)Matchers.is((Object)userIdentity.getName()));
        MatcherAssert.assertThat((Object)"janeDoe@xyz.com", (Matcher)Matchers.is((Object)userIdentity.getEmail()));
    }

    @Test
    @WithoutJenkins
    public void equalsContract() {
        EqualsVerifier.forClass(UserIdentity.class).usingGetClass().verify();
    }
}

