/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.impl.SubmoduleOption;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildData;
import java.io.IOException;
import java.util.Random;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.UnsupportedCommand;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SubmoduleOptionTest {
    private SubmoduleOption submoduleOption;
    private static final boolean DISABLE_SUBMODULES_FALSE = false;
    private static final boolean RECURSIVE_SUBMODULES_FALSE = false;
    private static final boolean TRACKING_SUBMODULES_FALSE = false;
    private static final boolean USE_PARENT_CREDENTIALS_FALSE = false;
    private static final String SUBMODULES_REFERENCE_REPOSITORY = null;
    private static final Integer SUBMODULES_TIMEOUT = null;

    private SubmoduleOption newSubmoduleOption() {
        return new SubmoduleOption(false, false, false, SUBMODULES_REFERENCE_REPOSITORY, SUBMODULES_TIMEOUT, false);
    }

    @Before
    public void setUp() throws Exception {
        this.submoduleOption = this.newSubmoduleOption();
    }

    @Test
    public void testSubmoduleUpdateThrowsIOException() throws Exception {
        BuildData buildData = (BuildData)Mockito.mock(BuildData.class);
        Build lastBuild = (Build)Mockito.mock(Build.class);
        GitSCM scm = (GitSCM)Mockito.mock(GitSCM.class);
        Run build = (Run)Mockito.mock(Run.class);
        GitClient client = (GitClient)Mockito.mock(GitClient.class);
        TaskListener listener = (TaskListener)Mockito.mock(TaskListener.class);
        buildData.lastBuild = lastBuild;
        Mockito.when((Object)scm.getBuildData(build)).thenReturn((Object)buildData);
        Mockito.when((Object)client.hasGitModules()).thenReturn((Object)true);
        Mockito.when((Object)client.submoduleUpdate()).thenThrow(new Throwable[]{new GitException("a git exception")});
        Exception e = (Exception)Assert.assertThrows(IOException.class, () -> this.submoduleOption.onCheckoutCompleted(scm, build, client, listener));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Could not perform submodule update"));
    }

    @Test
    public void testOnCheckoutCompleted() throws Exception {
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(SubmoduleOption.class).usingGetClass().suppress(new Warning[]{Warning.NONFINAL_FIELDS}).verify();
    }

    @Test
    public void testIsDisableSubmodules() {
        MatcherAssert.assertThat((Object)this.submoduleOption.isDisableSubmodules(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsDisableSubmodulesTrue() {
        this.submoduleOption = new SubmoduleOption(true, false, false, SUBMODULES_REFERENCE_REPOSITORY, SUBMODULES_TIMEOUT, false);
        MatcherAssert.assertThat((Object)this.submoduleOption.isDisableSubmodules(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testIsRecursiveSubmodules() {
        MatcherAssert.assertThat((Object)this.submoduleOption.isRecursiveSubmodules(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsRecursiveSubmodulesTrue() {
        this.submoduleOption = new SubmoduleOption(false, true, false, SUBMODULES_REFERENCE_REPOSITORY, SUBMODULES_TIMEOUT, false);
        MatcherAssert.assertThat((Object)this.submoduleOption.isRecursiveSubmodules(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testIsTrackingSubmodules() {
        MatcherAssert.assertThat((Object)this.submoduleOption.isTrackingSubmodules(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsTrackingSubmodulesTrue() {
        this.submoduleOption = new SubmoduleOption(false, false, true, SUBMODULES_REFERENCE_REPOSITORY, SUBMODULES_TIMEOUT, false);
        MatcherAssert.assertThat((Object)this.submoduleOption.isTrackingSubmodules(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testIsParentCredentials() {
        MatcherAssert.assertThat((Object)this.submoduleOption.isParentCredentials(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsParentCredentialsTrue() {
        this.submoduleOption = new SubmoduleOption(false, false, false, SUBMODULES_REFERENCE_REPOSITORY, SUBMODULES_TIMEOUT, true);
        MatcherAssert.assertThat((Object)this.submoduleOption.isParentCredentials(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGetReference() {
        MatcherAssert.assertThat((Object)this.submoduleOption.getReference(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testGetReferenceNotNull() {
        String referenceRepoDirName = "/repo.git";
        this.submoduleOption = new SubmoduleOption(false, false, false, "/repo.git", SUBMODULES_TIMEOUT, true);
        MatcherAssert.assertThat((Object)this.submoduleOption.getReference(), (Matcher)Matchers.is((Object)"/repo.git"));
    }

    @Test
    public void testGetTimeout() {
        MatcherAssert.assertThat((Object)this.submoduleOption.getTimeout(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testGetTimeoutNotNull() {
        Integer timeout = 3;
        this.submoduleOption = new SubmoduleOption(false, false, false, SUBMODULES_REFERENCE_REPOSITORY, timeout, true);
        MatcherAssert.assertThat((Object)this.submoduleOption.getTimeout(), (Matcher)Matchers.is((Object)timeout));
    }

    @Test
    public void testSetShallow() {
        this.submoduleOption.setShallow(true);
        MatcherAssert.assertThat((Object)this.submoduleOption.getShallow(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGetShallow() {
        MatcherAssert.assertThat((Object)this.submoduleOption.getShallow(), (Matcher)Matchers.is((Object)false));
    }

    private Integer randomSmallNonNegativeIntegerOrNull() {
        Random random = new Random();
        Integer value = random.nextInt(131);
        if (value == 0) {
            value = null;
        }
        return value;
    }

    @Test
    public void testSetDepth() {
        Integer depthValue = this.randomSmallNonNegativeIntegerOrNull();
        this.submoduleOption.setDepth(depthValue);
        MatcherAssert.assertThat((Object)this.submoduleOption.getDepth(), (Matcher)Matchers.is((Object)depthValue));
    }

    @Test
    public void testGetDepth() {
        MatcherAssert.assertThat((Object)this.submoduleOption.getDepth(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testGetThreads() {
        MatcherAssert.assertThat((Object)this.submoduleOption.getThreads(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testSetThreads() {
        Integer threads = this.randomSmallNonNegativeIntegerOrNull();
        this.submoduleOption.setThreads(threads);
        MatcherAssert.assertThat((Object)this.submoduleOption.getThreads(), (Matcher)Matchers.is((Object)threads));
    }

    @Test
    public void testToString() {
        MatcherAssert.assertThat((Object)this.submoduleOption.toString(), (Matcher)Matchers.is((Object)"SubmoduleOption{disableSubmodules=false, recursiveSubmodules=false, trackingSubmodules=false, reference='null', parentCredentials=false, timeout=null, shallow=false, depth=null, threads=null}"));
    }

    @Test
    public void testToStringDataBoundConstructor() {
        this.submoduleOption = new SubmoduleOption();
        MatcherAssert.assertThat((Object)this.submoduleOption.toString(), (Matcher)Matchers.is((Object)"SubmoduleOption{disableSubmodules=false, recursiveSubmodules=false, trackingSubmodules=false, reference='null', parentCredentials=false, timeout=null, shallow=false, depth=null, threads=null}"));
    }

    @Test
    public void testDetermineSupportForJGit() {
        GitSCM scm = new GitSCM("https://github.com/jenkinsci/git-plugin");
        scm.getExtensions().add((Object)this.submoduleOption);
        UnsupportedCommand cmd = new UnsupportedCommand();
        this.submoduleOption.determineSupportForJGit(scm, cmd);
        MatcherAssert.assertThat((Object)cmd.determineSupportForJGit(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testDetermineSupportForJGitRecursiveSubmodules() {
        GitSCM scm = new GitSCM("https://github.com/jenkinsci/git-plugin");
        this.submoduleOption = new SubmoduleOption(false, true, false, SUBMODULES_REFERENCE_REPOSITORY, SUBMODULES_TIMEOUT, false);
        scm.getExtensions().add((Object)this.submoduleOption);
        UnsupportedCommand cmd = new UnsupportedCommand();
        this.submoduleOption.determineSupportForJGit(scm, cmd);
        MatcherAssert.assertThat((Object)cmd.determineSupportForJGit(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testDetermineSupportForJGitThreads() {
        GitSCM scm = new GitSCM("https://github.com/jenkinsci/git-plugin");
        Integer threads = this.randomSmallNonNegativeIntegerOrNull();
        this.submoduleOption.setThreads(threads);
        scm.getExtensions().add((Object)this.submoduleOption);
        UnsupportedCommand cmd = new UnsupportedCommand();
        this.submoduleOption.determineSupportForJGit(scm, cmd);
        MatcherAssert.assertThat((Object)cmd.determineSupportForJGit(), (Matcher)Matchers.is((Object)false));
    }
}

