/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.impl.CheckoutOption;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.jenkinsci.plugins.gitclient.CheckoutCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CheckoutOptionTest {
    private CheckoutOption option;
    private static final int INITIAL_TIMEOUT = 10;

    @Before
    public void setUp() {
        this.option = new CheckoutOption(Integer.valueOf(10));
    }

    @Test
    public void testGetTimeout() {
        Assert.assertEquals((long)10L, (long)this.option.getTimeout().intValue());
    }

    @Test
    public void testRequiresWorkspaceForPolling() {
        Assert.assertFalse((boolean)this.option.requiresWorkspaceForPolling());
    }

    @Test
    public void testDecorateCheckoutCommand() throws Exception {
        int NEW_TIMEOUT = 13;
        CheckoutCommandImpl cmd = new CheckoutCommandImpl();
        Assert.assertEquals((long)10L, (long)cmd.getTimeout());
        GitSCM scm = null;
        Run build = null;
        TaskListener listener = null;
        GitClient git = null;
        this.option = new CheckoutOption(Integer.valueOf(13));
        this.option.decorateCheckoutCommand(scm, build, git, listener, (CheckoutCommand)cmd);
        Assert.assertEquals((long)13L, (long)cmd.getTimeout());
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(CheckoutOption.class).usingGetClass().suppress(new Warning[]{Warning.NONFINAL_FIELDS}).verify();
    }

    @Test
    public void checkToString() {
        Assert.assertEquals((Object)"CheckoutOption{timeout=10}", (Object)this.option.toString());
    }

    public class CheckoutCommandImpl
    implements CheckoutCommand {
        private int timeout = 10;

        public int getTimeout() {
            return this.timeout;
        }

        public CheckoutCommand timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public CheckoutCommand ref(String ref) {
            throw new UnsupportedOperationException("Don't call me");
        }

        public CheckoutCommand branch(String branch) {
            throw new UnsupportedOperationException("Don't call me");
        }

        public CheckoutCommand deleteBranchIfExist(boolean deleteBranch) {
            throw new UnsupportedOperationException("Don't call me");
        }

        public CheckoutCommand sparseCheckoutPaths(List<String> sparseCheckoutPaths) {
            throw new UnsupportedOperationException("Don't call me");
        }

        public CheckoutCommand lfsRemote(String lfsRemote) {
            throw new UnsupportedOperationException("Don't call me");
        }

        public CheckoutCommand lfsCredentials(StandardCredentials lfsCredentials) {
            throw new UnsupportedOperationException("Don't call me");
        }

        public void execute() throws GitException, InterruptedException {
            throw new UnsupportedOperationException("Don't call me");
        }
    }
}

