/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions;

import hudson.model.Cause;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.TestGitRepo;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.scm.SCM;
import hudson.util.StreamTaskListener;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.util.SystemReader;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.CaptureEnvironmentBuilder;
import org.jvnet.hudson.test.JenkinsRule;

public abstract class GitSCMExtensionTest {
    protected TaskListener listener;
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        SystemReader.getInstance().getUserConfig().clear();
        this.listener = StreamTaskListener.fromStderr();
        this.before();
    }

    @Before
    public void allowNonRemoteCheckout() {
        GitSCM.ALLOW_LOCAL_CHECKOUT = true;
    }

    @After
    public void disallowNonRemoteCheckout() {
        GitSCM.ALLOW_LOCAL_CHECKOUT = false;
    }

    protected abstract void before() throws Exception;

    protected abstract GitSCMExtension getExtension();

    protected FreeStyleBuild build(FreeStyleProject project, Result expectedResult) throws Exception {
        FreeStyleBuild build = (FreeStyleBuild)project.scheduleBuild2(0, (Cause)new Cause.UserIdCause()).get();
        if (expectedResult != null) {
            this.r.assertBuildStatus(expectedResult, (Run)build);
        }
        return build;
    }

    protected FreeStyleProject setupBasicProject(TestGitRepo repo) throws Exception {
        GitSCMExtension extension = this.getExtension();
        FreeStyleProject project = this.r.createFreeStyleProject("p");
        List<BranchSpec> branches = Collections.singletonList(new BranchSpec("master"));
        GitSCM scm = new GitSCM(repo.remoteConfigs(), branches, null, null, Collections.emptyList());
        scm.getExtensions().add((Object)extension);
        project.setScm((SCM)scm);
        project.getBuildersList().add((Object)new CaptureEnvironmentBuilder());
        return project;
    }
}

