/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.EnvVars;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.KilnGit;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;
import org.junit.Test;

public class KilnGitTest {
    private static final String KILN_URL = "http://USER.kilnhg.com/Code/PROJECT/Group/REPO";
    private final KilnGit kilnGit = new KilnGit("http://USER.kilnhg.com/Code/PROJECT/Group/REPO");
    private final Random random = new Random();

    @Test
    public void testGetUrl() throws IOException {
        Assert.assertEquals((Object)String.valueOf(this.kilnGit.getUrl()), (Object)"http://USER.kilnhg.com/Code/PROJECT/Group/REPO/");
    }

    @Test
    public void testGetUrlForRepoWithTrailingSlash() throws IOException {
        Assert.assertEquals((Object)String.valueOf(new KilnGit("http://USER.kilnhg.com/Code/PROJECT/Group/REPO/").getUrl()), (Object)"http://USER.kilnhg.com/Code/PROJECT/Group/REPO/");
    }

    @Test
    public void testGetChangeSetLinkGitChangeSet() throws Exception {
        URL changeSetLink = this.kilnGit.getChangeSetLink(this.createChangeSet("rawchangelog"));
        Assert.assertEquals((Object)"http://USER.kilnhg.com/Code/PROJECT/Group/REPO/History/396fc230a3db05c427737aa5c2eb7856ba72b05d", (Object)changeSetLink.toString());
    }

    @Test
    public void testGetDiffLinkPath() throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog");
        GitChangeSet.Path path1 = pathMap.get("src/main/java/hudson/plugins/git/browser/GithubWeb.java");
        Assert.assertEquals((Object)"http://USER.kilnhg.com/Code/PROJECT/Group/REPO/History/396fc230a3db05c427737aa5c2eb7856ba72b05d#diff-1", (Object)this.kilnGit.getDiffLink(path1).toString());
        GitChangeSet.Path path2 = pathMap.get("src/test/java/hudson/plugins/git/browser/GithubWebTest.java");
        Assert.assertEquals((Object)"http://USER.kilnhg.com/Code/PROJECT/Group/REPO/History/396fc230a3db05c427737aa5c2eb7856ba72b05d#diff-2", (Object)this.kilnGit.getDiffLink(path2).toString());
        GitChangeSet.Path path3 = pathMap.get("src/test/resources/hudson/plugins/git/browser/rawchangelog-with-deleted-file");
        Assert.assertNull((String)"Do not return a diff link for added files.", (Object)this.kilnGit.getDiffLink(path3));
    }

    @Test
    public void testGetFileLinkPath() throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog");
        GitChangeSet.Path path = pathMap.get("src/main/java/hudson/plugins/git/browser/GithubWeb.java");
        URL fileLink = this.kilnGit.getFileLink(path);
        Assert.assertEquals((Object)"http://USER.kilnhg.com/Code/PROJECT/Group/REPO/FileHistory/src/main/java/hudson/plugins/git/browser/GithubWeb.java?rev=396fc230a3db05c427737aa5c2eb7856ba72b05d", (Object)String.valueOf(fileLink));
    }

    @Test
    public void testGetFileLinkPathForDeletedFile() throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog-with-deleted-file");
        GitChangeSet.Path path = pathMap.get("bar");
        URL fileLink = this.kilnGit.getFileLink(path);
        Assert.assertEquals((Object)"http://USER.kilnhg.com/Code/PROJECT/Group/REPO/History/fc029da233f161c65eb06d0f1ed4f36ae81d1f4f#diff-1", (Object)String.valueOf(fileLink));
    }

    private GitChangeSet createChangeSet(String rawchangelogpath) throws Exception {
        GitClient gitClient = Git.with((TaskListener)TaskListener.NULL, (EnvVars)new EnvVars()).in(new File(".")).using(this.random.nextBoolean() ? null : "jgit").getClient();
        GitChangeLogParser logParser = new GitChangeLogParser(gitClient, false);
        List changeSetList = logParser.parse(KilnGitTest.class.getResourceAsStream(rawchangelogpath));
        return (GitChangeSet)changeSetList.get(0);
    }

    private HashMap<String, GitChangeSet.Path> createPathMap(String changelog) throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = new HashMap<String, GitChangeSet.Path>();
        Collection changeSet = this.createChangeSet(changelog).getPaths();
        for (GitChangeSet.Path path : changeSet) {
            pathMap.put(path.getPath(), path);
        }
        return pathMap;
    }
}

