/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitChangeSetSample;
import hudson.plugins.git.browser.Gitiles;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GitilesTest {
    private final String repoUrl = "https://gwt.googlesource.com/gwt/";
    private final boolean useAuthorName;
    private final GitChangeSetSample sample;

    public GitilesTest(String useAuthorName) {
        this.useAuthorName = Boolean.valueOf(useAuthorName);
        this.sample = new GitChangeSetSample(this.useAuthorName);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection permuteAuthorName() {
        String[] allowed;
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (String authorName : allowed = new String[]{"true", "false"}) {
            Object[] combination = new Object[]{authorName};
            values.add(combination);
        }
        return values;
    }

    @Test
    public void testGetChangeSetLink() throws Exception {
        URL result = new Gitiles("https://gwt.googlesource.com/gwt/").getChangeSetLink(this.sample.changeSet);
        Assert.assertEquals((Object)new URL("https://gwt.googlesource.com/gwt/+/" + this.sample.id + "%5E%21"), (Object)result);
    }

    @Test
    public void testGetDiffLink() throws Exception {
        Gitiles gitiles = new Gitiles("https://gwt.googlesource.com/gwt/");
        for (GitChangeSet.Path path : this.sample.changeSet.getPaths()) {
            URL diffLink = gitiles.getDiffLink(path);
            URL expectedDiffLink = new URL("https://gwt.googlesource.com/gwt/+/" + this.sample.id + "%5E%21");
            String msg = "Wrong link for path: " + path.getPath() + ", edit type: " + path.getEditType().getName();
            Assert.assertEquals((String)msg, (Object)expectedDiffLink, (Object)diffLink);
        }
    }

    @Test
    public void testGetFileLink() throws Exception {
        Gitiles gitiles = new Gitiles("https://gwt.googlesource.com/gwt/");
        for (GitChangeSet.Path path : this.sample.changeSet.getPaths()) {
            URL fileLink = gitiles.getFileLink(path);
            URL expectedFileLink = new URL("https://gwt.googlesource.com/gwt/+blame/" + this.sample.id + "/" + path.getPath());
            String msg = "Wrong link for path: " + path.getPath() + ", edit type: " + path.getEditType().getName();
            Assert.assertEquals((String)msg, (Object)expectedFileLink, (Object)fileLink);
        }
    }
}

