/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.model.Job;
import hudson.model.Run;
import jenkins.plugins.git.GitSampleRepoRule;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class GitLabWorkflowTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();

    @Test
    public void checkoutWithVersion() throws Exception {
        this.sampleRepo.init();
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  checkout(\n    [$class: 'GitSCM', browser: [$class: 'GitLab',\n     repoUrl: 'https://a.org/a/b', version: '9.0'],\n    userRemoteConfigs: [[url: $/" + this.sampleRepo + "/$]]]\n  )\n  def tokenBranch = tm '${GIT_BRANCH,fullName=false}'\n  echo \"token macro expanded branch is ${tokenBranch}\"\n}", true));
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        this.r.waitForMessage("token macro expanded branch is remotes/origin/master", (Run)b);
    }

    @Test
    public void checkoutWithoutVersion() throws Exception {
        this.sampleRepo.init();
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  checkout(\n    [$class: 'GitSCM', browser: [$class: 'GitLab',\n     repoUrl: 'https://a.org/a/b'],\n    userRemoteConfigs: [[url: $/" + this.sampleRepo + "/$]]]\n  )\n  def tokenBranch = tm '${GIT_BRANCH,fullName=false}'\n  echo \"token macro expanded branch is ${tokenBranch}\"\n}", true));
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        this.r.waitForMessage("token macro expanded branch is remotes/origin/master", (Run)b);
    }
}

