/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.git.GitSCM;
import java.io.File;
import java.util.concurrent.Future;
import jenkins.plugins.git.GitSampleRepoRule;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class Security2478Test {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();

    @Before
    public void setUpAllowNonRemoteCheckout() {
        GitSCM.ALLOW_LOCAL_CHECKOUT = false;
    }

    @After
    public void disallowNonRemoteCheckout() {
        GitSCM.ALLOW_LOCAL_CHECKOUT = false;
    }

    @Test
    public void checkoutShouldNotAbortWhenLocalSourceAndRunningOnAgent() throws Exception {
        Assert.assertFalse((String)"Non Remote checkout should be disallowed", (boolean)GitSCM.ALLOW_LOCAL_CHECKOUT);
        this.r.createOnlineSlave();
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=test commit");
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "pipeline");
        String script = "node {\n   checkout([$class: 'GitSCM', branches: [[name: '*/master']], extensions: [], userRemoteConfigs: [[url: '" + this.sampleRepo.fileUrl() + "', credentialsId: '']]])\n}";
        p.setDefinition((FlowDefinition)new CpsFlowDefinition(script, true));
        WorkflowRun run = (WorkflowRun)this.r.assertBuildStatus(Result.SUCCESS, (Future)p.scheduleBuild2(0, new Action[0]));
        this.r.assertLogNotContains("aborted because it references a local directory, which may be insecure. You can allow local checkouts anyway by setting the system property 'hudson.plugins.git.GitSCM.ALLOW_LOCAL_CHECKOUT' to true.", (Run)run);
    }

    @Test
    public void checkoutShouldAbortWhenSourceIsNonRemoteAndRunningOnController() throws Exception {
        Assert.assertFalse((String)"Non Remote checkout should be disallowed", (boolean)GitSCM.ALLOW_LOCAL_CHECKOUT);
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "pipeline");
        String workspaceDir = this.r.jenkins.getRootDir().getAbsolutePath();
        String path = "file://" + workspaceDir + File.separator + "jobName@script" + File.separator + "anyhmachash";
        String escapedPath = path.replace("\\", "\\\\");
        String script = "node {\n   checkout([$class: 'GitSCM', branches: [[name: '*/main']], extensions: [], userRemoteConfigs: [[url: '" + escapedPath + "', credentialsId: '']]])\n}";
        p.setDefinition((FlowDefinition)new CpsFlowDefinition(script, true));
        WorkflowRun run = (WorkflowRun)this.r.assertBuildStatus(Result.FAILURE, (Future)p.scheduleBuild2(0, new Action[0]));
        this.r.assertLogContains("Checkout of Git remote '" + path + "' aborted because it references a local directory, which may be insecure. You can allow local checkouts anyway by setting the system property 'hudson.plugins.git.GitSCM.ALLOW_LOCAL_CHECKOUT' to true.", (Run)run);
    }
}

