/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.TaskListener;
import hudson.plugins.git.AbstractGitProject;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.extensions.impl.EnforceGitClient;
import hudson.scm.PollingResult;
import hudson.triggers.SCMTrigger;
import hudson.util.RunList;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jenkins.plugins.git.RandomOrder;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Stopwatch;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.OrderWith;

@OrderWith(value=RandomOrder.class)
public abstract class SCMTriggerTest
extends AbstractGitProject {
    private ZipFile namespaceRepoZip;
    private Properties namespaceRepoCommits;
    private ExecutorService singleThreadExecutor;
    protected boolean expectChanges = false;
    @ClassRule
    public static Stopwatch stopwatch = new Stopwatch();
    private static final int MAX_SECONDS_FOR_THESE_TESTS = 120;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    private boolean isTimeAvailable() {
        String env = System.getenv("CI");
        if (env == null || !Boolean.parseBoolean(env)) {
            return true;
        }
        return stopwatch.runtime(TimeUnit.SECONDS) <= 120L;
    }

    @Before
    public void setUp() throws Exception {
        this.expectChanges = false;
        this.namespaceRepoZip = new ZipFile("src/test/resources/namespaceBranchRepo.zip");
        this.namespaceRepoCommits = this.parseLsRemote(new File("src/test/resources/namespaceBranchRepo.ls-remote"));
        this.singleThreadExecutor = Executors.newSingleThreadExecutor();
    }

    protected abstract EnforceGitClient getGitClient();

    protected abstract boolean isDisableRemotePoll();

    @Test
    public void testNamespaces_with_refsHeadsMaster() throws Exception {
        if (this.isWindows()) {
            return;
        }
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "refs/heads/master", this.namespaceRepoCommits.getProperty("refs/heads/master"), "origin/master");
    }

    @Test
    public void testNamespaces_with_remotesOriginMaster() throws Exception {
        if (this.isWindows()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 120 exceeded", (boolean)this.isTimeAvailable());
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "remotes/origin/master", this.namespaceRepoCommits.getProperty("refs/heads/master"), "origin/master");
    }

    @Test
    public void testNamespaces_with_refsRemotesOriginMaster() throws Exception {
        if (this.isWindows()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 120 exceeded", (boolean)this.isTimeAvailable());
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "refs/remotes/origin/master", this.namespaceRepoCommits.getProperty("refs/heads/master"), "origin/master");
    }

    @Test
    public void testNamespaces_with_master() throws Exception {
        if (this.isWindows()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 120 exceeded", (boolean)this.isTimeAvailable());
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "master", this.namespaceRepoCommits.getProperty("refs/heads/master"), "origin/master");
    }

    @Test
    public void testNamespaces_with_namespace1Master() throws Exception {
        if (this.isWindows()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 120 exceeded", (boolean)this.isTimeAvailable());
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "a_tests/b_namespace1/master", this.namespaceRepoCommits.getProperty("refs/heads/a_tests/b_namespace1/master"), "origin/a_tests/b_namespace1/master");
    }

    @Test
    public void testNamespaces_with_refsHeadsNamespace1Master() throws Exception {
        if (this.isWindows()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 120 exceeded", (boolean)this.isTimeAvailable());
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "refs/heads/a_tests/b_namespace1/master", this.namespaceRepoCommits.getProperty("refs/heads/a_tests/b_namespace1/master"), "origin/a_tests/b_namespace1/master");
    }

    @Test
    public void testNamespaces_with_namespace2Master() throws Exception {
        if (this.isWindows()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 120 exceeded", (boolean)this.isTimeAvailable());
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "a_tests/b_namespace2/master", this.namespaceRepoCommits.getProperty("refs/heads/a_tests/b_namespace2/master"), "origin/a_tests/b_namespace2/master");
    }

    @Test
    public void testNamespaces_with_refsHeadsNamespace2Master() throws Exception {
        if (this.isWindows()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 120 exceeded", (boolean)this.isTimeAvailable());
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "refs/heads/a_tests/b_namespace2/master", this.namespaceRepoCommits.getProperty("refs/heads/a_tests/b_namespace2/master"), "origin/a_tests/b_namespace2/master");
    }

    @Test
    public void testNamespaces_with_namespace3_feature3_sha1() throws Exception {
        if (this.isWindows()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 120 exceeded", (boolean)this.isTimeAvailable());
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, this.namespaceRepoCommits.getProperty("refs/heads/a_tests/b_namespace3/feature3"), this.namespaceRepoCommits.getProperty("refs/heads/a_tests/b_namespace3/feature3"), "detached");
    }

    @Test
    public void testNamespaces_with_namespace3_feature3_branchName() throws Exception {
        if (this.isWindows()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 120 exceeded", (boolean)this.isTimeAvailable());
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "a_tests/b_namespace3/feature3", this.namespaceRepoCommits.getProperty("refs/heads/a_tests/b_namespace3/feature3"), "origin/a_tests/b_namespace3/feature3");
    }

    @Test
    public void testNamespaces_with_refsHeadsNamespace3_feature3_sha1() throws Exception {
        if (this.isWindows()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 120 exceeded", (boolean)this.isTimeAvailable());
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, this.namespaceRepoCommits.getProperty("refs/heads/a_tests/b_namespace3/feature3"), this.namespaceRepoCommits.getProperty("refs/heads/a_tests/b_namespace3/feature3"), "detached");
    }

    @Test
    public void testNamespaces_with_refsHeadsNamespace3_feature3_branchName() throws Exception {
        if (this.isWindows()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 120 exceeded", (boolean)this.isTimeAvailable());
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "refs/heads/a_tests/b_namespace3/feature3", this.namespaceRepoCommits.getProperty("refs/heads/a_tests/b_namespace3/feature3"), "origin/a_tests/b_namespace3/feature3");
    }

    @Test
    public void testTags_with_TagA() throws Exception {
        if (this.isWindows()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 120 exceeded", (boolean)this.isTimeAvailable());
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "TagA", this.namespaceRepoCommits.getProperty("refs/tags/TagA"), "TagA");
    }

    @Test
    public void testTags_with_TagBAnnotated() throws Exception {
        if (this.isWindows()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 120 exceeded", (boolean)this.isTimeAvailable());
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "TagBAnnotated", this.namespaceRepoCommits.getProperty("refs/tags/TagBAnnotated^{}"), "TagBAnnotated");
    }

    @Test
    public void testTags_with_refsTagsTagA() throws Exception {
        if (this.isWindows()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 120 exceeded", (boolean)this.isTimeAvailable());
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "refs/tags/TagA", this.namespaceRepoCommits.getProperty("refs/tags/TagA"), "refs/tags/TagA");
    }

    @Test
    public void testTags_with_refsTagsTagBAnnotated() throws Exception {
        if (this.isWindows()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 120 exceeded", (boolean)this.isTimeAvailable());
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "refs/tags/TagBAnnotated", this.namespaceRepoCommits.getProperty("refs/tags/TagBAnnotated^{}"), "refs/tags/TagBAnnotated");
    }

    @Test
    public void testCommitAsBranchSpec_feature4_sha1() throws Exception {
        if (this.isWindows()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 120 exceeded", (boolean)this.isTimeAvailable());
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, this.namespaceRepoCommits.getProperty("refs/heads/b_namespace3/feature4"), this.namespaceRepoCommits.getProperty("refs/heads/b_namespace3/feature4"), "detached");
    }

    @Test
    public void testCommitAsBranchSpec_feature4_branchName() throws Exception {
        if (this.isWindows()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 120 exceeded", (boolean)this.isTimeAvailable());
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, "refs/heads/b_namespace3/feature4", this.namespaceRepoCommits.getProperty("refs/heads/b_namespace3/feature4"), "origin/b_namespace3/feature4");
    }

    @Test
    public void testCommitAsBranchSpec() throws Exception {
        if (this.isWindows()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 120 exceeded", (boolean)this.isTimeAvailable());
        this.check(this.namespaceRepoZip, this.namespaceRepoCommits, this.namespaceRepoCommits.getProperty("refs/heads/b_namespace3/master"), this.namespaceRepoCommits.getProperty("refs/heads/b_namespace3/master"), "detached");
    }

    public void check(ZipFile repoZip, Properties commits, String branchSpec, String expected_GIT_COMMIT, String expected_GIT_BRANCH) throws Exception {
        String remote = this.prepareRepo(repoZip);
        FreeStyleProject project = this.setupProject(Collections.singletonList(new UserRemoteConfig(remote, null, null, null)), Collections.singletonList(new BranchSpec(branchSpec)), "", this.isDisableRemotePoll(), this.getGitClient());
        this.triggerSCMTrigger((SCMTrigger)project.getTrigger(SCMTrigger.class));
        FreeStyleBuild build1 = this.waitForBuildFinished(project, 1, 60000L);
        Assert.assertNotNull((String)"Job has not been triggered", (Object)build1);
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        PollingResult poll = project.poll((TaskListener)listener);
        Assert.assertFalse((String)"Expected and actual polling results disagree", (boolean)poll.hasChanges());
        this.triggerSCMTrigger((SCMTrigger)project.getTrigger(SCMTrigger.class)).get(20L, TimeUnit.SECONDS);
        FreeStyleBuild build2 = this.waitForBuildFinished(project, 2, 2000L);
        Assert.assertNull((String)"Found build 2 although no new changes and no multi candidate build", (Object)build2);
        Assert.assertEquals((String)"Unexpected GIT_COMMIT", (Object)expected_GIT_COMMIT, (Object)build1.getEnvironment(null).get((Object)"GIT_COMMIT"));
        Assert.assertEquals((String)"Unexpected GIT_BRANCH", (Object)expected_GIT_BRANCH, (Object)build1.getEnvironment(null).get((Object)"GIT_BRANCH"));
    }

    private String prepareRepo(ZipFile repoZip) throws IOException {
        File tempRemoteDir = this.tempFolder.newFolder();
        this.extract(repoZip, tempRemoteDir);
        return tempRemoteDir.getAbsolutePath();
    }

    private Future<Void> triggerSCMTrigger(SCMTrigger trigger) {
        if (trigger == null) {
            return null;
        }
        Callable<Void> callable = () -> {
            trigger.run();
            return null;
        };
        return this.singleThreadExecutor.submit(callable);
    }

    private FreeStyleBuild waitForBuildFinished(FreeStyleProject project, int expectedBuildNumber, long timeout) throws Exception {
        long endTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < endTime) {
            RunList builds = project.getBuilds();
            for (FreeStyleBuild build : builds) {
                if (build.getNumber() != expectedBuildNumber) continue;
                if (build.getResult() == null) break;
                return build;
            }
            Thread.sleep(10L);
        }
        return null;
    }

    private Properties parseLsRemote(File file) throws IOException {
        Properties properties = new Properties();
        Pattern pattern = Pattern.compile("([a-f0-9]{40})\\s*(.*)");
        for (String lineO : Files.readAllLines(file.toPath(), StandardCharsets.UTF_8)) {
            String line = lineO.trim();
            Matcher matcher = pattern.matcher(line);
            if (matcher.matches()) {
                properties.setProperty(matcher.group(2), matcher.group(1));
                continue;
            }
            System.err.println("ls-remote pattern does not match '" + line + "'");
        }
        return properties;
    }

    private void extract(ZipFile zipFile, File outputDir) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File entryDestination = new File(outputDir, entry.getName());
            entryDestination.getParentFile().mkdirs();
            if (entry.isDirectory()) {
                entryDestination.mkdirs();
                continue;
            }
            InputStream in = zipFile.getInputStream(entry);
            try {
                Files.copy(in, entryDestination.toPath(), new CopyOption[0]);
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }
}

