/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.FreeStyleProject;
import hudson.model.View;
import hudson.plugins.git.AbstractGitProject;
import hudson.plugins.git.ApiTokenPropertyConfiguration;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitStatus;
import hudson.plugins.git.UserRemoteConfig;
import hudson.scm.SCM;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import hudson.util.RunList;
import java.io.File;
import java.util.Collections;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.FromDataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=Theories.class)
public class GitStatusTheoriesTest
extends AbstractGitProject {
    private GitStatus gitStatus;
    private HttpServletRequest requestWithNoParameter;
    private HttpServletRequest requestWithParameter;
    private String repoURL;
    private String branch;
    private String sha1;
    private String notifyCommitApiToken;
    @DataPoints(value={"branchSpecPrefixes"})
    public static final String[] BRANCH_SPEC_PREFIXES = new String[]{"", "refs/remotes/", "refs/heads/", "origin/", "remotes/origin/"};

    @Before
    public void setUp() throws Exception {
        GitStatus.setAllowNotifyCommitParameters((boolean)false);
        GitStatus.setSafeParametersForTest(null);
        this.gitStatus = new GitStatus();
        this.requestWithNoParameter = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.requestWithParameter = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.repoURL = new File(".").getAbsolutePath();
        this.branch = "**";
        this.sha1 = "7bb68ef21dc90bd4f7b08eca876203b2e049198d";
        if (this.r.jenkins != null) {
            this.notifyCommitApiToken = ApiTokenPropertyConfiguration.get().generateApiToken("test").getString("value");
        }
    }

    @After
    public void resetAllowNotifyCommitParameters() throws Exception {
        GitStatus.setAllowNotifyCommitParameters((boolean)false);
        GitStatus.setSafeParametersForTest(null);
    }

    @After
    public void waitForAllJobsToComplete() throws Exception {
        if (this.r != null && this.r.jenkins != null) {
            this.r.jenkins.doQuietDown();
        }
        Random random = new Random();
        Thread.sleep(500L + (long)random.nextInt(400));
        if (!this.isWindows() || this.r == null || this.r.jenkins == null) {
            return;
        }
        View allView = this.r.jenkins.getView("All");
        if (allView == null) {
            return;
        }
        RunList runList = allView.getBuilds();
        if (runList == null) {
            return;
        }
        runList.forEach(run -> {
            try {
                Logger.getLogger(GitStatusTheoriesTest.class.getName()).log(Level.INFO, "Waiting for {0}", run);
                this.r.waitForCompletion(run);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(GitStatusTheoriesTest.class.getName()).log(Level.SEVERE, "Interrupted waiting for GitStatusTheoriesTest job", ex);
            }
        });
    }

    @Theory
    public void testDoNotifyCommitBranchWithSlash(@FromDataPoints(value="branchSpecPrefixes") String branchSpecPrefix) throws Exception {
        SCMTrigger trigger = this.setupProjectWithTrigger("remote", branchSpecPrefix + "feature/awesome-feature", false);
        this.gitStatus.doNotifyCommit(this.requestWithNoParameter, "remote", "feature/awesome-feature", null, this.notifyCommitApiToken);
        ((SCMTrigger)Mockito.verify((Object)trigger)).run();
    }

    @Theory
    public void testDoNotifyCommitBranchWithoutSlash(@FromDataPoints(value="branchSpecPrefixes") String branchSpecPrefix) throws Exception {
        SCMTrigger trigger = this.setupProjectWithTrigger("remote", branchSpecPrefix + "awesome-feature", false);
        this.gitStatus.doNotifyCommit(this.requestWithNoParameter, "remote", "awesome-feature", null, this.notifyCommitApiToken);
        ((SCMTrigger)Mockito.verify((Object)trigger)).run();
    }

    @Theory
    public void testDoNotifyCommitBranchByBranchRef(@FromDataPoints(value="branchSpecPrefixes") String branchSpecPrefix) throws Exception {
        SCMTrigger trigger = this.setupProjectWithTrigger("remote", branchSpecPrefix + "awesome-feature", false);
        this.gitStatus.doNotifyCommit(this.requestWithNoParameter, "remote", "refs/heads/awesome-feature", null, this.notifyCommitApiToken);
        ((SCMTrigger)Mockito.verify((Object)trigger)).run();
    }

    private SCMTrigger setupProjectWithTrigger(String url, String branchString, boolean ignoreNotifyCommit) throws Exception {
        SCMTrigger trigger = (SCMTrigger)Mockito.mock(SCMTrigger.class);
        ((SCMTrigger)Mockito.doReturn((Object)ignoreNotifyCommit).when((Object)trigger)).isIgnorePostCommitHooks();
        this.setupProject(url, branchString, trigger);
        return trigger;
    }

    private void setupProject(String url, String branchString, SCMTrigger trigger) throws Exception {
        FreeStyleProject project = this.r.createFreeStyleProject();
        GitSCM git = new GitSCM(Collections.singletonList(new UserRemoteConfig(url, null, null, null)), Collections.singletonList(new BranchSpec(branchString)), null, null, Collections.emptyList());
        project.setScm((SCM)git);
        if (trigger != null) {
            project.addTrigger((Trigger)trigger);
        }
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }
}

