/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.plugins.git.ApiTokenPropertyConfiguration;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class GitStatusCrumbExclusionTest {
    @ClassRule
    public static JenkinsRule r = new JenkinsRule();
    private static final String GIT_REPO_URL = "https://github.com/jenkinsci/git-client-plugin";
    private final URL notifyCommitURL;
    private final URL manageURL;
    private final URL invalidURL;
    private final String urlArgument;
    private final byte[] urlArgumentBytes;
    private final String separator;
    private final byte[] separatorBytes;
    private final String branchArgument;
    private final byte[] branchArgumentBytes;
    private final String notifyCommitApiToken;
    private final byte[] notifyCommitApiTokenBytes;
    private HttpURLConnection connectionPOST;

    public GitStatusCrumbExclusionTest() throws Exception {
        Object jenkinsUrl = r.getURL().toExternalForm();
        if (!((String)jenkinsUrl).endsWith("/")) {
            jenkinsUrl = (String)jenkinsUrl + "/";
        }
        this.notifyCommitURL = new URL((String)jenkinsUrl + "git/notifyCommit");
        this.manageURL = new URL((String)jenkinsUrl + "manage");
        this.invalidURL = new URL((String)jenkinsUrl + "jobs/no-such-job");
        this.urlArgument = "url=https://github.com/jenkinsci/git-client-plugin";
        this.urlArgumentBytes = this.urlArgument.getBytes(StandardCharsets.UTF_8);
        this.separator = "&";
        this.separatorBytes = this.separator.getBytes(StandardCharsets.UTF_8);
        this.branchArgument = "branches=origin/some-branch-name";
        this.branchArgumentBytes = this.branchArgument.getBytes(StandardCharsets.UTF_8);
        this.notifyCommitApiToken = "token=" + ApiTokenPropertyConfiguration.get().generateApiToken("test").getString("value");
        this.notifyCommitApiTokenBytes = this.notifyCommitApiToken.getBytes(StandardCharsets.UTF_8);
    }

    @Before
    public void connectWithPOST() throws IOException {
        URL postURL = this.notifyCommitURL;
        this.connectionPOST = (HttpURLConnection)postURL.openConnection();
        this.connectionPOST.setRequestMethod("POST");
        this.connectionPOST.setDoOutput(true);
    }

    @After
    public void disconnectFromPOST() {
        this.connectionPOST.disconnect();
    }

    @Test
    public void testPOSTValidPathNoArgument() throws Exception {
        MatcherAssert.assertThat((Object)this.connectionPOST.getResponseCode(), (Matcher)Matchers.is((Object)500));
        MatcherAssert.assertThat((Object)this.connectionPOST.getResponseMessage(), (Matcher)Matchers.is((Object)"Server Error"));
    }

    @Test
    public void testPOSTValidPathMandatoryArgument() throws Exception {
        try (OutputStream os = this.connectionPOST.getOutputStream();){
            os.write(this.urlArgumentBytes);
            os.write(this.separatorBytes);
            os.write(this.notifyCommitApiTokenBytes);
        }
        MatcherAssert.assertThat((Object)this.connectionPOST.getResponseCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)this.connectionPOST.getResponseMessage(), (Matcher)Matchers.is((Object)"OK"));
    }

    @Test
    public void testPOSTValidPathEmptyMandatoryArgument() throws Exception {
        try (OutputStream os = this.connectionPOST.getOutputStream();){
            String urlEmptyArgument = "url=";
            byte[] urlEmptyArgumentBytes = urlEmptyArgument.getBytes(StandardCharsets.UTF_8);
            os.write(urlEmptyArgumentBytes);
            os.write(this.separatorBytes);
            os.write(this.notifyCommitApiTokenBytes);
        }
        MatcherAssert.assertThat((Object)this.connectionPOST.getResponseCode(), (Matcher)Matchers.is((Object)400));
        MatcherAssert.assertThat((Object)this.connectionPOST.getResponseMessage(), (Matcher)Matchers.is((Object)"Bad Request"));
    }

    @Test
    public void testPOSTValidPathBadURLInMandatoryArgument() throws Exception {
        try (OutputStream os = this.connectionPOST.getOutputStream();){
            String urlBadArgument = "url=http://256.256.256.256/";
            byte[] urlBadArgumentBytes = urlBadArgument.getBytes(StandardCharsets.UTF_8);
            os.write(urlBadArgumentBytes);
            os.write(this.separatorBytes);
            os.write(this.notifyCommitApiTokenBytes);
        }
        MatcherAssert.assertThat((Object)this.connectionPOST.getResponseCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)this.connectionPOST.getResponseMessage(), (Matcher)Matchers.is((Object)"OK"));
    }

    @Test
    public void testPOSTValidPathMandatoryAndOptionalArgument() throws Exception {
        try (OutputStream os = this.connectionPOST.getOutputStream();){
            os.write(this.urlArgumentBytes);
            os.write(this.separatorBytes);
            os.write(this.branchArgumentBytes);
            os.write(this.separatorBytes);
            os.write(this.notifyCommitApiTokenBytes);
        }
        MatcherAssert.assertThat((Object)this.connectionPOST.getResponseCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)this.connectionPOST.getResponseMessage(), (Matcher)Matchers.is((Object)"OK"));
    }

    @Test
    public void testPOSTValidPathOnlyOptionalArgument() throws Exception {
        try (OutputStream os = this.connectionPOST.getOutputStream();){
            os.write(this.branchArgumentBytes);
        }
        MatcherAssert.assertThat((Object)this.connectionPOST.getResponseCode(), (Matcher)Matchers.is((Object)500));
        MatcherAssert.assertThat((Object)this.connectionPOST.getResponseMessage(), (Matcher)Matchers.is((Object)"Server Error"));
    }

    @Test
    public void testPOSTInvalidPathNoArgument() throws Exception {
        URL invalidPathURL = this.invalidURL;
        HttpURLConnection invalidPathConnection = (HttpURLConnection)invalidPathURL.openConnection();
        invalidPathConnection.setRequestMethod("POST");
        invalidPathConnection.setDoOutput(true);
        MatcherAssert.assertThat((Object)invalidPathConnection.getResponseCode(), (Matcher)Matchers.is((Object)403));
        MatcherAssert.assertThat((Object)invalidPathConnection.getResponseMessage(), (Matcher)Matchers.is((Object)"Forbidden"));
        invalidPathConnection.disconnect();
    }

    @Test
    public void testPOSTInvalidPathMandatoryArgument() throws Exception {
        URL invalidPathURL = this.invalidURL;
        HttpURLConnection invalidPathConnection = (HttpURLConnection)invalidPathURL.openConnection();
        invalidPathConnection.setRequestMethod("POST");
        invalidPathConnection.setDoOutput(true);
        try (OutputStream os = invalidPathConnection.getOutputStream();){
            os.write(this.urlArgumentBytes);
        }
        MatcherAssert.assertThat((Object)invalidPathConnection.getResponseCode(), (Matcher)Matchers.is((Object)403));
        MatcherAssert.assertThat((Object)invalidPathConnection.getResponseMessage(), (Matcher)Matchers.is((Object)"Forbidden"));
        invalidPathConnection.disconnect();
    }

    @Test
    public void testPOSTInvalidPathMandatoryAndOptionalArgument() throws Exception {
        URL invalidPathURL = this.invalidURL;
        HttpURLConnection invalidPathConnection = (HttpURLConnection)invalidPathURL.openConnection();
        invalidPathConnection.setRequestMethod("POST");
        invalidPathConnection.setDoOutput(true);
        try (OutputStream os = invalidPathConnection.getOutputStream();){
            os.write(this.urlArgumentBytes);
            os.write(this.separatorBytes);
            os.write(this.branchArgumentBytes);
        }
        MatcherAssert.assertThat((Object)invalidPathConnection.getResponseCode(), (Matcher)Matchers.is((Object)403));
        MatcherAssert.assertThat((Object)invalidPathConnection.getResponseMessage(), (Matcher)Matchers.is((Object)"Forbidden"));
        invalidPathConnection.disconnect();
    }

    @Test
    public void testPOSTManageNoArgument() throws Exception {
        URL postURL = this.manageURL;
        HttpURLConnection manageConnection = (HttpURLConnection)postURL.openConnection();
        manageConnection.setRequestMethod("POST");
        manageConnection.setDoOutput(true);
        MatcherAssert.assertThat((Object)manageConnection.getResponseCode(), (Matcher)Matchers.is((Object)403));
        MatcherAssert.assertThat((Object)manageConnection.getResponseMessage(), (Matcher)Matchers.is((Object)"Forbidden"));
        manageConnection.disconnect();
    }

    @Test
    public void testPOSTManageMandatoryArgument() throws Exception {
        URL postURL = this.manageURL;
        HttpURLConnection manageConnection = (HttpURLConnection)postURL.openConnection();
        manageConnection.setRequestMethod("POST");
        manageConnection.setDoOutput(true);
        try (OutputStream os = manageConnection.getOutputStream();){
            os.write(this.urlArgumentBytes);
        }
        MatcherAssert.assertThat((Object)manageConnection.getResponseCode(), (Matcher)Matchers.is((Object)403));
        MatcherAssert.assertThat((Object)manageConnection.getResponseMessage(), (Matcher)Matchers.is((Object)"Forbidden"));
        manageConnection.disconnect();
    }

    @Test
    public void testPOSTManageMandatoryAndOptionalArgument() throws Exception {
        URL postURL = this.manageURL;
        HttpURLConnection manageConnection = (HttpURLConnection)postURL.openConnection();
        manageConnection.setRequestMethod("POST");
        manageConnection.setDoOutput(true);
        try (OutputStream os = manageConnection.getOutputStream();){
            os.write(this.urlArgumentBytes);
            os.write(this.separatorBytes);
            os.write(this.branchArgumentBytes);
        }
        MatcherAssert.assertThat((Object)manageConnection.getResponseCode(), (Matcher)Matchers.is((Object)403));
        MatcherAssert.assertThat((Object)manageConnection.getResponseMessage(), (Matcher)Matchers.is((Object)"Forbidden"));
        manageConnection.disconnect();
    }

    @Test
    public void testGETValidPathNoArgument() throws Exception {
        URL getURL = this.notifyCommitURL;
        HttpURLConnection connectionGET = (HttpURLConnection)getURL.openConnection();
        connectionGET.setRequestMethod("GET");
        connectionGET.connect();
        MatcherAssert.assertThat((Object)connectionGET.getResponseCode(), (Matcher)Matchers.is((Object)500));
        MatcherAssert.assertThat((Object)connectionGET.getResponseMessage(), (Matcher)Matchers.is((Object)"Server Error"));
        connectionGET.disconnect();
    }

    @Test
    public void testGETValidPathMandatoryArgument() throws Exception {
        URL getURL = new URL(this.notifyCommitURL + "?" + this.urlArgument + this.separator + this.notifyCommitApiToken);
        HttpURLConnection connectionGET = (HttpURLConnection)getURL.openConnection();
        connectionGET.setRequestMethod("GET");
        connectionGET.connect();
        MatcherAssert.assertThat((Object)connectionGET.getResponseCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)connectionGET.getResponseMessage(), (Matcher)Matchers.is((Object)"OK"));
        connectionGET.disconnect();
    }

    @Test
    public void testGETValidPathMandatoryAndOptionalArgument() throws Exception {
        URL getURL = new URL(this.notifyCommitURL + "?" + this.urlArgument + this.separator + this.branchArgument + this.separator + this.notifyCommitApiToken);
        HttpURLConnection connectionGET = (HttpURLConnection)getURL.openConnection();
        connectionGET.setRequestMethod("GET");
        connectionGET.connect();
        MatcherAssert.assertThat((Object)connectionGET.getResponseCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)connectionGET.getResponseMessage(), (Matcher)Matchers.is((Object)"OK"));
        connectionGET.disconnect();
    }

    @Test
    public void testGETInvalidPath() throws Exception {
        URL getURL = this.invalidURL;
        HttpURLConnection connectionGET = (HttpURLConnection)getURL.openConnection();
        connectionGET.setRequestMethod("GET");
        connectionGET.connect();
        MatcherAssert.assertThat((Object)connectionGET.getResponseCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)connectionGET.getResponseMessage(), (Matcher)Matchers.is((Object)"Not Found"));
        connectionGET.disconnect();
    }

    @Test
    public void testGETInvalidPathWithArgument() throws Exception {
        URL getURL = new URL(this.invalidURL + "?" + this.urlArgument);
        HttpURLConnection connectionGET = (HttpURLConnection)getURL.openConnection();
        connectionGET.setRequestMethod("GET");
        connectionGET.connect();
        MatcherAssert.assertThat((Object)connectionGET.getResponseCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)connectionGET.getResponseMessage(), (Matcher)Matchers.is((Object)"Not Found"));
        connectionGET.disconnect();
    }

    @Test
    public void testGETManagePath() throws Exception {
        URL getURL = this.manageURL;
        HttpURLConnection connectionGET = (HttpURLConnection)getURL.openConnection();
        connectionGET.setRequestMethod("GET");
        connectionGET.connect();
        MatcherAssert.assertThat((Object)connectionGET.getResponseCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)connectionGET.getResponseMessage(), (Matcher)Matchers.is((Object)"OK"));
        connectionGET.disconnect();
    }

    @Test
    public void testGETManagePathWithArgument() throws Exception {
        URL getURL = new URL(this.manageURL + "?" + this.urlArgument);
        HttpURLConnection connection = (HttpURLConnection)getURL.openConnection();
        connection.setRequestMethod("GET");
        connection.connect();
        MatcherAssert.assertThat((Object)connection.getResponseCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)connection.getResponseMessage(), (Matcher)Matchers.is((Object)"OK"));
        connection.disconnect();
    }
}

