/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeSet;
import hudson.scm.EditType;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.jgit.lib.ObjectId;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;

public class GitChangeSetUtil {
    static final String ID = "123abc456def";
    static final String PARENT = "345mno678pqr";
    static final String AUTHOR_NAME = "John Author";
    static final String AUTHOR_DATE = "1234568 -0600";
    static final String AUTHOR_DATE_FORMATTED = "1970-01-15T06:56:08-0600";
    static final String AUTHOR_EMAIL = "jauthor@nospam.com";
    static final String COMMITTER_NAME = "John Committer";
    static final String COMMITTER_DATE = "1234566 -0600";
    static final String COMMITTER_DATE_FORMATTED = "1970-01-15T06:56:06-0600";
    static final String COMMIT_TITLE = "Commit title.";
    static final String COMMENT = "Commit title.\n";
    static final String COMMITTER_EMAIL = "jcommitter@nospam.com";

    static GitChangeSet genChangeSet(boolean authorOrCommitter, boolean useLegacyFormat) {
        return GitChangeSetUtil.genChangeSet(authorOrCommitter, useLegacyFormat, true);
    }

    public static GitChangeSet genChangeSet(boolean authorOrCommitter, boolean useLegacyFormat, boolean hasParent) {
        return GitChangeSetUtil.genChangeSet(authorOrCommitter, useLegacyFormat, hasParent, COMMIT_TITLE);
    }

    public static GitChangeSet genChangeSet(boolean authorOrCommitter, boolean useLegacyFormat, boolean hasParent, String commitTitle) {
        return GitChangeSetUtil.genChangeSet(authorOrCommitter, useLegacyFormat, hasParent, commitTitle, false);
    }

    public static GitChangeSet genChangeSet(boolean authorOrCommitter, boolean useLegacyFormat, boolean hasParent, String commitTitle, boolean truncate) {
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add("Some header junk we should ignore...");
        lines.add("header line 2");
        lines.add("commit 123abc456def");
        lines.add("tree 789ghi012jkl");
        if (hasParent) {
            lines.add("parent 345mno678pqr");
        } else {
            lines.add("parent ");
        }
        lines.add("author John Author <jauthor@nospam.com> 1234568 -0600");
        lines.add("committer John Committer <jcommitter@nospam.com> 1234566 -0600");
        lines.add("");
        lines.add("    " + commitTitle);
        lines.add("    Commit extended description.");
        lines.add("");
        if (useLegacyFormat) {
            lines.add(ID);
            lines.add(" create mode 100644 some/file1");
            lines.add(" delete mode 100644 other/file2");
        }
        lines.add(":000000 123456 0000000000000000000000000000000000000000 123abc456def789abc012def345abc678def901a A\tsrc/test/add.file");
        lines.add(":123456 000000 123abc456def789abc012def345abc678def901a 0000000000000000000000000000000000000000 D\tsrc/test/deleted.file");
        lines.add(":123456 789012 123abc456def789abc012def345abc678def901a bc234def567abc890def123abc456def789abc01 M\tsrc/test/modified.file");
        lines.add(":123456 789012 123abc456def789abc012def345abc678def901a bc234def567abc890def123abc456def789abc01 R012\tsrc/test/renamedFrom.file\tsrc/test/renamedTo.file");
        lines.add(":000000 123456 bc234def567abc890def123abc456def789abc01 123abc456def789abc012def345abc678def901a C100\tsrc/test/original.file\tsrc/test/copyOf.file");
        return new GitChangeSet(lines, authorOrCommitter, truncate);
    }

    static void assertChangeSet(GitChangeSet changeSet) {
        TestCase.assertEquals((String)ID, (String)changeSet.getId());
        TestCase.assertEquals((String)COMMIT_TITLE, (String)changeSet.getMsg());
        TestCase.assertEquals((String)"Commit title.\nCommit extended description.\n", (String)changeSet.getComment());
        TestCase.assertEquals((String)"Commit title.\nCommit extended description.\n".replace("\n", "<br>"), (String)changeSet.getCommentAnnotated());
        HashSet<String> expectedAffectedPaths = new HashSet<String>(7);
        expectedAffectedPaths.add("src/test/add.file");
        expectedAffectedPaths.add("src/test/deleted.file");
        expectedAffectedPaths.add("src/test/modified.file");
        expectedAffectedPaths.add("src/test/renamedFrom.file");
        expectedAffectedPaths.add("src/test/renamedTo.file");
        expectedAffectedPaths.add("src/test/copyOf.file");
        TestCase.assertEquals(expectedAffectedPaths, (Object)changeSet.getAffectedPaths());
        Collection actualPaths = changeSet.getPaths();
        TestCase.assertEquals((int)6, (int)actualPaths.size());
        block16: for (GitChangeSet.Path path : actualPaths) {
            if (null == path.getPath()) continue;
            switch (path.getPath()) {
                case "src/test/add.file": {
                    TestCase.assertEquals((Object)EditType.ADD, (Object)path.getEditType());
                    TestCase.assertNull((Object)path.getSrc());
                    TestCase.assertEquals((String)"123abc456def789abc012def345abc678def901a", (String)path.getDst());
                    continue block16;
                }
                case "src/test/deleted.file": {
                    TestCase.assertEquals((Object)EditType.DELETE, (Object)path.getEditType());
                    TestCase.assertEquals((String)"123abc456def789abc012def345abc678def901a", (String)path.getSrc());
                    TestCase.assertNull((Object)path.getDst());
                    continue block16;
                }
                case "src/test/modified.file": {
                    TestCase.assertEquals((Object)EditType.EDIT, (Object)path.getEditType());
                    TestCase.assertEquals((String)"123abc456def789abc012def345abc678def901a", (String)path.getSrc());
                    TestCase.assertEquals((String)"bc234def567abc890def123abc456def789abc01", (String)path.getDst());
                    continue block16;
                }
                case "src/test/renamedFrom.file": {
                    TestCase.assertEquals((Object)EditType.DELETE, (Object)path.getEditType());
                    TestCase.assertEquals((String)"123abc456def789abc012def345abc678def901a", (String)path.getSrc());
                    TestCase.assertEquals((String)"bc234def567abc890def123abc456def789abc01", (String)path.getDst());
                    continue block16;
                }
                case "src/test/renamedTo.file": {
                    TestCase.assertEquals((Object)EditType.ADD, (Object)path.getEditType());
                    TestCase.assertEquals((String)"123abc456def789abc012def345abc678def901a", (String)path.getSrc());
                    TestCase.assertEquals((String)"bc234def567abc890def123abc456def789abc01", (String)path.getDst());
                    continue block16;
                }
                case "src/test/copyOf.file": {
                    TestCase.assertEquals((Object)EditType.ADD, (Object)path.getEditType());
                    TestCase.assertEquals((String)"bc234def567abc890def123abc456def789abc01", (String)path.getSrc());
                    TestCase.assertEquals((String)"123abc456def789abc012def345abc678def901a", (String)path.getDst());
                    continue block16;
                }
            }
            TestCase.fail((String)"Unrecognized path.");
        }
    }

    public static GitChangeSet genChangeSet(ObjectId sha1, String gitImplementation, boolean authorOrCommitter) throws IOException, InterruptedException {
        EnvVars envVars = new EnvVars();
        StreamTaskListener listener = StreamTaskListener.fromStdout();
        GitClient git = Git.with((TaskListener)listener, (EnvVars)envVars).in(new FilePath(new File("."))).using(gitImplementation).getClient();
        return new GitChangeSet(git.showRevision(sha1), authorOrCommitter);
    }
}

