/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.User;
import hudson.model.UserProperty;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitChangeSetUtil;
import hudson.tasks.Mailer;
import java.io.IOException;
import java.util.Collections;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.springframework.security.authentication.DisabledException;

public class GitChangeSetTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    private final Random random = new Random();

    @Test
    public void testFindOrCreateUser() {
        GitChangeSet committerCS = GitChangeSetUtil.genChangeSet(false, false);
        String email = "jauthor@nospam.com";
        boolean createAccountBasedOnEmail = true;
        boolean useExistingAccountBasedOnEmail = false;
        User user = committerCS.findOrCreateUser("John Author", "jauthor@nospam.com", true, false);
        Assert.assertNotNull((Object)user);
        Mailer.UserProperty property = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class);
        Assert.assertNotNull((Object)property);
        String address = property.getAddress();
        Assert.assertNotNull((Object)address);
        Assert.assertEquals((Object)"jauthor@nospam.com", (Object)address);
        Assert.assertEquals((Object)User.getUnknown(), (Object)committerCS.findOrCreateUser(null, "jauthor@nospam.com", false, false));
        Assert.assertEquals((Object)User.getUnknown(), (Object)committerCS.findOrCreateUser(null, "jauthor@nospam.com", true, false));
    }

    @Test
    public void testFindOrCreateUserNullAuthorEmail() {
        GitChangeSet changeset = GitChangeSetUtil.genChangeSet(this.random.nextBoolean(), this.random.nextBoolean());
        boolean createAccountBasedOnEmail = true;
        boolean useExistingAccountBasedOnEmail = this.random.nextBoolean();
        String csAuthor = "ada";
        String csAuthorEmail = null;
        User user = changeset.findOrCreateUser("ada", csAuthorEmail, true, useExistingAccountBasedOnEmail);
        MatcherAssert.assertThat((Object)user, (Matcher)Matchers.is((Object)User.getUnknown()));
    }

    @Test
    public void testFindOrCreateUserEmptyAuthorEmail() {
        GitChangeSet changeset = GitChangeSetUtil.genChangeSet(this.random.nextBoolean(), this.random.nextBoolean());
        boolean createAccountBasedOnEmail = true;
        boolean useExistingAccountBasedOnEmail = this.random.nextBoolean();
        String csAuthor = "babbage";
        String csAuthorEmail = "";
        User user = changeset.findOrCreateUser("babbage", "", true, useExistingAccountBasedOnEmail);
        MatcherAssert.assertThat((Object)user, (Matcher)Matchers.is((Object)User.getUnknown()));
    }

    @Test
    public void testFindOrCreateUserEmptyAuthorEmailDoNotCreateAccountBasedOnEmail() {
        GitChangeSet changeset = GitChangeSetUtil.genChangeSet(this.random.nextBoolean(), this.random.nextBoolean());
        boolean createAccountBasedOnEmail = false;
        boolean useExistingAccountBasedOnEmail = this.random.nextBoolean();
        String csAuthor = "babbage-do-not-create";
        String csAuthorEmail = "";
        User user = changeset.findOrCreateUser("babbage-do-not-create", "", false, useExistingAccountBasedOnEmail);
        MatcherAssert.assertThat((Object)user, (Matcher)Matchers.is((Object)User.getUnknown()));
    }

    @Test
    public void testFindOrCreateUserEmptyAuthorDoNotCreateAccountBasedOnEmail() {
        GitChangeSet changeset = GitChangeSetUtil.genChangeSet(this.random.nextBoolean(), this.random.nextBoolean());
        boolean createAccountBasedOnEmail = false;
        boolean useExistingAccountBasedOnEmail = this.random.nextBoolean();
        String csAuthor = "";
        String csAuthorEmail = "babbage-empty-author@example.com";
        User user = changeset.findOrCreateUser("", "babbage-empty-author@example.com", false, useExistingAccountBasedOnEmail);
        MatcherAssert.assertThat((Object)user, (Matcher)Matchers.is((Object)User.getUnknown()));
    }

    @Test
    public void testFindOrCreateUserBadAuthorEmailDoNotCreateAccountBasedOnEmail() {
        GitChangeSet changeset = GitChangeSetUtil.genChangeSet(this.random.nextBoolean(), this.random.nextBoolean());
        boolean createAccountBasedOnEmail = false;
        boolean useExistingAccountBasedOnEmail = this.random.nextBoolean();
        String csAuthor = "babbage-do-not-create";
        String csAuthorEmail = "@";
        User user = changeset.findOrCreateUser("babbage-do-not-create", "@", false, useExistingAccountBasedOnEmail);
        MatcherAssert.assertThat((Object)user, (Matcher)Matchers.is((Object)User.getUnknown()));
    }

    @Test
    public void testFindOrCreateUserOKAuthorEmailDoNotCreateAccountBasedOnEmail() {
        GitChangeSet changeset = GitChangeSetUtil.genChangeSet(this.random.nextBoolean(), this.random.nextBoolean());
        boolean createAccountBasedOnEmail = false;
        boolean useExistingAccountBasedOnEmail = this.random.nextBoolean();
        String csAuthor = "babbage-will-be-created";
        String csAuthorEmail = "babbage-will-be-created@";
        User user = changeset.findOrCreateUser("babbage-will-be-created", "babbage-will-be-created@", false, useExistingAccountBasedOnEmail);
        MatcherAssert.assertThat((Object)user.getFullName(), (Matcher)Matchers.is((Object)"babbage-will-be-created"));
    }

    @Test
    public void testFindOrCreateUserBlankAuthorEmail() {
        GitChangeSet changeset = GitChangeSetUtil.genChangeSet(this.random.nextBoolean(), this.random.nextBoolean());
        boolean createAccountBasedOnEmail = true;
        boolean useExistingAccountBasedOnEmail = false;
        String csAuthor = "candide";
        String csAuthorEmail = " ";
        User user = changeset.findOrCreateUser("candide", " ", true, false);
        MatcherAssert.assertThat((Object)user.getFullName(), (Matcher)Matchers.is((Object)"candide"));
    }

    @Test
    public void testFindOrCreateUserBlankAuthorEmailUseExistingAccountBasedOnEmail() {
        GitChangeSet changeset = GitChangeSetUtil.genChangeSet(this.random.nextBoolean(), this.random.nextBoolean());
        boolean createAccountBasedOnEmail = true;
        boolean useExistingAccountBasedOnEmail = true;
        String csAuthor = "cosimo";
        String csAuthorEmail = " ";
        User user = changeset.findOrCreateUser("cosimo", " ", true, true);
        MatcherAssert.assertThat((Object)user.getFullName(), (Matcher)Matchers.is((Object)"cosimo"));
    }

    @Test
    public void testFindOrCreateUserValidAuthorEmailUseExistingAccountBasedOnEmail() {
        GitChangeSet changeset = GitChangeSetUtil.genChangeSet(this.random.nextBoolean(), this.random.nextBoolean());
        boolean createAccountBasedOnEmail = true;
        boolean useExistingAccountBasedOnEmail = true;
        String csAuthor = "dante";
        String csAuthorEmail = "alighieri@example.com";
        User user = changeset.findOrCreateUser("dante", "alighieri@example.com", true, true);
        MatcherAssert.assertThat((Object)user.getFullName(), (Matcher)Matchers.is((Object)"dante"));
    }

    @Test
    public void testFindOrCreateUserUseExistingAuthorEmailUseExistingAccountBasedOnEmail() {
        GitChangeSet changeset = GitChangeSetUtil.genChangeSet(this.random.nextBoolean(), this.random.nextBoolean());
        boolean createAccountBasedOnEmail = true;
        boolean useExistingAccountBasedOnEmail = true;
        String csAuthor = "ecco";
        String csAuthorEmail = "umberto@example.com";
        User user = changeset.findOrCreateUser("ecco", "umberto@example.com", true, true);
        MatcherAssert.assertThat((Object)user.getFullName(), (Matcher)Matchers.is((Object)"ecco"));
        User existing = changeset.findOrCreateUser("ecco", "umberto@example.com", true, true);
        MatcherAssert.assertThat((Object)existing, (Matcher)Matchers.is((Object)user));
    }

    @Test
    public void testFindOrCreateUserHandlesAuthenticationException() {
        GitChangeSet changeset = GitChangeSetUtil.genChangeSet(this.random.nextBoolean(), this.random.nextBoolean());
        boolean createAccountBasedOnEmail = false;
        boolean useExistingAccountBasedOnEmail = true;
        String csAuthor = "disabled_user";
        String csAuthorEmail = "disabled_user@example.com";
        try (MockedStatic user = Mockito.mockStatic(User.class);){
            user.when(() -> User.get((String)"disabled_user", (boolean)false, Collections.emptyMap())).thenThrow(new Throwable[]{new DisabledException("The user \"disabled_user\" is administratively disabled")});
            User actual = changeset.findOrCreateUser("disabled_user", "disabled_user@example.com", false, true);
            Assert.assertEquals((Object)User.getUnknown(), (Object)actual);
            user.verify(() -> User.get((String)"disabled_user", (boolean)false, Collections.emptyMap()), Mockito.times((int)1));
            user.verify(User::getUnknown, Mockito.times((int)2));
        }
    }

    @Test
    @Deprecated
    public void testFindOrCreateUserBasedOnExistingUsersEmail() throws IOException {
        GitChangeSet committerCS = GitChangeSetUtil.genChangeSet(true, false);
        String existingUserId = "An existing user";
        String existingUserFullName = "Some FullName";
        String email = "jcommitter@nospam.com";
        boolean createAccountBasedOnEmail = true;
        boolean useExistingAccountBasedOnEmail = true;
        Assert.assertNull((Object)User.get((String)"jcommitter@nospam.com", (boolean)false));
        User existingUser = User.get((String)"An existing user", (boolean)true);
        MatcherAssert.assertThat((Object)existingUser, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        existingUser.setFullName("Some FullName");
        existingUser.addProperty((UserProperty)new Mailer.UserProperty("jcommitter@nospam.com"));
        User user = committerCS.findOrCreateUser("John Committer", "jcommitter@nospam.com", true, true);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)user.getId(), (Object)"An existing user");
        Assert.assertEquals((Object)user.getFullName(), (Object)"Some FullName");
        Mailer.UserProperty property = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class);
        Assert.assertNotNull((Object)property);
        String address = property.getAddress();
        Assert.assertNotNull((Object)address);
        Assert.assertEquals((Object)"jcommitter@nospam.com", (Object)address);
        Assert.assertEquals((Object)User.getUnknown(), (Object)committerCS.findOrCreateUser(null, "jcommitter@nospam.com", false, true));
        Assert.assertEquals((Object)User.getUnknown(), (Object)committerCS.findOrCreateUser(null, "jcommitter@nospam.com", true, true));
    }

    @Test
    @Deprecated
    public void findOrCreateByFullName() throws Exception {
        GitChangeSet cs = GitChangeSetUtil.genChangeSet(false, false);
        User user = User.get((String)"john");
        user.setFullName("John Committer");
        user.addProperty((UserProperty)new Mailer.UserProperty("jcommitter@nospam.com"));
        Assert.assertEquals((Object)user, (Object)cs.getAuthor());
    }
}

