/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.impl.CheckoutOption;
import hudson.plugins.git.extensions.impl.GitLFSPull;
import hudson.plugins.git.extensions.impl.SubmoduleOption;
import hudson.scm.SCM;
import hudson.util.DescribableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.jenkinsci.plugins.workflow.cps.SnippetizerTester;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.scm.GenericSCMStep;
import org.junit.ClassRule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class CheckoutStepSnippetizerTest {
    @ClassRule
    public static JenkinsRule r = new JenkinsRule();
    private final Random random = new Random();
    private final SnippetizerTester tester = new SnippetizerTester(r);
    private final String url = "https://github.com/jenkinsci/git-plugin.git";
    private final String remoteName = "";
    private final String remoteRefspec = "";
    private final String credentialsId = "";
    private final UserRemoteConfig userRemoteConfig = new UserRemoteConfig("https://github.com/jenkinsci/git-plugin.git", "", "", "");
    private final List<UserRemoteConfig> userRemoteConfigList = new ArrayList<UserRemoteConfig>(List.of(this.userRemoteConfig));
    private final String branchName = "";
    private final BranchSpec branchSpec = new BranchSpec("");
    private final List<BranchSpec> branchSpecList = new ArrayList<BranchSpec>(List.of(this.branchSpec));
    private final String gitTool;
    private final GitRepositoryBrowser browser = null;
    private final List<GitSCMExtension> extensionList = new ArrayList<GitSCMExtension>();
    private final GitSCM databoundGit = new GitSCM(this.userRemoteConfigList, this.branchSpecList, this.browser, this.gitTool, this.extensionList);
    private final GitSCM convenienceGit = new GitSCM("https://github.com/jenkinsci/git-plugin.git");
    private final GenericSCMStep checkoutStep;
    private final String junkBranches = "branches: [[name: '**']], ";
    private final String junkExtensions = "extensions: [], ";
    private final String remoteConfig = "userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']]";

    public CheckoutStepSnippetizerTest() {
        this.gitTool = null;
        if (!this.random.nextBoolean()) {
            // empty if block
        }
        this.checkoutStep = new GenericSCMStep((SCM)this.databoundGit);
        this.junkBranches = "branches: [[name: '**']], ";
        this.junkExtensions = "extensions: [], ";
        this.remoteConfig = "userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']]";
    }

    @Test
    public void checkoutSimplest() throws Exception {
        this.tester.assertRoundTrip((Step)this.checkoutStep, "checkout scmGit(branches: [[name: '**']], extensions: [], userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
        this.tester.assertParseStep((Step)this.checkoutStep, "checkout scmGit(branches: [[name: '**']], " + (this.random.nextBoolean() ? "extensions: [], " : "") + "userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
    }

    @Test
    public void checkoutNoPoll() throws Exception {
        this.checkoutStep.setPoll(false);
        this.tester.assertRoundTrip((Step)this.checkoutStep, "checkout poll: false, scm: scmGit(branches: [[name: '**']], extensions: [], userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
        this.tester.assertParseStep((Step)this.checkoutStep, "checkout poll: false, scm: scmGit(branches: [[name: '**']], " + (this.random.nextBoolean() ? "extensions: [], " : "") + "userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
    }

    @Test
    public void checkoutNoChangelog() throws Exception {
        this.checkoutStep.setChangelog(false);
        this.tester.assertRoundTrip((Step)this.checkoutStep, "checkout changelog: false, scm: scmGit(branches: [[name: '**']], extensions: [], userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
        this.tester.assertParseStep((Step)this.checkoutStep, "checkout changelog: false, scm: scmGit(branches: [[name: '**']], " + (this.random.nextBoolean() ? "extensions: [], " : "") + "userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
    }

    @Test
    public void checkoutCredentials() throws Exception {
        String myCredential = "my-credential";
        UserRemoteConfig config = new UserRemoteConfig("https://github.com/jenkinsci/git-plugin.git", "", "", myCredential);
        ArrayList<UserRemoteConfig> configList = new ArrayList<UserRemoteConfig>(List.of(config));
        GitSCM gitSCM = new GitSCM(configList, this.branchSpecList, this.browser, this.gitTool, this.extensionList);
        GenericSCMStep step = new GenericSCMStep((SCM)gitSCM);
        this.tester.assertRoundTrip((Step)step, "checkout scmGit(branches: [[name: '**']], extensions: [], userRemoteConfigs: [[credentialsId: '" + myCredential + "', url: 'https://github.com/jenkinsci/git-plugin.git']])");
        this.tester.assertParseStep((Step)step, "checkout scmGit(branches: [[name: '**']], " + (this.random.nextBoolean() ? "extensions: [], " : "") + "userRemoteConfigs: [[credentialsId: '" + myCredential + "', url: 'https://github.com/jenkinsci/git-plugin.git']])");
    }

    @Test
    public void checkoutBranch() throws Exception {
        String branch = "4.10.x";
        ArrayList<BranchSpec> branchList = new ArrayList<BranchSpec>(List.of(new BranchSpec(branch)));
        GitSCM gitSCM = new GitSCM(this.userRemoteConfigList, branchList, this.browser, this.gitTool, this.extensionList);
        GenericSCMStep step = new GenericSCMStep((SCM)gitSCM);
        this.tester.assertRoundTrip((Step)step, "checkout scmGit(branches: [[name: '" + branch + "']], extensions: [], userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
        this.tester.assertParseStep((Step)step, "checkout scmGit(branches: [[name: '" + branch + "']], " + (this.random.nextBoolean() ? "extensions: [], " : "") + "userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
    }

    @Test
    public void checkoutSubmoduleSimplest() throws Exception {
        GitSCM gitSCM = new GitSCM("https://github.com/jenkinsci/git-plugin.git");
        DescribableList extensions = gitSCM.getExtensions();
        extensions.add(new SubmoduleOption());
        GenericSCMStep step = new GenericSCMStep((SCM)gitSCM);
        String testedExtensions = "extensions: [submodule()], ";
        this.tester.assertRoundTrip((Step)step, "checkout scmGit(branches: [[name: '**']], " + testedExtensions + "userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
        this.tester.assertParseStep((Step)step, "checkout scmGit(branches: [[name: '**']], " + testedExtensions + "userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
    }

    @Test
    public void checkoutSubmoduleOldConstructorMinimalArgs() throws Exception {
        GitSCM gitSCM = new GitSCM("https://github.com/jenkinsci/git-plugin.git");
        DescribableList extensions = gitSCM.getExtensions();
        boolean disableSubmodules = false;
        boolean recursiveSubmodules = false;
        boolean trackingSubmodules = false;
        String reference = null;
        Integer timeout = null;
        boolean parentCredentials = false;
        extensions.add(new SubmoduleOption(disableSubmodules, recursiveSubmodules, trackingSubmodules, reference, timeout, parentCredentials));
        GenericSCMStep step = new GenericSCMStep((SCM)gitSCM);
        String testedExtensions = "extensions: [submodule()], ";
        this.tester.assertRoundTrip((Step)step, "checkout scmGit(branches: [[name: '**']], " + testedExtensions + "userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
        this.tester.assertParseStep((Step)step, "checkout scmGit(branches: [[name: '**']], " + testedExtensions + "userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
    }

    @Test
    public void checkoutSubmoduleOldConstructorReferenceRepo() throws Exception {
        GitSCM gitSCM = new GitSCM("https://github.com/jenkinsci/git-plugin.git");
        DescribableList extensions = gitSCM.getExtensions();
        boolean disableSubmodules = false;
        boolean recursiveSubmodules = false;
        boolean trackingSubmodules = false;
        String reference = "/var/cache/git-plugin.git";
        Integer timeout = null;
        boolean parentCredentials = false;
        extensions.add(new SubmoduleOption(disableSubmodules, recursiveSubmodules, trackingSubmodules, reference, timeout, parentCredentials));
        GenericSCMStep step = new GenericSCMStep((SCM)gitSCM);
        String testedExtensions = "extensions: [submodule(reference: '" + reference + "')], ";
        this.tester.assertRoundTrip((Step)step, "checkout scmGit(branches: [[name: '**']], " + testedExtensions + "userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
        this.tester.assertParseStep((Step)step, "checkout scmGit(branches: [[name: '**']], " + testedExtensions + "userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
    }

    @Test
    public void checkoutSubmoduleOldConstructorDisableSubmodules() throws Exception {
        GitSCM gitSCM = new GitSCM("https://github.com/jenkinsci/git-plugin.git");
        DescribableList extensions = gitSCM.getExtensions();
        boolean disableSubmodules = true;
        boolean recursiveSubmodules = false;
        boolean trackingSubmodules = false;
        String reference = null;
        Integer timeout = null;
        boolean parentCredentials = false;
        extensions.add(new SubmoduleOption(disableSubmodules, recursiveSubmodules, trackingSubmodules, reference, timeout, parentCredentials));
        GenericSCMStep step = new GenericSCMStep((SCM)gitSCM);
        String testedExtensions = "extensions: [submodule(disableSubmodules: true)], ";
        this.tester.assertRoundTrip((Step)step, "checkout scmGit(branches: [[name: '**']], " + testedExtensions + "userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
        this.tester.assertParseStep((Step)step, "checkout scmGit(branches: [[name: '**']], " + testedExtensions + "userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
    }

    @Test
    public void checkoutTimeoutCheckoutDefault() throws Exception {
        GitSCM gitSCM = new GitSCM("https://github.com/jenkinsci/git-plugin.git");
        DescribableList extensions = gitSCM.getExtensions();
        Integer timeout = null;
        extensions.add(new CheckoutOption(timeout));
        GenericSCMStep step = new GenericSCMStep((SCM)gitSCM);
        String testedExtensions = "extensions: [checkoutOption()], ";
        this.tester.assertRoundTrip((Step)step, "checkout scmGit(branches: [[name: '**']], " + testedExtensions + "userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
        this.tester.assertParseStep((Step)step, "checkout scmGit(branches: [[name: '**']], " + testedExtensions + "userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
    }

    @Test
    public void checkoutTimeoutCheckoutNonDefault() throws Exception {
        GitSCM gitSCM = new GitSCM("https://github.com/jenkinsci/git-plugin.git");
        DescribableList extensions = gitSCM.getExtensions();
        Integer timeout = 347;
        extensions.add(new CheckoutOption(timeout));
        GenericSCMStep step = new GenericSCMStep((SCM)gitSCM);
        String testedExtensions = "extensions: [checkoutOption(" + timeout + ")], ";
        this.tester.assertRoundTrip((Step)step, "checkout scmGit(branches: [[name: '**']], " + testedExtensions + "userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
        this.tester.assertParseStep((Step)step, "checkout scmGit(branches: [[name: '**']], " + testedExtensions + "userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
    }

    @Test
    public void checkoutLargeFileSupport() throws Exception {
        GitSCM gitSCM = new GitSCM("https://github.com/jenkinsci/git-plugin.git");
        DescribableList extensions = gitSCM.getExtensions();
        extensions.add(new GitLFSPull());
        GenericSCMStep step = new GenericSCMStep((SCM)gitSCM);
        String testedExtensions = "extensions: [lfs()], ";
        this.tester.assertRoundTrip((Step)step, "checkout scmGit(branches: [[name: '**']], " + testedExtensions + "userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
        this.tester.assertParseStep((Step)step, "checkout scmGit(branches: [[name: '**']], " + testedExtensions + "userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']])");
    }
}

