/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class MessageExclusion
extends GitSCMExtension {
    private String excludedMessage;
    private volatile transient Pattern excludedPattern;

    @DataBoundConstructor
    public MessageExclusion(String excludedMessage) {
        this.excludedMessage = excludedMessage;
    }

    @Override
    public boolean requiresWorkspaceForPolling() {
        return true;
    }

    public String getExcludedMessage() {
        return this.excludedMessage;
    }

    @Override
    @CheckForNull
    public Boolean isRevExcluded(GitSCM scm, GitClient git, GitChangeSet commit, TaskListener listener, BuildData buildData) throws IOException, InterruptedException, GitException {
        String msg;
        if (this.excludedPattern == null) {
            this.excludedPattern = Pattern.compile(this.excludedMessage);
        }
        if (this.excludedPattern.matcher(msg = commit.getComment()).matches()) {
            listener.getLogger().println("Ignored commit " + commit.getId() + ": Found excluded message: " + msg);
            return true;
        }
        return null;
    }

    @Override
    public void beforeCheckout(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener) throws IOException, InterruptedException, GitException {
        if (build != null && build.getClass().getName().startsWith("org.jenkinsci.plugins.workflow.job.")) {
            listener.getLogger().println("DEPRECATED: Message exclusion during polling is deprecated for Pipeline jobs. Use the Pipeline SCM trait instead.");
        }
    }

    @Extension
    public static class DescriptorImpl
    extends GitSCMExtensionDescriptor {
        public FormValidation doCheckExcludedMessage(@QueryParameter String value) {
            try {
                Pattern.compile(value);
            }
            catch (PatternSyntaxException ex) {
                return FormValidation.error((String)ex.getMessage());
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return "Polling ignores commits with certain messages";
        }
    }
}

