/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser.casc;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.plugins.git.browser.GitLab;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@Extension(optional=true)
public class GitLabConfigurator
extends BaseConfigurator<GitLab> {
    protected GitLab instance(Mapping mapping, ConfigurationContext context) throws ConfiguratorException {
        String version;
        if (mapping == null) {
            return new GitLab("");
        }
        String url = mapping.get((Object)"repoUrl") != null ? mapping.getScalarValue("repoUrl") : "";
        String string = version = mapping.get((Object)"version") != null ? mapping.getScalarValue("version") : "";
        if (version.isEmpty()) {
            return new GitLab(url);
        }
        GitLab gitlab = new GitLab(url, version);
        return gitlab;
    }

    @CheckForNull
    public CNode describe(GitLab instance, ConfigurationContext context) throws Exception {
        Mapping mapping = new Mapping();
        mapping.put("repoUrl", (String)StringUtils.defaultIfBlank((CharSequence)instance.getRepoUrl(), (CharSequence)""));
        mapping.put("version", String.valueOf(instance.getVersion()));
        return mapping;
    }

    public boolean canConfigure(Class clazz) {
        return clazz == GitLab.class;
    }

    public Class<GitLab> getTarget() {
        return GitLab.class;
    }

    @NonNull
    public List<Configurator<GitLab>> getConfigurators(ConfigurationContext context) {
        return Collections.singletonList(this);
    }
}

