/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.browsers.QueryBuilder;
import java.io.IOException;
import java.net.URL;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class Stash
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public Stash(String repoUrl) {
        super(repoUrl);
    }

    private QueryBuilder param(URL url) {
        return new QueryBuilder(url.getQuery());
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        URL url = this.getUrl();
        return new URL(url, url.getPath() + "commits/" + changeSet.getId());
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        URL url = this.getUrl();
        if (path.getEditType() == EditType.DELETE) {
            return new URL(url, url.getPath() + "diff/" + path.getPath() + String.valueOf(this.param(url).add("at=" + changeSet.getParentCommit()).add("until=" + changeSet.getId())));
        }
        return new URL(url, url.getPath() + "diff/" + path.getPath() + String.valueOf(this.param(url).add("at=" + changeSet.getId()).add("until=" + changeSet.getId())));
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        URL url = this.getUrl();
        if (path.getEditType() == EditType.DELETE) {
            return Stash.encodeURL(new URL(url, url.getPath() + "browse/" + path.getPath() + String.valueOf(this.param(url).add("at=" + changeSet.getParentCommit()))));
        }
        return Stash.encodeURL(new URL(url, url.getPath() + "browse/" + path.getPath() + String.valueOf(this.param(url).add("at=" + changeSet.getId()))));
    }

    @Extension
    public static class StashDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        @NonNull
        public String getDisplayName() {
            return "stash";
        }

        public Stash newInstance(@NonNull StaplerRequest2 req, @NonNull JSONObject jsonObject) throws Descriptor.FormException {
            return (Stash)((Object)req.bindJSON(Stash.class, jsonObject));
        }
    }
}

