/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.EnvVars;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeSet;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.IDN;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

public abstract class GitRepositoryBrowser
extends RepositoryBrowser<GitChangeSet> {
    private String url;
    private static final Logger LOGGER = Logger.getLogger(GitRepositoryBrowser.class.getName());
    private static final Pattern SUFFIXES = Pattern.compile(".*[.](corp|home|local|localnet)$");
    private static final long serialVersionUID = 1L;

    @Deprecated
    protected GitRepositoryBrowser() {
    }

    protected GitRepositoryBrowser(String repourl) {
        this.url = repourl;
    }

    public final String getRepoUrl() {
        return this.url;
    }

    public final URL getUrl() throws IOException {
        Job job;
        String u = this.url;
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        if (req != null && (job = (Job)req.findAncestorObject(Job.class)) != null) {
            EnvVars env;
            try {
                env = job.getEnvironment(null, TaskListener.NULL);
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to retrieve job environment", e);
            }
            u = env.expand(this.url);
        }
        if (this.getNormalizeUrl()) {
            return GitRepositoryBrowser.normalizeToEndWithSlash((URL)new URL(u));
        }
        return new URL(u);
    }

    public abstract URL getDiffLink(GitChangeSet.Path var1) throws IOException;

    public abstract URL getFileLink(GitChangeSet.Path var1) throws IOException, URISyntaxException;

    @CheckForNull
    public URL getChangeSetLink(String commitId) throws IOException {
        if (commitId != null && !commitId.isBlank()) {
            return this.getChangeSetLink(new CommitChangeSet(commitId));
        }
        return null;
    }

    protected boolean getNormalizeUrl() {
        return true;
    }

    protected int getIndexOfPath(GitChangeSet.Path path) throws IOException {
        String pathAsString = path.getPath();
        GitChangeSet changeSet = path.getChangeSet();
        int i = 0;
        for (String affected : changeSet.getAffectedPaths()) {
            if (affected.compareTo(pathAsString) >= 0) continue;
            ++i;
        }
        return i;
    }

    public static URL encodeURL(URL url) throws IOException {
        try {
            return new URI(url.getProtocol(), url.getUserInfo(), IDN.toASCII(url.getHost()), url.getPort(), url.getPath(), url.getQuery(), url.getRef()).toURL();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    protected static boolean initialChecksAndReturnOk(Item project, String cleanUrl) {
        if (cleanUrl == null) {
            return true;
        }
        if (project == null || !project.hasPermission(Item.CONFIGURE)) {
            return true;
        }
        return cleanUrl.contains("$");
    }

    protected static boolean validateUrl(String url) throws URISyntaxException {
        try {
            URL urlToValidate = new URL(url);
            String hostname = urlToValidate.getHost();
            if (hostname == null) {
                LOGGER.log(Level.FINE, "Invalid hostname validating URL {0}", url);
                return false;
            }
            if (SUFFIXES.matcher(hostname).matches()) {
                return true;
            }
            if (InetAddress.getByName(hostname) == null) {
                LOGGER.log(Level.FINE, "Host unknown validating URL {0}", url);
                return false;
            }
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.FINE, "Malformed URL exception validating URL " + url, ex);
            return false;
        }
        catch (UnknownHostException ex) {
            LOGGER.log(Level.FINE, "Unknown host exception validating URL " + url, ex);
            return false;
        }
        return true;
    }

    private static class CommitChangeSet
    extends GitChangeSet {
        private final String id;

        CommitChangeSet(String id) {
            super(Collections.emptyList(), false);
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommitChangeSet that = (CommitChangeSet)((Object)o);
            return Objects.equals(this.id, that.id);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.id);
        }
    }
}

